/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.ApplicationEntityConfigurationDialog;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;

public class NetworkApplicationConfigurationDialog {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationConfigurationDialog.java,v 1.16 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NetworkApplicationConfigurationDialog.class);
    protected static String resourceBundleName = "com.pixelmed.network.NetworkApplicationConfigurationDialog";
    protected ResourceBundle resourceBundle;
    protected NetworkApplicationInformation networkApplicationInformation;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected JTextField calledAETitleField;
    protected JTextField callingAETitleField;
    protected JTextField listeningPortField;
    protected JTextField acceptorMaximumLengthReceivedField;
    protected JTextField acceptorSocketReceiveBufferSizeField;
    protected JTextField acceptorSocketSendBufferSizeField;
    protected JTextField initiatorMaximumLengthReceivedField;
    protected JTextField initiatorSocketReceiveBufferSizeField;
    protected JTextField initiatorSocketSendBufferSizeField;
    Component componentToCenterDialogOver;
    JDialog dialog;

    protected String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(Component component, NetworkApplicationInformation networkApplicationInformation, String string, String string2) {
        Set set;
        String string3 = null;
        if (networkApplicationInformation != null && (set = networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string3 = (String)JOptionPane.showInputDialog(component, string, string2, 3, null, objectArray, null);
        }
        return string3;
    }

    public NetworkApplicationConfigurationDialog(Component component, NetworkApplicationInformation networkApplicationInformation, NetworkApplicationProperties networkApplicationProperties) throws DicomNetworkException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        this.networkApplicationInformation = networkApplicationInformation;
        this.networkApplicationProperties = networkApplicationProperties;
        this.resourceBundle = ResourceBundle.getBundle(resourceBundleName);
        this.componentToCenterDialogOver = component;
        this.dialog = new JDialog();
        this.dialog.setModal(true);
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this.componentToCenterDialogOver);
        this.dialog.setDefaultCloseOperation(0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 20, 5, 20));
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(compoundBorder);
        Object object5 = new JLabel(this.resourceBundle.getString("listenerHeaderLabelText") + ":");
        jPanel.add((Component)object5);
        jPanel.add(new JLabel(""));
        try {
            object5 = NetworkInterface.getNetworkInterfaces();
            while (object5.hasMoreElements()) {
                object4 = (NetworkInterface)object5.nextElement();
                object3 = ((NetworkInterface)object4).getInetAddresses();
                while (object3.hasMoreElements()) {
                    serializable = object3.nextElement();
                    if (((InetAddress)serializable).isLoopbackAddress()) continue;
                    object2 = ((InetAddress)serializable).getCanonicalHostName();
                    jPanel.add(new JLabel((String)object2 + ": ", 4));
                    object = ((InetAddress)serializable).getHostAddress();
                    jPanel.add(new JLabel((String)object));
                }
            }
        }
        catch (SocketException socketException) {
            System.err.println(socketException);
        }
        object5 = new JLabel(this.resourceBundle.getString("callingAETitleLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("callingAETitleJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.callingAETitleField = new JTextField();
        this.callingAETitleField.setText(networkApplicationProperties.getCallingAETitle());
        jPanel.add(this.callingAETitleField);
        this.callingAETitleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("calledAETitleLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("calledAETitleJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.calledAETitleField = new JTextField();
        this.calledAETitleField.setText(networkApplicationProperties.getCalledAETitle());
        jPanel.add(this.calledAETitleField);
        this.calledAETitleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("listeningPortLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("listeningPortJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.listeningPortField = new JTextField();
        this.listeningPortField.setText(Integer.toString(networkApplicationProperties.getListeningPort()));
        jPanel.add(this.listeningPortField);
        this.listeningPortField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("acceptorMaximumLengthReceivedLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("acceptorMaximumLengthReceivedJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.acceptorMaximumLengthReceivedField = new JTextField();
        this.acceptorMaximumLengthReceivedField.setText(Integer.toString(networkApplicationProperties.getAcceptorMaximumLengthReceived()));
        jPanel.add(this.acceptorMaximumLengthReceivedField);
        this.acceptorMaximumLengthReceivedField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("acceptorSocketReceiveBufferSizeLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("acceptorSocketReceiveBufferSizeJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.acceptorSocketReceiveBufferSizeField = new JTextField();
        this.acceptorSocketReceiveBufferSizeField.setText(Integer.toString(networkApplicationProperties.getAcceptorSocketReceiveBufferSize()));
        jPanel.add(this.acceptorSocketReceiveBufferSizeField);
        this.acceptorSocketReceiveBufferSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("acceptorSocketSendBufferSizeLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("acceptorSocketSendBufferSizeJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.acceptorSocketSendBufferSizeField = new JTextField();
        this.acceptorSocketSendBufferSizeField.setText(Integer.toString(networkApplicationProperties.getAcceptorSocketSendBufferSize()));
        jPanel.add(this.acceptorSocketSendBufferSizeField);
        this.acceptorSocketSendBufferSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("initiatorMaximumLengthReceivedLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("initiatorMaximumLengthReceivedJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.initiatorMaximumLengthReceivedField = new JTextField();
        this.initiatorMaximumLengthReceivedField.setText(Integer.toString(networkApplicationProperties.getInitiatorMaximumLengthReceived()));
        jPanel.add(this.initiatorMaximumLengthReceivedField);
        this.initiatorMaximumLengthReceivedField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("initiatorSocketReceiveBufferSizeLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("initiatorSocketReceiveBufferSizeJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.initiatorSocketReceiveBufferSizeField = new JTextField();
        this.initiatorSocketReceiveBufferSizeField.setText(Integer.toString(networkApplicationProperties.getInitiatorSocketReceiveBufferSize()));
        jPanel.add(this.initiatorSocketReceiveBufferSizeField);
        this.initiatorSocketReceiveBufferSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JLabel(this.resourceBundle.getString("initiatorSocketSendBufferSizeLabelText") + ": ", 4);
        ((JComponent)object5).setToolTipText(this.resourceBundle.getString("initiatorSocketSendBufferSizeJLabelToolTipText"));
        jPanel.add((Component)object5);
        this.initiatorSocketSendBufferSizeField = new JTextField();
        this.initiatorSocketSendBufferSizeField.setText(Integer.toString(networkApplicationProperties.getInitiatorSocketSendBufferSize()));
        jPanel.add(this.initiatorSocketSendBufferSizeField);
        this.initiatorSocketSendBufferSizeField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                JTextComponent jTextComponent = (JTextComponent)focusEvent.getSource();
                jTextComponent.selectAll();
            }
        });
        object5 = new JPanel();
        ((JComponent)object5).setBorder(compoundBorder);
        object4 = new JPanel(new GridLayout(1, 1));
        ((Container)object4).add(new JLabel(this.resourceBundle.getString("remoteHeaderPanelLabelText") + ":"));
        object3 = new JPanel();
        ((Container)object3).setLayout(new FlowLayout(1));
        serializable = new JButton(this.resourceBundle.getString("addButtonLabelText"));
        ((JComponent)serializable).setToolTipText(this.resourceBundle.getString("addButtonToolTipText"));
        ((Container)object3).add((Component)serializable);
        ((AbstractButton)serializable).addActionListener(new AddRemoteAEActionListener());
        object2 = new JButton(this.resourceBundle.getString("editButtonLabelText"));
        ((JComponent)object2).setToolTipText(this.resourceBundle.getString("editButtonToolTipText"));
        ((Container)object3).add((Component)object2);
        ((AbstractButton)object2).addActionListener(new EditRemoteAEActionListener());
        object = new JButton(this.resourceBundle.getString("removeButtonLabelText"));
        ((JComponent)object).setToolTipText(this.resourceBundle.getString("removeButtonToolTipText"));
        ((Container)object3).add((Component)object);
        ((AbstractButton)object).addActionListener(new RemoveRemoteAEActionListener());
        serializable = new GridBagLayout();
        ((Container)object5).setLayout((LayoutManager)((Object)serializable));
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object4, (GridBagConstraints)object2);
        ((Container)object5).add((Component)object4);
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object3, (GridBagConstraints)object2);
        ((Container)object5).add((Component)object3);
        object4 = new JPanel();
        ((Container)object4).setLayout(new FlowLayout(1));
        ((JComponent)object4).setBorder(compoundBorder);
        object3 = new JButton(this.resourceBundle.getString("doneButtonLabelText"));
        ((JComponent)object3).setToolTipText(this.resourceBundle.getString("doneButtonToolTipText"));
        ((Container)object4).add((Component)object3);
        ((AbstractButton)object3).addActionListener(new DoneActionListener());
        object3 = new JPanel();
        serializable = new GridBagLayout();
        ((Container)object3).setLayout((LayoutManager)((Object)serializable));
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 0;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagLayout)serializable).setConstraints(jPanel, (GridBagConstraints)object2);
        ((Container)object3).add(jPanel);
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 1;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object5, (GridBagConstraints)object2);
        ((Container)object3).add((Component)object5);
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).gridx = 0;
        ((GridBagConstraints)object2).gridy = 2;
        ((GridBagConstraints)object2).fill = 2;
        ((GridBagLayout)serializable).setConstraints((Component)object4, (GridBagConstraints)object2);
        ((Container)object3).add((Component)object4);
        serializable = this.dialog.getContentPane();
        ((Container)serializable).add((Component)object3);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            Properties properties = new Properties();
            properties.load(fileInputStream);
            fileInputStream.close();
            System.err.println("properties=" + properties);
            NetworkApplicationProperties networkApplicationProperties = new NetworkApplicationProperties(properties);
            NetworkApplicationInformation networkApplicationInformation = networkApplicationProperties.getNetworkApplicationInformation();
            new NetworkApplicationConfigurationDialog(null, networkApplicationInformation, networkApplicationProperties);
            properties = networkApplicationProperties.getProperties(properties);
            System.err.println("properties after=" + properties);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class DoneActionListener
    implements ActionListener {
        protected DoneActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            String string = "";
            string = NetworkApplicationConfigurationDialog.this.calledAETitleField.getText();
            if (!ApplicationEntityConfigurationDialog.isValidAETitle(string)) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.calledAETitleField.setText("\\\\\\BAD\\\\\\");
            }
            String string2 = "";
            string2 = NetworkApplicationConfigurationDialog.this.callingAETitleField.getText();
            if (!ApplicationEntityConfigurationDialog.isValidAETitle(string2)) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.callingAETitleField.setText("\\\\\\BAD\\\\\\");
            }
            int n = 0;
            try {
                n = Integer.parseInt(NetworkApplicationConfigurationDialog.this.listeningPortField.getText());
                if (n < 1024) {
                    bl = false;
                    NetworkApplicationConfigurationDialog.this.listeningPortField.setText("want >= 1024");
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.listeningPortField.setText("\\\\\\BAD\\\\\\");
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(NetworkApplicationConfigurationDialog.this.acceptorMaximumLengthReceivedField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.acceptorMaximumLengthReceivedField.setText("\\\\\\BAD\\\\\\");
            }
            int n3 = 0;
            try {
                n3 = Integer.parseInt(NetworkApplicationConfigurationDialog.this.acceptorSocketReceiveBufferSizeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.acceptorSocketReceiveBufferSizeField.setText("\\\\\\BAD\\\\\\");
            }
            int n4 = 0;
            try {
                n4 = Integer.parseInt(NetworkApplicationConfigurationDialog.this.acceptorSocketSendBufferSizeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.acceptorSocketSendBufferSizeField.setText("\\\\\\BAD\\\\\\");
            }
            int n5 = 0;
            try {
                n5 = Integer.parseInt(NetworkApplicationConfigurationDialog.this.initiatorMaximumLengthReceivedField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.initiatorMaximumLengthReceivedField.setText("\\\\\\BAD\\\\\\");
            }
            int n6 = 0;
            try {
                n6 = Integer.parseInt(NetworkApplicationConfigurationDialog.this.initiatorSocketReceiveBufferSizeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.initiatorSocketReceiveBufferSizeField.setText("\\\\\\BAD\\\\\\");
            }
            int n7 = 0;
            try {
                n7 = Integer.parseInt(NetworkApplicationConfigurationDialog.this.initiatorSocketSendBufferSizeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                NetworkApplicationConfigurationDialog.this.initiatorSocketSendBufferSizeField.setText("\\\\\\BAD\\\\\\");
            }
            if (bl) {
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setListeningPort(n);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setCalledAETitle(string);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setCallingAETitle(string2);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setAcceptorMaximumLengthReceived(n2);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setAcceptorSocketReceiveBufferSize(n3);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setAcceptorSocketSendBufferSize(n4);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setInitiatorMaximumLengthReceived(n5);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setInitiatorSocketReceiveBufferSize(n6);
                NetworkApplicationConfigurationDialog.this.networkApplicationProperties.setInitiatorSocketSendBufferSize(n7);
                Cursor cursor = NetworkApplicationConfigurationDialog.this.dialog.getCursor();
                NetworkApplicationConfigurationDialog.this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    if (NetworkApplicationConfigurationDialog.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                        ((NetworkApplicationInformationFederated)NetworkApplicationConfigurationDialog.this.networkApplicationInformation).removeAllSources();
                        ((NetworkApplicationInformationFederated)NetworkApplicationConfigurationDialog.this.networkApplicationInformation).startupAllKnownSourcesAndRegister(NetworkApplicationConfigurationDialog.this.networkApplicationProperties);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("Ignoring exception", exception);
                }
                NetworkApplicationConfigurationDialog.this.dialog.setCursor(cursor);
                NetworkApplicationConfigurationDialog.this.dialog.dispose();
            }
        }
    }

    protected class RemoveRemoteAEActionListener
    implements ActionListener {
        protected RemoveRemoteAEActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkApplicationInformation networkApplicationInformation = NetworkApplicationConfigurationDialog.this.networkApplicationProperties.getNetworkApplicationInformation();
                String string = NetworkApplicationConfigurationDialog.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver, networkApplicationInformation, NetworkApplicationConfigurationDialog.this.resourceBundle.getString("selectNetworkTargetToRemoveLabelText"), NetworkApplicationConfigurationDialog.this.resourceBundle.getString("removeButtonLabelText"));
                if (string != null && string.length() > 0) {
                    networkApplicationInformation.remove(string);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("Ignoring exception", exception);
            }
        }
    }

    protected class EditRemoteAEActionListener
    implements ActionListener {
        protected EditRemoteAEActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkApplicationInformation networkApplicationInformation = NetworkApplicationConfigurationDialog.this.networkApplicationProperties.getNetworkApplicationInformation();
                String string = NetworkApplicationConfigurationDialog.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver, networkApplicationInformation, NetworkApplicationConfigurationDialog.this.resourceBundle.getString("selectNetworkTargetToEditLabelText"), NetworkApplicationConfigurationDialog.this.resourceBundle.getString("editButtonLabelText"));
                if (string != null && string.length() > 0) {
                    ApplicationEntity applicationEntity;
                    Set set = networkApplicationInformation.getListOfLocalNamesOfApplicationEntities();
                    ApplicationEntityMap applicationEntityMap = networkApplicationInformation.getApplicationEntityMap();
                    String string2 = networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                    if (applicationEntityMap != null && string2 != null && string2.length() > 0 && (applicationEntity = (ApplicationEntity)applicationEntityMap.get(string2)) != null) {
                        networkApplicationInformation.remove(string);
                        ApplicationEntityConfigurationDialog applicationEntityConfigurationDialog = new ApplicationEntityConfigurationDialog(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver, string, applicationEntity);
                        string = applicationEntityConfigurationDialog.getLocalName();
                        networkApplicationInformation.add(string, applicationEntityConfigurationDialog);
                    }
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("Ignoring exception", exception);
            }
        }
    }

    protected class AddRemoteAEActionListener
    implements ActionListener {
        protected AddRemoteAEActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                NetworkApplicationInformation networkApplicationInformation = NetworkApplicationConfigurationDialog.this.networkApplicationProperties.getNetworkApplicationInformation();
                ApplicationEntityConfigurationDialog applicationEntityConfigurationDialog = new ApplicationEntityConfigurationDialog(NetworkApplicationConfigurationDialog.this.componentToCenterDialogOver);
                String string = applicationEntityConfigurationDialog.getLocalName();
                networkApplicationInformation.remove(string);
                networkApplicationInformation.add(string, applicationEntityConfigurationDialog);
            }
            catch (Exception exception) {
                slf4jlogger.error("Ignoring exception", exception);
            }
        }
    }
}

