/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.NetworkConfigurationFromLDAP;
import com.pixelmed.network.NetworkConfigurationFromMulticastDNS;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.WebServerApplicationProperties;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Set;

public class NetworkApplicationInformationFederated
extends NetworkApplicationInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationInformationFederated.java,v 1.19 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NetworkApplicationInformationFederated.class);
    protected static final long RefreshFromSourcesInterval = 10000L;
    protected ArrayList sources = null;
    protected long lastTimeUpdateRan = 0L;

    @Override
    public ApplicationEntityMap getApplicationEntityMap() {
        this.update();
        return super.getApplicationEntityMap();
    }

    @Override
    public Set getListOfLocalNamesOfApplicationEntities() {
        this.update();
        return super.getListOfLocalNamesOfApplicationEntities();
    }

    @Override
    public Set getListOfApplicationEntityTitlesOfApplicationEntities() {
        this.update();
        return super.getListOfApplicationEntityTitlesOfApplicationEntities();
    }

    @Override
    public String getApplicationEntityTitleFromLocalName(String string) {
        this.update();
        return super.getApplicationEntityTitleFromLocalName(string);
    }

    @Override
    public String getLocalNameFromApplicationEntityTitle(String string) {
        this.update();
        return super.getLocalNameFromApplicationEntityTitle(string);
    }

    protected synchronized void update() {
        if (System.currentTimeMillis() - this.lastTimeUpdateRan > 10000L) {
            this.removeAll();
            ListIterator listIterator = this.sources.listIterator();
            while (listIterator.hasNext()) {
                NetworkConfigurationSource networkConfigurationSource = (NetworkConfigurationSource)listIterator.next();
                NetworkApplicationInformation networkApplicationInformation = networkConfigurationSource.getNetworkApplicationInformation();
                this.addAll(networkApplicationInformation);
            }
            this.lastTimeUpdateRan = System.currentTimeMillis();
        }
    }

    public void addSource(NetworkConfigurationSource networkConfigurationSource) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        this.sources.add(networkConfigurationSource);
        this.lastTimeUpdateRan = 0L;
    }

    public void removeAllSources() {
        if (this.sources != null) {
            ListIterator listIterator = this.sources.listIterator();
            while (listIterator.hasNext()) {
                NetworkConfigurationSource networkConfigurationSource = (NetworkConfigurationSource)listIterator.next();
                if (!(networkConfigurationSource instanceof NetworkConfigurationFromMulticastDNS)) continue;
                ((NetworkConfigurationFromMulticastDNS)networkConfigurationSource).unregisterAllServices();
            }
        }
        this.sources = null;
        this.removeAll();
        this.lastTimeUpdateRan = 0L;
    }

    public void startupAllKnownSourcesAndRegister(NetworkApplicationProperties networkApplicationProperties) {
        this.startupAllKnownSourcesAndRegister(networkApplicationProperties, null);
    }

    public void startupAllKnownSourcesAndRegister(NetworkApplicationProperties networkApplicationProperties, WebServerApplicationProperties webServerApplicationProperties) {
        NetworkConfigurationSource networkConfigurationSource;
        String string;
        String string2;
        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = null;
        try {
            networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS();
            networkConfigurationFromMulticastDNS.activateDiscovery();
            this.addSource(networkConfigurationFromMulticastDNS);
            if (networkApplicationProperties != null) {
                int n = networkApplicationProperties.getListeningPort();
                string2 = networkApplicationProperties.getCalledAETitle();
                string = networkApplicationProperties.getPrimaryDeviceType();
                networkConfigurationFromMulticastDNS.registerDicomService(string2, n, string);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Ignoring exception", exception);
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("startupAllKnownSourcesAndRegister(): federatedNetworkApplicationInformation after DNS ...\n{}" + this.toString());
        }
        try {
            networkConfigurationSource = new NetworkConfigurationFromLDAP();
            networkConfigurationSource.activateDiscovery(300000);
            this.addSource(networkConfigurationSource);
        }
        catch (Exception exception) {
            slf4jlogger.error("Ignoring exception", exception);
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("NetworkApplicationInformationFederated.startupAllKnownSourcesAndRegister(): federatedNetworkApplicationInformation after LDAP ...\n{}", this.toString());
        }
        if (networkApplicationProperties != null) {
            try {
                networkConfigurationSource = networkApplicationProperties.getNetworkConfigurationSource();
                this.addSource(networkConfigurationSource);
            }
            catch (Exception exception) {
                slf4jlogger.error("Ignoring exception", exception);
            }
        }
        if (webServerApplicationProperties != null && networkConfigurationFromMulticastDNS != null) {
            int n = webServerApplicationProperties.getListeningPort();
            string2 = webServerApplicationProperties.getRootURL();
            string = webServerApplicationProperties.getInstanceName();
            networkConfigurationFromMulticastDNS.registerWADOService(string, n, string2);
        }
    }
}

