/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.DicomStreamCopier;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.AssociationInitiator;
import com.pixelmed.network.AssociationOutputStream;
import com.pixelmed.network.CStoreRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandler;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.PresentationContextListFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class StorageSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/StorageSOPClassSCU.java,v 1.73 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StorageSOPClassSCU.class);
    protected boolean trappedExceptions;

    public boolean encounteredTrappedExceptions() {
        return this.trappedExceptions;
    }

    protected boolean sendOneSOPInstance(Association association, String string, String string2, String string3, DicomInputStream dicomInputStream, byte by, String string4) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        return this.sendOneSOPInstance(association, string, string2, string3, dicomInputStream, by, string4, null, -1);
    }

    protected boolean sendOneSOPInstance(Association association, String string, String string2, String string3, DicomInputStream dicomInputStream, byte by, String string4, String string5, int n) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        byte[] byArray = new CStoreRequestCommandMessage(string, string2, string5, n).getBytes();
        CStoreResponseHandler cStoreResponseHandler = new CStoreResponseHandler();
        association.setReceivedDataHandler(cStoreResponseHandler);
        association.send(by, byArray, null);
        AssociationOutputStream associationOutputStream = association.getAssociationOutputStream(by);
        if (string3.equals(string4)) {
            slf4jlogger.trace("sendOneSOPInstance(): same transfer syntax so raw binary copy");
            CopyStream.copy(dicomInputStream, associationOutputStream);
            slf4jlogger.trace("sendOneSOPInstance(): back from raw binary copy");
            ((OutputStream)associationOutputStream).close();
        } else {
            slf4jlogger.trace("sendOneSOPInstance(): different transfer syntaxes; converting {} to {}", string3, string4);
            DicomOutputStream dicomOutputStream = new DicomOutputStream(associationOutputStream, null, string4);
            new DicomStreamCopier(dicomInputStream, dicomOutputStream);
        }
        slf4jlogger.trace("sendOneSOPInstance(): about to wait for PDUs");
        association.waitForCommandPDataPDUs();
        return cStoreResponseHandler.wasSuccessful();
    }

    protected boolean sendOneSOPInstance(Association association, String string, String string2, AttributeList attributeList, byte by, String string3, String string4, int n) throws AReleaseException, DicomNetworkException, DicomException, IOException {
        byte[] byArray = new CStoreRequestCommandMessage(string, string2, string4, n).getBytes();
        CStoreResponseHandler cStoreResponseHandler = new CStoreResponseHandler();
        association.setReceivedDataHandler(cStoreResponseHandler);
        association.send(by, byArray, null);
        AssociationOutputStream associationOutputStream = association.getAssociationOutputStream(by);
        slf4jlogger.trace("sendOneSOPInstance(): writing attribute list as {}", string3);
        attributeList.write(associationOutputStream, string3, false, true, false);
        slf4jlogger.trace("sendOneSOPInstance(): about to wait for PDUs");
        association.waitForCommandPDataPDUs();
        return cStoreResponseHandler.wasSuccessful();
    }

    protected StorageSOPClassSCU() throws DicomNetworkException, DicomException, IOException {
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, int n3) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, string5, string6, n2);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, string5, string6, n2, null, -1);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7, int n3, int n4) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, string4, string5, string6, n2, string7, n3);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, String string4, String string5, String string6, int n2, String string7, int n3) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, 0, 0, 0, string4, string5, string6, n2, string7, n3);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, int n2, int n3, int n4, String string4, String string5, String string6, int n5) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, n2, n3, n4, string4, string5, string6, n5, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageSOPClassSCU(String string, int n, String string2, String string3, int n2, int n3, int n4, String string4, String string5, String string6, int n5, String string7, int n6) throws DicomNetworkException, DicomException, IOException {
        slf4jlogger.trace("StorageSOPClassSCU: storing {}", string4);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string4));){
            String string8;
            Object object;
            DicomInputStream dicomInputStream = new DicomInputStream(bufferedInputStream);
            if (dicomInputStream.haveMetaHeader()) {
                object = new AttributeList();
                ((AttributeList)object).readOnlyMetaInformationHeader(dicomInputStream);
                slf4jlogger.trace("Meta header information = {}", object);
                string5 = Attribute.getSingleStringValueOrNull((AttributeList)object, TagFromName.MediaStorageSOPClassUID);
                string6 = Attribute.getSingleStringValueOrNull((AttributeList)object, TagFromName.MediaStorageSOPInstanceUID);
                string8 = Attribute.getSingleStringValueOrNull((AttributeList)object, TagFromName.TransferSyntaxUID);
            } else {
                string8 = dicomInputStream.getTransferSyntaxToReadDataSet().getUID();
            }
            slf4jlogger.trace("Using inputTransferSyntax {}", string8);
            if (string5 == null || string5.length() == 0) {
                throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID");
            }
            if (SOPClass.isDirectory(string5)) {
                throw new DicomNetworkException("Can't C-STORE Media Storage Directory Storage SOP Class (DICOMDIR)");
            }
            if (string6 == null || string6.length() == 0) {
                throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID");
            }
            object = new PresentationContextListFactory();
            LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(string5, string8, n5);
            AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, n2, n3, n4, linkedList, null, false, null, null);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace(((Association)associationInitiator).toString());
            }
            byte by = associationInitiator.getSuitablePresentationContextID(string5);
            slf4jlogger.trace("Using context ID {}", by);
            String string9 = associationInitiator.getTransferSyntaxForPresentationContextID(by);
            slf4jlogger.trace("Using outputTransferSyntax {}", string9);
            if (string9 == null || string9.length() == 0) {
                throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Transfer Syntax (no Presentation Context for Affected SOP Class UID)");
            }
            boolean bl = false;
            try {
                bl = this.sendOneSOPInstance(associationInitiator, string5, string6, string8, dicomInputStream, by, string9, string7, n6);
                associationInitiator.release();
            }
            catch (AReleaseException aReleaseException) {
                // empty catch block
            }
            slf4jlogger.debug("Send {} {}", string4, bl ? "succeeded" : "failed");
        }
    }

    public StorageSOPClassSCU(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, int n) {
        this(association, setOfDicomFiles, multipleInstanceTransferStatusHandler);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler) {
        this(association, setOfDicomFiles, multipleInstanceTransferStatusHandler, null, -1);
    }

    public StorageSOPClassSCU(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n, int n2) {
        this(association, setOfDicomFiles, multipleInstanceTransferStatusHandler, string, n);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n) {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("StorageSOPClassSCU: storing {}", setOfDicomFiles);
        }
        try {
            this.sendMultipleSOPInstances(association, setOfDicomFiles, multipleInstanceTransferStatusHandler, string, n);
        }
        catch (AReleaseException aReleaseException) {
        }
        catch (DicomNetworkException dicomNetworkException) {
            this.trappedExceptions = true;
            slf4jlogger.error("", dicomNetworkException);
        }
        catch (IOException iOException) {
            this.trappedExceptions = true;
            slf4jlogger.error("", iOException);
        }
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, int n3) {
        this(string, n, string2, string3, setOfDicomFiles, n2, multipleInstanceTransferStatusHandler);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler) {
        this(string, n, string2, string3, setOfDicomFiles, n2, multipleInstanceTransferStatusHandler, null, -1);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, int n2, int n3, int n4, SetOfDicomFiles setOfDicomFiles, int n5, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler) {
        this(string, n, string2, string3, n2, n3, n4, setOfDicomFiles, n5, multipleInstanceTransferStatusHandler, null, -1);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n3, int n4) {
        this(string, n, string2, string3, setOfDicomFiles, n2, multipleInstanceTransferStatusHandler, string4, n3);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, SetOfDicomFiles setOfDicomFiles, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n3) {
        this(string, n, string2, string3, 0, 0, 0, setOfDicomFiles, n2, multipleInstanceTransferStatusHandler, string4, n3);
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, int n2, int n3, int n4, SetOfDicomFiles setOfDicomFiles, int n5, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n6) {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("StorageSOPClassSCU: storing {}", setOfDicomFiles);
        }
        if (!setOfDicomFiles.isEmpty()) {
            try {
                PresentationContextListFactory presentationContextListFactory = new PresentationContextListFactory();
                LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(setOfDicomFiles, n5);
                AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, n2, n3, n4, linkedList, null, false, null, null);
                this.sendMultipleSOPInstances((Association)associationInitiator, setOfDicomFiles, multipleInstanceTransferStatusHandler, string4, n6);
                associationInitiator.release();
            }
            catch (AReleaseException aReleaseException) {
            }
            catch (DicomNetworkException dicomNetworkException) {
                this.trappedExceptions = true;
                slf4jlogger.error("", dicomNetworkException);
            }
            catch (IOException iOException) {
                this.trappedExceptions = true;
                slf4jlogger.error("", iOException);
            }
        } else {
            slf4jlogger.trace("Not opening an association since no instances to send");
        }
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, Set set, AttributeList[] attributeListArray, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n3, int n4) {
        this(string, n, string2, string3, set, attributeListArray, n2, multipleInstanceTransferStatusHandler, string4, n3);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public StorageSOPClassSCU(String string, int n, String string2, String string3, Set set, AttributeList[] attributeListArray, int n2, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string4, int n3) {
        if (attributeListArray.length > 0) {
            try {
                PresentationContextListFactory presentationContextListFactory = new PresentationContextListFactory();
                LinkedList linkedList = PresentationContextListFactory.createNewPresentationContextList(set, n2);
                AssociationInitiator associationInitiator = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, false);
                this.sendMultipleSOPInstances((Association)associationInitiator, attributeListArray, multipleInstanceTransferStatusHandler, string4, n3);
                associationInitiator.release();
            }
            catch (AReleaseException aReleaseException) {
            }
            catch (DicomNetworkException dicomNetworkException) {
                this.trappedExceptions = true;
                slf4jlogger.error("", dicomNetworkException);
            }
            catch (IOException iOException) {
                this.trappedExceptions = true;
                slf4jlogger.error("", iOException);
            }
        } else {
            slf4jlogger.trace("Not opening an association since no instances to send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMultipleSOPInstances(Association association, SetOfDicomFiles setOfDicomFiles, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n) throws AReleaseException, DicomNetworkException, IOException {
        int n2 = setOfDicomFiles.size();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(association.toString());
        }
        Iterator iterator = setOfDicomFiles.iterator();
        while (iterator.hasNext()) {
            --n2;
            ++n3;
            SetOfDicomFiles.DicomFile dicomFile = (SetOfDicomFiles.DicomFile)iterator.next();
            String string2 = dicomFile.getFileName();
            slf4jlogger.trace("Sending {}", string2);
            boolean bl = false;
            String string3 = null;
            try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));){
                String string4 = null;
                String string5 = null;
                DicomInputStream dicomInputStream = new DicomInputStream(bufferedInputStream);
                if (dicomInputStream.haveMetaHeader()) {
                    AttributeList attributeList = new AttributeList();
                    attributeList.readOnlyMetaInformationHeader(dicomInputStream);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Meta header information = \n{}", attributeList.toString());
                    }
                    string5 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MediaStorageSOPClassUID);
                    string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.MediaStorageSOPInstanceUID);
                    string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID);
                } else {
                    string5 = dicomFile.getSOPClassUID();
                    string3 = dicomFile.getSOPInstanceUID();
                    string4 = dicomInputStream.getTransferSyntaxToReadDataSet().getUID();
                }
                slf4jlogger.trace("affectedSOPClass = {}", string5);
                slf4jlogger.trace("affectedSOPInstance = {}", string3);
                slf4jlogger.trace("inputTransferSyntax = {}", string4);
                if (string5 == null || string5.length() == 0) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID");
                }
                if (SOPClass.isDirectory(string5)) {
                    throw new DicomNetworkException("Can't C-STORE Media Storage Directory Storage SOP Class (DICOMDIR)");
                }
                if (string3 == null || string3.length() == 0) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID");
                }
                byte by = association.getSuitablePresentationContextID(string5);
                slf4jlogger.trace("Using context ID {}", by);
                String string6 = association.getTransferSyntaxForPresentationContextID(by);
                slf4jlogger.trace("Using outputTransferSyntax {}", string6);
                if (string6 == null || string6.length() == 0) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Transfer Syntax (no Presentation Context for Affected SOP Class UID)");
                }
                bl = this.sendOneSOPInstance(association, string5, string3, string4, dicomInputStream, by, string6, string, n);
            }
            catch (DicomNetworkException dicomNetworkException) {
                slf4jlogger.error("", dicomNetworkException);
                bl = false;
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                bl = false;
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                bl = false;
            }
            if (!bl) {
                ++n4;
                this.trappedExceptions = true;
            }
            slf4jlogger.debug("Send {} {} between {}", string2, bl ? "succeeded" : "failed", association.getEndpointDescription());
            if (multipleInstanceTransferStatusHandler == null) continue;
            if (multipleInstanceTransferStatusHandler instanceof MultipleInstanceTransferStatusHandlerWithFileName) {
                ((MultipleInstanceTransferStatusHandlerWithFileName)multipleInstanceTransferStatusHandler).updateStatus(n2, n3, n4, n5, string3, string2, bl);
                continue;
            }
            multipleInstanceTransferStatusHandler.updateStatus(n2, n3, n4, n5, string3);
        }
        slf4jlogger.debug("Finished sending all files nRemaining={} nCompleted={} nFailed={} nWarning={} between {}", n2, n3, n4, n5, association.getEndpointDescription());
    }

    protected void sendMultipleSOPInstances(Association association, AttributeList[] attributeListArray, MultipleInstanceTransferStatusHandler multipleInstanceTransferStatusHandler, String string, int n) throws AReleaseException, DicomNetworkException, IOException {
        int n2 = attributeListArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(association.toString());
        }
        for (int i = 0; i < attributeListArray.length; ++i) {
            --n2;
            ++n3;
            AttributeList attributeList = attributeListArray[i];
            boolean bl = false;
            String string2 = null;
            try {
                String string3 = null;
                string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID);
                string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
                slf4jlogger.trace("Sending {}", string2);
                slf4jlogger.trace("affectedSOPClass = {}", string3);
                if (string3 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Class UID");
                }
                if (string2 == null) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Affected SOP Instance UID");
                }
                byte by = association.getSuitablePresentationContextID(string3);
                slf4jlogger.trace("Using context ID {}", by);
                String string4 = association.getTransferSyntaxForPresentationContextID(by);
                slf4jlogger.trace("Using outputTransferSyntax {}", string4);
                if (string4 == null || string4.length() == 0) {
                    throw new DicomNetworkException("Can't C-STORE SOP Instance - can't determine Transfer Syntax (no Presentation Context for Affected SOP Class UID)");
                }
                bl = this.sendOneSOPInstance(association, string3, string2, attributeList, by, string4, string, n);
            }
            catch (DicomNetworkException dicomNetworkException) {
                slf4jlogger.error("", dicomNetworkException);
                bl = false;
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                bl = false;
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                bl = false;
            }
            if (!bl) {
                ++n4;
                this.trappedExceptions = true;
            }
            slf4jlogger.debug("Send {} {} between {}", string2, bl ? "succeeded" : "failed", association.getEndpointDescription());
            if (multipleInstanceTransferStatusHandler == null) continue;
            multipleInstanceTransferStatusHandler.updateStatus(n2, n3, n4, n5, string2);
        }
        slf4jlogger.debug("Finished sending all files nRemaining={} nCompleted={} nFailed={} nWarning={} between {}", n2, n3, n4, n5, association.getEndpointDescription());
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            int n = -1;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            int n2 = 0;
            if (stringArray.length == 8) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                string4 = stringArray[4];
                string5 = stringArray[5];
                string6 = stringArray[6];
                n2 = Integer.parseInt(stringArray[7]);
            }
            if (stringArray.length == 7) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                string4 = stringArray[4];
                string5 = stringArray[5];
                string6 = stringArray[6];
                n2 = 0;
            } else if (stringArray.length == 6) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                string4 = stringArray[4];
                string5 = null;
                string6 = null;
                n2 = Integer.parseInt(stringArray[5]);
            } else if (stringArray.length == 5) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                string4 = stringArray[4];
                string5 = null;
                string6 = null;
                n2 = 0;
            } else {
                throw new Exception("Argument list must be 5, 6, 7 or 8 values");
            }
            if (string4.equals("-")) {
                SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                String string7 = bufferedReader.readLine();
                while (string7 != null) {
                    if (string5 == null) {
                        setOfDicomFiles.add(string7);
                    } else {
                        setOfDicomFiles.add(string7, string5, null, null);
                    }
                    string7 = bufferedReader.readLine();
                }
                new StorageSOPClassSCU(string, n, string2, string3, setOfDicomFiles, n2, null, null, 0);
            } else {
                new StorageSOPClassSCU(string, n, string2, string3, string4, string5, string6, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }

    protected class CStoreResponseHandler
    extends CompositeResponseHandler {
        CStoreResponseHandler(int n) {
            this();
            slf4jlogger.warn("CStoreResponseHandler(): Debug level supplied as constructor argument ignored");
        }

        CStoreResponseHandler() {
        }

        @Override
        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("CStoreResponseHandler(): status in response =0x{}", Integer.toHexString(n));
            }
            this.success = n == 0 || n == 45056 || n == 45063 || n == 45062;
        }
    }
}

