/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.AReleaseException;
import com.pixelmed.network.Association;
import com.pixelmed.network.AssociationFactory;
import com.pixelmed.network.CEchoRequestCommandMessage;
import com.pixelmed.network.CompositeResponseHandler;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;

public class VerificationSOPClassSCU
extends SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/VerificationSOPClassSCU.java,v 1.31 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(VerificationSOPClassSCU.class);

    public VerificationSOPClassSCU(String string, int n, String string2, String string3, boolean bl, int n2) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, bl);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public VerificationSOPClassSCU(String string, int n, String string2, String string3, boolean bl) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, bl, null, null);
    }

    public VerificationSOPClassSCU(String string, int n, String string2, String string3, boolean bl, String string4, String string5, int n2) throws DicomNetworkException, DicomException, IOException {
        this(string, n, string2, string3, bl, string4, string5);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public VerificationSOPClassSCU(String string, int n, String string2, String string3, boolean bl, String string4, String string5) throws DicomNetworkException, DicomException, IOException {
        LinkedList<PresentationContext> linkedList = new LinkedList<PresentationContext>();
        Object object = new LinkedList<String>();
        ((LinkedList)object).add("1.2.840.10008.1.2");
        ((LinkedList)object).add("1.2.840.10008.1.2.1");
        linkedList.add(new PresentationContext(1, "1.2.840.10008.1.1", (LinkedList)object));
        linkedList.add(new PresentationContext(3, "1.2.840.10008.1.1", "1.2.840.10008.1.2"));
        linkedList.add(new PresentationContext(5, "1.2.840.10008.1.1", "1.2.840.10008.1.2.1"));
        object = AssociationFactory.createNewAssociation(string, n, string2, string3, linkedList, null, bl, string4, string5);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace(((Association)object).toString());
        }
        byte by = ((Association)object).getSuitablePresentationContextID("1.2.840.10008.1.1");
        slf4jlogger.trace("Using context ID {}", by);
        byte[] byArray = new CEchoRequestCommandMessage().getBytes();
        CEchoResponseHandler cEchoResponseHandler = new CEchoResponseHandler();
        ((Association)object).setReceivedDataHandler(cEchoResponseHandler);
        ((Association)object).send(by, byArray, null);
        slf4jlogger.trace("waiting for one PDU");
        try {
            ((Association)object).waitForCommandPDataPDUs();
            slf4jlogger.trace("got PDU, now releasing association");
            ((Association)object).release();
        }
        catch (AReleaseException aReleaseException) {
            // empty catch block
        }
        if (!cEchoResponseHandler.wasSuccessful()) {
            throw new DicomNetworkException("C-ECHO reports failure status 0x" + Integer.toString(cEchoResponseHandler.getStatus() & 0xFFFF, 16));
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = stringArray.length >= 5 && stringArray[4].toUpperCase(Locale.US).equals("SECURE");
        String string = stringArray.length >= 6 ? stringArray[5] : null;
        String string2 = stringArray.length >= 7 ? stringArray[6] : null;
        VerificationSOPClassSCU verificationSOPClassSCU = null;
        try {
            verificationSOPClassSCU = new VerificationSOPClassSCU(stringArray[0], Integer.parseInt(stringArray[1]), stringArray[2], stringArray[3], bl, string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        System.err.println("VerificationSOPClass: was " + (verificationSOPClassSCU == null ? "not " : "") + "successful");
    }

    protected class CEchoResponseHandler
    extends CompositeResponseHandler {
        CEchoResponseHandler(int n) {
            this();
            slf4jlogger.warn("CEchoResponseHandler(): Debug level supplied as constructor argument ignored");
        }

        CEchoResponseHandler() {
        }

        @Override
        protected void evaluateStatusAndSetSuccess(AttributeList attributeList) {
            this.status = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Status, 65535);
            this.success = this.status == 0;
        }
    }
}

