/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.query;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.StringUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class QueryTreeRecord
implements Comparable,
TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/query/QueryTreeRecord.java,v 1.24 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(QueryTreeRecord.class);
    protected QueryInformationModel q;
    protected AttributeList filter;
    protected QueryTreeRecord parent;
    protected List children;
    protected InformationEntity ie;
    protected Attribute uniqueKey;
    protected AttributeList uniqueKeys;
    protected AttributeList allAttributesReturnedInIdentifier;
    protected String value;
    protected boolean childrenPopulated;
    protected int numberOfChildren;

    public String toString() {
        return this.value == null ? "" : this.value;
    }

    public int compareTo(Object object) {
        String string;
        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
        Attribute attribute = queryTreeRecord.getUniqueKey();
        String string2 = attribute == null ? null : attribute.getSingleStringValueOrNull();
        String string3 = string = this.getUniqueKey() == null ? null : this.getUniqueKey().getSingleStringValueOrNull();
        if (string == null && string2 == null) {
            return 0;
        }
        int n = string.compareTo(string2);
        int n2 = StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers(this.getValue(), queryTreeRecord.getValue());
        if (n2 == 0) {
            return n;
        }
        return n2;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public TreeNode getChildAt(int n) {
        TreeNode treeNode;
        slf4jlogger.trace("getChildAt(): {}", n);
        this.populateChildrenIfRequired();
        slf4jlogger.trace("getChildAt(): back from populateChildrenIfRequired(), childrenPopulated={}, numberOfChildren={}", this.childrenPopulated, this.numberOfChildren);
        TreeNode treeNode2 = treeNode = n < this.getChildCount() ? (TreeNode)this.children.get(n) : null;
        if (treeNode == null) {
            System.err.println("QueryTreeRecord.getChildAt(): there is no such child as " + n + ", probably because query failed to return any children at " + this.getQueryLevelToPopulateChildren() + " level - javax.swing.tree.TreePath.pathByAddingChild will now throw a NullPointerException");
        }
        return treeNode;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        slf4jlogger.trace("getIndexOfChild: looking for {}", treeNode);
        this.populateChildrenIfRequired();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.children.get(i).equals(treeNode)) continue;
            slf4jlogger.trace("getIndexOfChild: found {}", treeNode);
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        slf4jlogger.trace("populateChildrenIfRequired(): isLeaf()");
        int n = this.getChildCount();
        boolean bl = n == 0;
        slf4jlogger.trace("populateChildrenIfRequired(): isLeaf() returns {} because getChildCount() is {}", bl, n);
        return this.getChildCount() == 0;
    }

    protected void populateChildrenIfRequired() {
        slf4jlogger.trace("populateChildrenIfRequired(): childrenPopulated={}", this.childrenPopulated);
        if (!this.childrenPopulated) {
            this.populateChildren();
            this.childrenPopulated = true;
            this.numberOfChildren = this.children == null ? 0 : this.children.size();
        }
    }

    @Override
    public int getChildCount() {
        slf4jlogger.trace("getChildCount(): when called numberOfChildren={}", this.numberOfChildren);
        if (this.numberOfChildren == -1) {
            this.populateChildrenIfRequired();
            slf4jlogger.trace("getChildCount(): after populateChildrenIfRequired() numberOfChildren={}", this.numberOfChildren);
        }
        return this.numberOfChildren;
    }

    public Enumeration children() {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("children(): {}null", this.children == null ? "" : "not ");
        }
        this.populateChildrenIfRequired();
        return this.children == null ? null : new Vector(this.children).elements();
    }

    protected InformationEntity getQueryLevelToPopulateChildren() {
        return this.ie == null ? this.q.getRoot() : this.q.getChildTypeForParent(this.ie);
    }

    protected void populateChildren() {
        InformationEntity informationEntity;
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("populateChildren() for {}", this);
        }
        if ((informationEntity = this.getQueryLevelToPopulateChildren()) != null) {
            slf4jlogger.debug("populateChildren(): queryLevel={}", informationEntity);
            AttributeTag attributeTag = this.q.getUniqueKeyForInformationEntity(informationEntity);
            slf4jlogger.debug("populateChildren(): uniqueKeyTagFromThisLevel={}", attributeTag);
            OurResponseIdentifierHandler ourResponseIdentifierHandler = new OurResponseIdentifierHandler(this, informationEntity, attributeTag);
            try {
                this.q.performQuery(this.filter, this.uniqueKeys, informationEntity, ourResponseIdentifierHandler);
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
            catch (DicomNetworkException dicomNetworkException) {
                slf4jlogger.error("", dicomNetworkException);
            }
        }
    }

    public QueryTreeRecord(QueryInformationModel queryInformationModel, AttributeList attributeList, QueryTreeRecord queryTreeRecord, String string, InformationEntity informationEntity, Attribute attribute, AttributeList attributeList2, int n) {
        this(queryInformationModel, attributeList, queryTreeRecord, string, informationEntity, attribute, attributeList2);
        slf4jlogger.warn("Debug level supplied as constructor argument ignored");
    }

    public QueryTreeRecord(QueryInformationModel queryInformationModel, AttributeList attributeList, QueryTreeRecord queryTreeRecord, String string, InformationEntity informationEntity, Attribute attribute, AttributeList attributeList2) {
        this.q = queryInformationModel;
        this.filter = attributeList;
        this.parent = queryTreeRecord;
        this.value = string;
        this.ie = informationEntity;
        this.uniqueKey = attribute;
        this.allAttributesReturnedInIdentifier = attributeList2;
        this.childrenPopulated = false;
        this.numberOfChildren = -1;
        Comparable comparable = queryInformationModel.getAttributeTagOfCountOfChildren(informationEntity);
        if (attributeList2 != null && comparable != null && attributeList2.containsKey(comparable)) {
            this.numberOfChildren = Attribute.getSingleIntegerValueOrDefault(attributeList2, (AttributeTag)comparable, -1);
        }
        this.uniqueKeys = new AttributeList();
        for (comparable = queryTreeRecord; comparable != null; comparable = (QueryTreeRecord)((QueryTreeRecord)comparable).getParent()) {
            Attribute attribute2 = ((QueryTreeRecord)comparable).getUniqueKey();
            if (attribute2 == null) continue;
            this.uniqueKeys.put(attribute2.getTag(), attribute2);
        }
        if (attribute != null) {
            this.uniqueKeys.put(attribute.getTag(), attribute);
        }
    }

    public void addChild(QueryTreeRecord queryTreeRecord) {
        int n;
        slf4jlogger.trace("addChild(): child={}", queryTreeRecord);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        if ((n = Collections.binarySearch(this.children, queryTreeRecord)) < 0) {
            this.children.add(-n - 1, queryTreeRecord);
        }
    }

    public void addSibling(QueryTreeRecord queryTreeRecord) throws DicomException {
        slf4jlogger.trace("addSibling(): sibling={}", queryTreeRecord);
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(queryTreeRecord);
    }

    public String getValue() {
        return this.value;
    }

    public InformationEntity getInformationEntity() {
        return this.ie;
    }

    public AttributeList getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Attribute getUniqueKey() {
        return this.uniqueKey;
    }

    public AttributeList getAllAttributesReturnedInIdentifier() {
        return this.allAttributesReturnedInIdentifier;
    }

    protected class OurResponseIdentifierHandler
    extends IdentifierHandler {
        protected InformationEntity ie;
        protected AttributeTag uniqueKeyTagFromThisLevel;
        protected QueryTreeRecord parentNode;

        public OurResponseIdentifierHandler(QueryTreeRecord queryTreeRecord2, InformationEntity informationEntity, AttributeTag attributeTag) {
            this.parentNode = queryTreeRecord2;
            this.ie = informationEntity;
            this.uniqueKeyTagFromThisLevel = attributeTag;
        }

        @Override
        public void doSomethingWithIdentifier(AttributeList attributeList) throws DicomException {
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("populateChildren.doSomethingWithIdentifier():\n{}", attributeList);
            }
            String string = QueryTreeRecord.this.q.getStringValueForTreeFromResponseIdentifier(this.ie, attributeList);
            Attribute attribute = attributeList.get(this.uniqueKeyTagFromThisLevel);
            if (attribute == null || attribute.getVL() == 0L) {
                throw new DicomException("Invalid query response for " + this.ie + " without unique key value in " + this.uniqueKeyTagFromThisLevel + " from " + QueryTreeRecord.this.q + " (\"" + string + "\")");
            }
            QueryTreeRecord queryTreeRecord = new QueryTreeRecord(QueryTreeRecord.this.q, QueryTreeRecord.this.filter, this.parentNode, string, this.ie, attribute, attributeList);
            QueryTreeRecord.this.addChild(queryTreeRecord);
        }
    }
}

