/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.CodedSequenceItem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestCodedSequenceItemParseStringTuple
extends TestCase {
    public TestCodedSequenceItemParseStringTuple(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestCodedSequenceItemParseStringTuple");
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Three"));
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Three_NoQuotesAroundMeaning"));
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Three_QuotesAroundEverything"));
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Three_LeadingAndTrailingSpaces"));
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Four"));
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Four_QuotesAroundEverything"));
        testSuite.addTest((Test)new TestCodedSequenceItemParseStringTuple("TestCodedSequenceItemParseStringTuple_Four_LeadingAndTrailingSpaces"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestCodedSequenceItemParseStringTuple_Three() throws Exception {
        String string = "(R-00339,SRT,\"No\")";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }

    public void TestCodedSequenceItemParseStringTuple_Three_NoQuotesAroundMeaning() throws Exception {
        String string = "(R-00339,SRT,No)";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }

    public void TestCodedSequenceItemParseStringTuple_Three_QuotesAroundEverything() throws Exception {
        String string = "(\"R-00339\",\"SRT\",\"No\")";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }

    public void TestCodedSequenceItemParseStringTuple_Three_LeadingAndTrailingSpaces() throws Exception {
        String string = "  ( R-00339   , SRT , \"No\"   )  ";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }

    public void TestCodedSequenceItemParseStringTuple_Four() throws Exception {
        String string = "(R-00339,SRT,1.0,\"No\")";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        String string5 = "1.0";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csv", (String)string5, (String)codedSequenceItem.getCodingSchemeVersion());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csv", (String)string5, (String)codedSequenceItem2.getCodingSchemeVersion());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }

    public void TestCodedSequenceItemParseStringTuple_Four_QuotesAroundEverything() throws Exception {
        String string = "(\"R-00339\",\"SRT\",\"1.0\",\"No\")";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        String string5 = "1.0";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csv", (String)string5, (String)codedSequenceItem.getCodingSchemeVersion());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csv", (String)string5, (String)codedSequenceItem2.getCodingSchemeVersion());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }

    public void TestCodedSequenceItemParseStringTuple_Four_LeadingAndTrailingSpaces() throws Exception {
        String string = "  ( R-00339   , SRT , 1.0  , \"No\"   )  ";
        String string2 = "R-00339";
        String string3 = "SRT";
        String string4 = "No";
        String string5 = "1.0";
        CodedSequenceItem codedSequenceItem = new CodedSequenceItem(string);
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csv", (String)string5, (String)codedSequenceItem.getCodingSchemeVersion());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem.getCodeMeaning());
        CodedSequenceItem codedSequenceItem2 = new CodedSequenceItem(codedSequenceItem.toString());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cv", (String)string2, (String)codedSequenceItem2.getCodeValue());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csd", (String)string3, (String)codedSequenceItem2.getCodingSchemeDesignator());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking csv", (String)string5, (String)codedSequenceItem2.getCodingSchemeVersion());
        TestCodedSequenceItemParseStringTuple.assertEquals((String)"Checking cm", (String)string4, (String)codedSequenceItem2.getCodeMeaning());
    }
}

