/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.utils.ColorUtilities;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestColorConversions_SRGB_CIELabPCS
extends TestCase {
    int[][] testRGBValues = new int[][]{{0, 0, 0}, {255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 255, 0}, {0, 255, 255}, {255, 0, 255}, {255, 255, 255}, {225, 190, 150}, {200, 200, 200}, {128, 174, 128}, {221, 130, 101}};

    public TestColorConversions_SRGB_CIELabPCS(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestColorConversions_SRGB_CIELabPCS");
        testSuite.addTest((Test)new TestColorConversions_SRGB_CIELabPCS("TestColorConversions_SRGB_CIELabPCS_SpecificValues"));
        testSuite.addTest((Test)new TestColorConversions_SRGB_CIELabPCS("TestColorConversions_SRGB_CIELabPCS_WhitePoint"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestColorConversions_SRGB_CIELabPCS_SpecificValues() throws Exception {
        for (int[] nArray : this.testRGBValues) {
            int[] nArray2 = ColorUtilities.getIntegerScaledCIELabPCSFromSRGB(nArray);
            System.err.println("TestColorConversions_SRGB_CIELabPCS_SpecificValues(): RGB (" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ") = Lab (" + nArray2[0] + "," + nArray2[1] + "," + nArray2[2] + ")");
            int[] nArray3 = ColorUtilities.getSRGBFromIntegerScaledCIELabPCS(nArray2);
            TestColorConversions_SRGB_CIELabPCS.assertEquals((String)"Checking round trip r", (int)nArray[0], (int)nArray3[0]);
            TestColorConversions_SRGB_CIELabPCS.assertEquals((String)"Checking round trip g", (int)nArray[1], (int)nArray3[1]);
            TestColorConversions_SRGB_CIELabPCS.assertEquals((String)"Checking round trip b", (int)nArray[2], (int)nArray3[2]);
        }
    }

    public void TestColorConversions_SRGB_CIELabPCS_WhitePoint() throws Exception {
        float[] fArray = new float[]{100.0f, 0.0f, 0.0f};
        int[] nArray = new int[]{65535, 32896, 32896};
        int[] nArray2 = ColorUtilities.getIntegerScaledCIELabFromCIELab(fArray);
        TestColorConversions_SRGB_CIELabPCS.assertEquals((String)("Checking scaling L" + fArray[0]), (int)nArray[0], (int)nArray2[0]);
        TestColorConversions_SRGB_CIELabPCS.assertEquals((String)("Checking scaling a" + fArray[1]), (int)nArray[1], (int)nArray2[1]);
        TestColorConversions_SRGB_CIELabPCS.assertEquals((String)("Checking scaling b" + fArray[2]), (int)nArray[2], (int)nArray2[2]);
    }
}

