/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.anatproc.Concept;
import com.pixelmed.anatproc.DisplayableLateralityConcept;
import com.pixelmed.anatproc.MammographyLaterality;
import com.pixelmed.anatproc.ProjectionXRayAnatomy;
import com.pixelmed.dicom.CodedSequenceItem;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLaterality
extends TestCase {
    public TestLaterality(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestLaterality");
        testSuite.addTest((Test)new TestLaterality("TestLaterality_Methods"));
        testSuite.addTest((Test)new TestLaterality("TestLaterality_Equality"));
        testSuite.addTest((Test)new TestLaterality("TestLaterality_DictionaryLookup"));
        testSuite.addTest((Test)new TestLaterality("TestLaterality_MammoConversion"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestLaterality_Methods() throws Exception {
        String string = "C0205091";
        Concept concept = new Concept("C0205091");
        TestLaterality.assertEquals((String)"Checking UID", (String)string, (String)concept.getConceptUniqueIdentifier());
    }

    public void TestLaterality_Equality() throws Exception {
        Concept concept = new Concept("C0205091");
        DisplayableLateralityConcept displayableLateralityConcept = new DisplayableLateralityConcept("C0205091", "7771000", "SRT", "SNM3", null, "G-A101", "Left", "L", null, null, null);
        DisplayableLateralityConcept displayableLateralityConcept2 = new DisplayableLateralityConcept("C0205090", "24028007", "SRT", "SNM3", null, "G-A100", "Right", "R", null, null, null);
        TestLaterality.assertEquals((String)"Checking self", (Object)concept, (Object)concept);
        TestLaterality.assertTrue((String)"Checking self hashCode", (concept.hashCode() == concept.hashCode() ? 1 : 0) != 0);
        TestLaterality.assertEquals((String)"Checking same Concept and DisplayableAnatomicConcept", (Object)concept, (Object)displayableLateralityConcept);
        TestLaterality.assertTrue((String)"Checking same Concept and DisplayableAnatomicConcept hashCode", (concept.hashCode() == concept.hashCode() ? 1 : 0) != 0);
        TestLaterality.assertTrue((String)"Checking different Concepts", (!displayableLateralityConcept.equals(displayableLateralityConcept2) ? 1 : 0) != 0);
        TestLaterality.assertTrue((String)"Checking different Concepts hashCode", (displayableLateralityConcept.hashCode() != displayableLateralityConcept2.hashCode() ? 1 : 0) != 0);
        TestLaterality.assertTrue((String)"Checking null", (!displayableLateralityConcept.equals(null) ? 1 : 0) != 0);
    }

    public void TestLaterality_DictionaryLookup() throws Exception {
        Concept concept = new Concept("C0205091");
        String string = "Left";
        TestLaterality.assertEquals((String)"Checking look up by Concept", (String)string, (String)ProjectionXRayAnatomy.getLateralityConcepts().find(concept).getCodeMeaning());
    }

    public void TestLaterality_MammoConversion() throws Exception {
        DisplayableLateralityConcept displayableLateralityConcept = new DisplayableLateralityConcept("C0205091", "7771000", "SRT", "SNM3", null, "G-A101", "Left", "L", null, null, null);
        Object object = new DisplayableLateralityConcept("C0222601", "80248007", "SRT", "SNM3", null, "T-04030", "Left breast", null, null, null, null);
        Object object2 = "Left breast";
        Object object3 = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept);
        TestLaterality.assertEquals((String)"Checking converted left by concept", (Object)object, (Object)object3);
        TestLaterality.assertEquals((String)"Checking converted left by code meaning", (String)object2, (String)((CodedConcept)object3).getCodeMeaning());
        CodedSequenceItem codedSequenceItem = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept.getCodedSequenceItem());
        TestLaterality.assertEquals((String)"Checking converted left by CodedSequenceItem code meaning", (String)object2, (String)codedSequenceItem.getCodeMeaning());
        displayableLateralityConcept = new DisplayableLateralityConcept("C0205090", "24028007", "SRT", "SRT", null, "G-A100", "Right", "R", null, null, null);
        object = new DisplayableLateralityConcept("C0222600", "73056007", "SRT", "SNM3", null, "T-04020", "Right breast", null, null, null, null);
        object2 = "Right breast";
        object3 = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept);
        TestLaterality.assertEquals((String)"Checking converted right by concept", (Object)object, (Object)object3);
        TestLaterality.assertEquals((String)"Checking converted right by code meaning", (String)object2, (String)((CodedConcept)object3).getCodeMeaning());
        codedSequenceItem = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept.getCodedSequenceItem());
        TestLaterality.assertEquals((String)"Checking converted right by CodedSequenceItem code meaning", (String)object2, (String)codedSequenceItem.getCodeMeaning());
        displayableLateralityConcept = new DisplayableLateralityConcept("C0238767", "51440002", "SRT", "SRT", null, "G-A102", "Right and left", "B", null, null, null);
        object = new DisplayableLateralityConcept("C0222605", "63762007", "SRT", "SNM3", null, "T-04080", "Both breasts", null, null, null, null);
        object2 = "Both breasts";
        object3 = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept);
        TestLaterality.assertEquals((String)"Checking converted both by concept", (Object)object, (Object)object3);
        TestLaterality.assertEquals((String)"Checking converted both by code meaning", (String)object2, (String)((CodedConcept)object3).getCodeMeaning());
        codedSequenceItem = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept.getCodedSequenceItem());
        TestLaterality.assertEquals((String)"Checking converted both by CodedSequenceItem code meaning", (String)object2, (String)codedSequenceItem.getCodeMeaning());
        displayableLateralityConcept = new DisplayableLateralityConcept("C0205092", "66459002", "SRT", "SRT", null, "G-A103", "Unilateral", "U", null, null, null);
        object = "Unilateral";
        object2 = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept);
        TestLaterality.assertEquals((String)"Checking unconverted unpaired by concept", (Object)displayableLateralityConcept, (Object)object2);
        TestLaterality.assertEquals((String)"Checking unconverted unpaired by code meaning", (String)object, (String)((CodedConcept)object2).getCodeMeaning());
        object3 = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept.getCodedSequenceItem());
        TestLaterality.assertEquals((String)"Checking converted unpaired by CodedSequenceItem code meaning", (String)object, (String)((CodedSequenceItem)object3).getCodeMeaning());
    }
}

