/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.LossyImageCompression;
import com.pixelmed.dicom.TagFromName;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLossyImageCompressionDisplayAnnotation
extends TestCase {
    private static final String[] suppliedLossy = new String[]{"", "01"};
    private static final String[] suppliedMethod = new String[]{"", "ISO_10918_1"};
    private static final String[] suppliedRatio = new String[]{"0", "0.0", "1", "1.50", "10", "10.", "10.0"};
    private static final String[][][] expected = new String[][][]{{{"", "", "Lossy 1:1", "Lossy 1.5:1", "Lossy 10:1", "Lossy 10:1", "Lossy 10:1"}, {"Lossy JPEG", "Lossy JPEG", "JPEG 1:1", "JPEG 1.5:1", "JPEG 10:1", "JPEG 10:1", "JPEG 10:1"}}, {{"Lossy", "Lossy", "Lossy 1:1", "Lossy 1.5:1", "Lossy 10:1", "Lossy 10:1", "Lossy 10:1"}, {"Lossy JPEG", "Lossy JPEG", "JPEG 1:1", "JPEG 1.5:1", "JPEG 10:1", "JPEG 10:1", "JPEG 10:1"}}};

    public TestLossyImageCompressionDisplayAnnotation(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestLossyImageCompressionDisplayAnnotation");
        testSuite.addTest((Test)new TestLossyImageCompressionDisplayAnnotation("TestLossyImageCompressionDisplayAnnotation_values"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestLossyImageCompressionDisplayAnnotation_values() throws Exception {
        AttributeList attributeList = new AttributeList();
        for (int i = 0; i < suppliedLossy.length; ++i) {
            for (int j = 0; j < suppliedMethod.length; ++j) {
                for (int k = 0; k < suppliedRatio.length; ++k) {
                    Object object = new CodeStringAttribute(TagFromName.LossyImageCompression);
                    ((Attribute)object).addValue(suppliedLossy[i]);
                    attributeList.put((Attribute)object);
                    object = new CodeStringAttribute(TagFromName.LossyImageCompressionMethod);
                    ((Attribute)object).addValue(suppliedMethod[j]);
                    attributeList.put((Attribute)object);
                    object = new DecimalStringAttribute(TagFromName.LossyImageCompressionRatio);
                    ((Attribute)object).addValue(suppliedRatio[k]);
                    attributeList.put((Attribute)object);
                    object = LossyImageCompression.describeLossyCompression(attributeList);
                    TestLossyImageCompressionDisplayAnnotation.assertEquals((String)("Checking l=" + suppliedLossy[i] + ", m=" + suppliedMethod[j] + ", r=" + suppliedRatio[k] + " got "), (String)expected[i][j][k], (String)object);
                }
            }
        }
    }
}

