/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafePrivateGEPACSRelated
extends TestCase {
    public TestSafePrivateGEPACSRelated(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSafePrivateGEPACSRelated");
        testSuite.addTest((Test)new TestSafePrivateGEPACSRelated("TestSafePrivateGEPACSRelated_FromTag"));
        testSuite.addTest((Test)new TestSafePrivateGEPACSRelated("TestSafePrivateGEPACSRelated_CreatorFromList"));
        testSuite.addTest((Test)new TestSafePrivateGEPACSRelated("TestSafePrivateGEPACSRelated_AddedToList"));
        testSuite.addTest((Test)new TestSafePrivateGEPACSRelated("TestSafePrivateGEPACSRelated_FromFile"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSafePrivateGEPACSRelated_FromTag() throws Exception {
        TestSafePrivateGEPACSRelated.assertTrue((String)"Checking Reject Image Flag is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEIIS PACS", new AttributeTag(2307, 4112)));
    }

    public void TestSafePrivateGEPACSRelated_CreatorFromList() throws Exception {
        AttributeList attributeList = new AttributeList();
        LongStringAttribute longStringAttribute = new LongStringAttribute(new AttributeTag(2307, 16));
        ((Attribute)longStringAttribute).addValue("GEIIS PACS");
        attributeList.put(longStringAttribute);
        TestSafePrivateGEPACSRelated.assertTrue((String)"Checking Reject Image Flag is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(2307, 4112), attributeList));
    }

    public void TestSafePrivateGEPACSRelated_AddedToList() throws Exception {
        AttributeList attributeList = new AttributeList();
        Attribute attribute = new LongStringAttribute(new AttributeTag(2307, 16));
        attribute.addValue("GEIIS PACS");
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(new AttributeTag(2307, 4112));
        attribute.addValue(0);
        attributeList.put(attribute);
        attributeList.removeUnsafePrivateAttributes();
        TestSafePrivateGEPACSRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(2307, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEPACSRelated.assertTrue((String)"Checking Reject Image Flag is not removed", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(2307, 4112), attributeList));
    }

    public void TestSafePrivateGEPACSRelated_FromFile() throws Exception {
        AttributeList attributeList = new AttributeList();
        String string = System.getProperty("com.pixelmed.test.filepath");
        attributeList.read(new File(string, "philipsctwithgepacsprivateattributes.dcm"));
        attributeList.removeUnsafePrivateAttributes();
        TestSafePrivateGEPACSRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(new AttributeTag(2307, 16)) != null ? 1 : 0) != 0);
        TestSafePrivateGEPACSRelated.assertTrue((String)"Checking Reject Image Flag is not removed", (attributeList.get(new AttributeTag(2307, 4112)) != null ? 1 : 0) != 0);
    }
}

