/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ThreadUtilities;
import java.awt.Graphics;
import javax.swing.JFrame;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestThreadUtilitiesEventDispatchThread
extends TestCase {
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TestThreadUtilitiesEventDispatchThread.class);
    protected static final int waitIntervalWhenSleeping = 10;
    private volatile boolean windowHasBeenPainted = false;

    public TestThreadUtilitiesEventDispatchThread(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestThreadUtilitiesEventDispatchThread");
        testSuite.addTest((Test)new TestThreadUtilitiesEventDispatchThread("TestThreadUtilitiesEventDispatchThread_MainThread"));
        testSuite.addTest((Test)new TestThreadUtilitiesEventDispatchThread("TestThreadUtilitiesEventDispatchThread_JFrameSubClassThread"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestThreadUtilitiesEventDispatchThread_MainThread() {
        boolean bl = false;
        try {
            ThreadUtilities.checkIsEventDispatchThreadElseException();
        }
        catch (RuntimeException runtimeException) {
            bl = true;
        }
        TestThreadUtilitiesEventDispatchThread.assertTrue((String)"Not on EDT", (boolean)bl);
    }

    public void TestThreadUtilitiesEventDispatchThread_JFrameSubClassThread() {
        this.windowHasBeenPainted = false;
        JFrameSubClass jFrameSubClass = new JFrameSubClass();
        jFrameSubClass.setVisible(true);
        try {
            while (!this.windowHasBeenPainted) {
                Thread.currentThread();
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            slf4jlogger.error("", interruptedException);
        }
    }

    private class JFrameSubClass
    extends JFrame {
        JFrameSubClass() {
            boolean bl = false;
            try {
                ThreadUtilities.checkIsEventDispatchThreadElseException();
            }
            catch (RuntimeException runtimeException) {
                bl = true;
            }
            Assert.assertTrue((String)"Constructor not on EDT", (boolean)bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            System.err.println("JFrameSubClass.paint():");
            super.paint(graphics);
            boolean bl = false;
            try {
                try {
                    ThreadUtilities.checkIsEventDispatchThreadElseException();
                }
                catch (RuntimeException runtimeException) {
                    bl = true;
                }
                Assert.assertTrue((String)"Paint() is on EDT", (!bl ? 1 : 0) != 0);
            }
            finally {
                TestThreadUtilitiesEventDispatchThread.this.windowHasBeenPainted = true;
            }
        }
    }
}

