/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.util.Locale;

public class ColorUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/ColorUtilities.java,v 1.14 2025/01/29 10:58:09 dclunie Exp $";

    private ColorUtilities() {
    }

    public static int[] getIntegerScaledCIELabFromCIELab(float[] fArray) {
        int[] nArray = new int[]{Math.round(fArray[0] * 65535.0f / 100.0f), Math.round((fArray[1] + 128.0f) * 65535.0f / 255.0f), Math.round((fArray[2] + 128.0f) * 65535.0f / 255.0f)};
        return nArray;
    }

    public static float[] getCIELabPCSFromIntegerScaledCIELabPCS(int[] nArray) {
        float[] fArray = new float[]{(float)((double)nArray[0] / 65535.0 * 100.0), (float)((double)nArray[1] / 65535.0 * 255.0 - 128.0), (float)((double)nArray[2] / 65535.0 * 255.0 - 128.0)};
        return fArray;
    }

    public static float[] getCIELabFromXYZ(float[] fArray) {
        double d = (double)fArray[0] / 95.047;
        double d2 = (double)fArray[1] / 100.0;
        double d3 = (double)fArray[2] / 108.883;
        d = d > 0.008856 ? Math.pow(d, 0.3333333333333333) : 7.787 * d + 0.13793103448275862;
        d2 = d2 > 0.008856 ? Math.pow(d2, 0.3333333333333333) : 7.787 * d2 + 0.13793103448275862;
        d3 = d3 > 0.008856 ? Math.pow(d3, 0.3333333333333333) : 7.787 * d3 + 0.13793103448275862;
        float[] fArray2 = new float[]{(float)(116.0 * d2 - 16.0), (float)(500.0 * (d - d2)), (float)(200.0 * (d2 - d3))};
        return fArray2;
    }

    public static float[] getCIEXYZFromLAB(float[] fArray) {
        double d = (fArray[0] + 16.0f) / 116.0f;
        double d2 = (double)(fArray[1] / 500.0f) + d;
        double d3 = d - (double)(fArray[2] / 200.0f);
        double d4 = Math.pow(d, 3.0);
        double d5 = Math.pow(d2, 3.0);
        double d6 = Math.pow(d3, 3.0);
        d = d4 > 0.008856 ? d4 : (d - 0.13793103448275862) / 7.787;
        d2 = d5 > 0.008856 ? d5 : (d2 - 0.13793103448275862) / 7.787;
        d3 = d6 > 0.008856 ? d6 : (d3 - 0.13793103448275862) / 7.787;
        float[] fArray2 = new float[]{(float)(95.047 * d2), (float)(100.0 * d), (float)(108.883 * d3)};
        return fArray2;
    }

    public static float[] getCIEXYZPCSFromSRGB(int[] nArray) {
        double d = (double)nArray[0] / 255.0;
        double d2 = (double)nArray[1] / 255.0;
        double d3 = (double)nArray[2] / 255.0;
        d = d > 0.04045 ? Math.pow((d + 0.055) / 1.055, 2.4) : (d /= 12.92);
        d2 = d2 > 0.04045 ? Math.pow((d2 + 0.055) / 1.055, 2.4) : (d2 /= 12.92);
        d3 = d3 > 0.04045 ? Math.pow((d3 + 0.055) / 1.055, 2.4) : (d3 /= 12.92);
        float[] fArray = new float[]{(float)((d *= 100.0) * 0.4124 + (d2 *= 100.0) * 0.3576 + (d3 *= 100.0) * 0.1805), (float)(d * 0.2126 + d2 * 0.7152 + d3 * 0.0722), (float)(d * 0.0193 + d2 * 0.1192 + d3 * 0.9505)};
        return fArray;
    }

    public static int[] getSRGBFromCIEXYZPCS(float[] fArray) {
        double d = fArray[0] / 100.0f;
        double d2 = fArray[1] / 100.0f;
        double d3 = fArray[2] / 100.0f;
        double d4 = d * 3.2406 + d2 * -1.5372 + d3 * -0.4986;
        double d5 = d * -0.9689 + d2 * 1.8758 + d3 * 0.0415;
        double d6 = d * 0.0557 + d2 * -0.204 + d3 * 1.057;
        d4 = d4 > 0.0031308 ? 1.055 * Math.pow(d4, 0.4166666666666667) - 0.055 : 12.92 * d4;
        d5 = d5 > 0.0031308 ? 1.055 * Math.pow(d5, 0.4166666666666667) - 0.055 : 12.92 * d5;
        d6 = d6 > 0.0031308 ? 1.055 * Math.pow(d6, 0.4166666666666667) - 0.055 : 12.92 * d6;
        int[] nArray = new int[]{(int)Math.round(d4 * 255.0), (int)Math.round(d5 * 255.0), (int)Math.round(d6 * 255.0)};
        return nArray;
    }

    public static float[] getCIELabPCSFromSRGB(int[] nArray) {
        return ColorUtilities.getCIELabFromXYZ(ColorUtilities.getCIEXYZPCSFromSRGB(nArray));
    }

    public static int[] getIntegerScaledCIELabPCSFromSRGB(int[] nArray) {
        return ColorUtilities.getIntegerScaledCIELabFromCIELab(ColorUtilities.getCIELabPCSFromSRGB(nArray));
    }

    public static int[] getSRGBFromCIELabPCS(float[] fArray) {
        return ColorUtilities.getSRGBFromCIEXYZPCS(ColorUtilities.getCIEXYZFromLAB(fArray));
    }

    public static int[] getSRGBFromIntegerScaledCIELabPCS(int[] nArray) {
        return ColorUtilities.getSRGBFromCIELabPCS(ColorUtilities.getCIELabPCSFromIntegerScaledCIELabPCS(nArray));
    }

    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            if (stringArray.length == 4) {
                int[] nArray = new int[]{stringArray[1].startsWith("0x") ? Integer.parseInt(stringArray[1].replaceFirst("0x", ""), 16) : Integer.parseInt(stringArray[1]), stringArray[2].startsWith("0x") ? Integer.parseInt(stringArray[2].replaceFirst("0x", ""), 16) : Integer.parseInt(stringArray[2]), stringArray[3].startsWith("0x") ? Integer.parseInt(stringArray[3].replaceFirst("0x", ""), 16) : Integer.parseInt(stringArray[3])};
                int[] nArray2 = null;
                String string = null;
                String string2 = null;
                if (stringArray[0].toLowerCase(Locale.US).equals("sRGB8toCIELab16".toLowerCase(Locale.US))) {
                    nArray2 = ColorUtilities.getIntegerScaledCIELabPCSFromSRGB(nArray);
                    string = "sRGB8";
                    string2 = "CIELab16";
                    bl = false;
                } else if (stringArray[0].toLowerCase(Locale.US).equals("CIELab16tosRGB8".toLowerCase(Locale.US))) {
                    nArray2 = ColorUtilities.getSRGBFromIntegerScaledCIELabPCS(nArray);
                    string = "CIELab16";
                    string2 = "sRGB8";
                    bl = false;
                } else {
                    System.err.println("Unrecognized conversion type " + stringArray[0]);
                }
                if (nArray2 != null) {
                    System.err.println(string + ": " + nArray[0] + " " + nArray[1] + " " + nArray[2] + " (dec) (0x" + Integer.toHexString(nArray[0]) + " 0x" + Integer.toHexString(nArray[1]) + " 0x" + Integer.toHexString(nArray[2]) + ")");
                    System.err.println(string2 + ": " + nArray2[0] + " " + nArray2[1] + " " + nArray2[2] + " (dec) (0x" + Integer.toHexString(nArray2[0]) + " 0x" + Integer.toHexString(nArray2[1]) + " 0x" + Integer.toHexString(nArray2[2]) + ")");
                }
            } else {
                System.err.println("Error: incorrect number of arguments");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (bl) {
            System.err.println("Usage: ColorUtilities sRGB8toCIELab16|CIELab16tosRGB8 R|L G|a B|b");
        }
    }
}

