/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;

class PathRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/PathRequestHandler.java,v 1.20 2025/01/29 10:58:09 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(PathRequestHandler.class);
    private static final String faviconPath = "favicon.ico";
    private static final String actualIndexPath = "index.html";

    protected PathRequestHandler(String string) {
        super(string);
    }

    @Override
    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        block15: {
            try {
                String string4 = webRequest.getPath();
                slf4jlogger.debug("generateResponseToGetRequest(): Was asked for requestPath {}", string4);
                if (string4 == null) {
                    throw new Exception("No such path - path is null - =\"" + string4 + "\"");
                }
                if (string4.equals("/") || string4.toLowerCase(Locale.US).equals("/index.html") || string4.toLowerCase(Locale.US).equals("/index.htm")) {
                    slf4jlogger.debug("generateResponseToGetRequest(): root path");
                    string4 = "/index.html";
                }
                if (string4.equals("/" + this.stylesheetPath) || string4.equals("/favicon.ico") || string4.equals("/index.html") || string4.startsWith("/dicomviewer")) {
                    String string5;
                    slf4jlogger.debug("generateResponseToGetRequest(): Was asked for file {}", string4);
                    String string6 = new File(string4).getName();
                    if (string4.startsWith("/dicomviewer")) {
                        string6 = "dicomviewer/" + string6;
                    }
                    slf4jlogger.debug("generateResponseToGetRequest(): Trying to find amongst resources {}", string6);
                    String string7 = "/" + string6;
                    slf4jlogger.debug("generateResponseToGetRequest(): Looking for {}", string7);
                    InputStream inputStream = PathRequestHandler.class.getResourceAsStream(string7);
                    if (inputStream == null) {
                        string7 = "/com/pixelmed/web/" + string6;
                        slf4jlogger.debug("generateResponseToGetRequest(): Failed; so look instead for {}", string7);
                        inputStream = PathRequestHandler.class.getResourceAsStream(string7);
                        if (inputStream == null) {
                            throw new Exception("No such resource as " + string4);
                        }
                    }
                    boolean bl = false;
                    if (string6.matches(".*[.][cC][sS][sS]$")) {
                        string5 = "text/css";
                        bl = true;
                    } else if (string6.matches(".*[.][hH][tT][mM][lL]*$")) {
                        string5 = "text/html";
                        bl = true;
                    } else {
                        string5 = string6.matches(".*[.][iI][cC][oO]$") ? "image/x-icon" : "application/octet-stream";
                    }
                    slf4jlogger.debug("generateResponseToGetRequest(): contentType {}", string5);
                    if (bl) {
                        int n;
                        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), "UTF-8");
                        StringBuffer stringBuffer = new StringBuffer();
                        char[] cArray = new char[1024];
                        while ((n = inputStreamReader.read(cArray, 0, 1024)) > 0) {
                            slf4jlogger.debug("generateResponseToGetRequest(): Read {} chars", n);
                            stringBuffer.append(cArray, 0, n);
                        }
                        this.sendHeaderAndBodyText(outputStream, stringBuffer.toString(), string6, string5);
                    } else {
                        this.sendHeaderAndBodyOfStream(outputStream, inputStream, string6, string5);
                    }
                    break block15;
                }
                throw new Exception("No such path is permitted =\"" + string4 + "\"");
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                slf4jlogger.debug("generateResponseToGetRequest(): Sending 404 Not Found");
                PathRequestHandler.send404NotFound(outputStream, exception.getMessage());
            }
        }
    }
}

