/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.web.WebRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

abstract class RequestHandler {
    static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/RequestHandler.java,v 1.17 2025/01/29 10:58:10 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RequestHandler.class);
    protected String stylesheetPath;
    private static final SimpleDateFormat responseDateTimeFormatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

    protected RequestHandler(String string) {
        this.stylesheetPath = string;
    }

    protected abstract void generateResponseToGetRequest(DatabaseInformationModel var1, String var2, String var3, WebRequest var4, String var5, OutputStream var6) throws IOException;

    public final void sendHeaderAndBodyOfStream(OutputStream outputStream, InputStream inputStream, String string, String string2) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        printWriter.print("HTTP/1.1 200 OK\r\n");
        printWriter.print("Content-Type: " + string2 + "\r\n");
        printWriter.print("Content-Disposition: filename=" + string + "\r\n");
        printWriter.print("\r\n");
        printWriter.flush();
        CopyStream.copy(new BufferedInputStream(inputStream), outputStream);
        outputStream.flush();
    }

    public static final String getFormattedDateTimeForResponse(Date date) {
        return responseDateTimeFormatter.format(date);
    }

    public final void sendHeaderAndBodyOfFile(OutputStream outputStream, File file, String string, String string2) throws IOException {
        this.sendHeaderAndBodyOfFile(outputStream, file, string, string2, null);
    }

    public final void sendHeaderAndBodyOfFile(OutputStream outputStream, File file, String string, String string2, Date date) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        long l = file.length();
        slf4jlogger.debug("sendHeaderAndBodyOfFile(): Length = {}", l);
        printWriter.print("HTTP/1.1 200 OK\r\n");
        if (date != null) {
            printWriter.print("Last-Modified: " + RequestHandler.getFormattedDateTimeForResponse(date) + "\r\n");
        }
        printWriter.print("Content-Type: " + string2 + "\r\n");
        printWriter.print("Content-Length: " + l + "\r\n");
        printWriter.print("Content-Disposition: filename=" + string + "\r\n");
        printWriter.print("\r\n");
        printWriter.flush();
        CopyStream.copy(new BufferedInputStream(new FileInputStream(file)), outputStream);
        outputStream.flush();
    }

    public final void sendHeaderAndBodyText(OutputStream outputStream, String string, String string2, String string3) throws IOException {
        this.sendHeaderAndBodyText(outputStream, string, string2, string3, null);
    }

    public final void sendHeaderAndBodyText(OutputStream outputStream, String string, String string2, String string3, Date date) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        long l = string.length();
        printWriter.print("HTTP/1.1 200 OK\r\n");
        if (date != null) {
            printWriter.print("Last-Modified: " + RequestHandler.getFormattedDateTimeForResponse(date) + "\r\n");
        }
        printWriter.print("Content-Type: " + string3 + "\r\n");
        printWriter.print("Content-Length: " + l + "\r\n");
        printWriter.print("Content-Disposition: filename=" + string2 + "\r\n");
        printWriter.print("\r\n");
        printWriter.print(string);
        printWriter.flush();
    }

    public static final void send404NotFound(OutputStream outputStream, String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            printWriter.print("HTTP/1.1 404 Not Found - " + string + "\r\n");
            printWriter.flush();
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
        }
    }
}

