/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.AppletDisplayRequestHandler;
import com.pixelmed.web.HttpServer;
import com.pixelmed.web.ImageDisplayRequestHandler;
import com.pixelmed.web.InstanceListRequestHandler;
import com.pixelmed.web.PathRequestHandler;
import com.pixelmed.web.PatientListRequestHandler;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.SeriesListRequestHandler;
import com.pixelmed.web.StudyListRequestHandler;
import com.pixelmed.web.WadoRequestHandler;
import com.pixelmed.web.WebRequest;
import com.pixelmed.web.WebServerApplicationProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RequestTypeServer
extends HttpServer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/RequestTypeServer.java,v 1.32 2025/01/29 10:58:10 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RequestTypeServer.class);
    private static final String imageDisplayTemplateFileName = "ImageDisplayTemplate.tpl";
    private static final String appletDisplayTemplateFileName = "AppletDisplayTemplate.tpl";
    private String rootURL;
    private String stylesheetPath;
    private String requestTypeToUseForInstances;
    private DatabaseInformationModel databaseInformationModel;

    @Override
    protected HttpServer.Worker createWorker() {
        return new RequestTypeWorker();
    }

    public RequestTypeServer(String string, String string2, int n, String string3, int n2, String string4, String string5, String string6, int n3) {
        try {
            this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(string);
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            new Thread(new StorageSOPClassSCPDispatcher(n, string3, file, new OurReceivedObjectHandler(), null, null, null, false)).start();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        this.doCommonConstructorStuff(this.databaseInformationModel, n2, string4, string5, string6, n3);
    }

    public RequestTypeServer(String string, String string2, int n, String string3, int n2, String string4, String string5, String string6) {
        this(string, string2, n, string3, n2, string4, string5, string6, defaultNumberOfWorkers);
    }

    public RequestTypeServer(DatabaseInformationModel databaseInformationModel, WebServerApplicationProperties webServerApplicationProperties) {
        int n = webServerApplicationProperties.getNumberOfWorkers();
        if (n <= 0) {
            n = defaultNumberOfWorkers;
        }
        this.doCommonConstructorStuff(databaseInformationModel, webServerApplicationProperties.getListeningPort(), webServerApplicationProperties.getRootURL(), webServerApplicationProperties.getStylesheetPath(), webServerApplicationProperties.getRequestTypeToUseForInstances(), n);
    }

    public RequestTypeServer(DatabaseInformationModel databaseInformationModel, int n, String string, String string2, String string3) {
        this.doCommonConstructorStuff(databaseInformationModel, n, string, string2, string3, defaultNumberOfWorkers);
    }

    private void doCommonConstructorStuff(DatabaseInformationModel databaseInformationModel, int n, String string, String string2, String string3, int n2) {
        this.rootURL = string;
        slf4jlogger.trace("doCommonConstructorStuff(): rootURL supplied = {}", string);
        if (string == null || string.length() == 0) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                if (inetAddress != null) {
                    string = inetAddress.getCanonicalHostName();
                    slf4jlogger.trace("doCommonConstructorStuff(): rootURL from local InetAddress = {}", string);
                }
            }
            catch (UnknownHostException unknownHostException) {
                slf4jlogger.error("", unknownHostException);
            }
        }
        this.stylesheetPath = string2;
        slf4jlogger.trace("doCommonConstructorStuff(): stylesheetPath = {}", string2);
        this.databaseInformationModel = databaseInformationModel;
        this.requestTypeToUseForInstances = string3;
        try {
            slf4jlogger.trace("doCommonConstructorStuff(): port = {}", n);
            super.initializeThreadPool(n, n2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        slf4jlogger.debug("ready");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 7) {
            System.err.println("Usage: database imagefolder DICOMport DICOMAET HTTPport hostAddress requesttype");
            System.exit(0);
        }
        String string = "stylesheet.css";
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        int n = Integer.parseInt(stringArray[2]);
        String string4 = stringArray[3];
        int n2 = Integer.parseInt(stringArray[4]);
        String string5 = "http://" + stringArray[5] + ":" + stringArray[4] + "/";
        String string6 = stringArray[6];
        new Thread(new RequestTypeServer(string2, string3, n, string4, n2, string5, string, string6)).start();
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                slf4jlogger.debug("Received: {} from {} in {}", string, string3, string2);
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    RequestTypeServer.this.databaseInformationModel.insertObject(attributeList, string, "C");
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to insert {} received from {} in {} into database", string, string3, string2, exception);
                }
            }
        }
    }

    protected class RequestTypeWorker
    extends HttpServer.Worker {
        private PathRequestHandler pathRequestHandler = null;
        private WadoRequestHandler wadoRequestHandler = null;
        private PatientListRequestHandler patientListRequestHandler = null;
        private StudyListRequestHandler studyListRequestHandler = null;
        private SeriesListRequestHandler seriesListRequestHandler = null;
        private InstanceListRequestHandler instanceListRequestHandler = null;
        private ImageDisplayRequestHandler imageDisplayRequestHandler = null;
        private AppletDisplayRequestHandler appletDisplayRequestHandler = null;

        protected RequestTypeWorker() {
        }

        @Override
        protected void generateResponseToGetRequest(String string, OutputStream outputStream) throws IOException {
            block18: {
                slf4jlogger.debug("RequestTypeWorker.generateResponseToGetRequest(): Requested URI: {}", string);
                try {
                    WebRequest webRequest = new WebRequest(string);
                    String string2 = webRequest.getRequestType();
                    if (string2 == null) {
                        if (this.pathRequestHandler == null) {
                            this.pathRequestHandler = new PathRequestHandler(RequestTypeServer.this.stylesheetPath);
                        }
                        this.pathRequestHandler.generateResponseToGetRequest(null, null, null, webRequest, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("WADO")) {
                        if (this.wadoRequestHandler == null) {
                            this.wadoRequestHandler = new WadoRequestHandler(null);
                        }
                        this.wadoRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, null, null, webRequest, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("PATIENTLIST")) {
                        if (this.patientListRequestHandler == null) {
                            this.patientListRequestHandler = new PatientListRequestHandler(RequestTypeServer.this.stylesheetPath);
                        }
                        this.patientListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, null, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("STUDYLIST")) {
                        if (this.studyListRequestHandler == null) {
                            this.studyListRequestHandler = new StudyListRequestHandler(RequestTypeServer.this.stylesheetPath);
                        }
                        this.studyListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("SERIESLIST")) {
                        if (this.seriesListRequestHandler == null) {
                            this.seriesListRequestHandler = new SeriesListRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.this.requestTypeToUseForInstances);
                        }
                        this.seriesListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("INSTANCELIST")) {
                        if (this.instanceListRequestHandler == null) {
                            this.instanceListRequestHandler = new InstanceListRequestHandler(RequestTypeServer.this.stylesheetPath);
                        }
                        this.instanceListRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("IMAGEDISPLAY")) {
                        if (this.imageDisplayRequestHandler == null) {
                            this.imageDisplayRequestHandler = new ImageDisplayRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.imageDisplayTemplateFileName);
                        }
                        this.imageDisplayRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block18;
                    }
                    if (string2.equals("APPLETDISPLAY")) {
                        if (this.appletDisplayRequestHandler == null) {
                            this.appletDisplayRequestHandler = new AppletDisplayRequestHandler(RequestTypeServer.this.stylesheetPath, RequestTypeServer.appletDisplayTemplateFileName);
                        }
                        this.appletDisplayRequestHandler.generateResponseToGetRequest(RequestTypeServer.this.databaseInformationModel, RequestTypeServer.this.rootURL, null, webRequest, null, outputStream);
                        break block18;
                    }
                    throw new Exception("Unrecognized requestType \"" + string2 + "\"");
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                    slf4jlogger.debug("RequestTypeWorker.generateResponseToGetRequest(): Sending 404 Not Found");
                    RequestHandler.send404NotFound(outputStream, exception.getMessage());
                }
            }
        }
    }
}

