/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

class StudyListRequestHandler
extends RequestHandler {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/StudyListRequestHandler.java,v 1.18 2025/01/29 10:58:10 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StudyListRequestHandler.class);
    private Comparator compareDatabaseAttributesByStudyDate = new CompareDatabaseAttributesByStudyDate();

    protected StudyListRequestHandler(String string) {
        super(string);
    }

    @Override
    protected void generateResponseToGetRequest(DatabaseInformationModel databaseInformationModel, String string, String string2, WebRequest webRequest, String string3, OutputStream outputStream) throws IOException {
        try {
            Map map = webRequest.getParameters();
            if (map == null) {
                throw new Exception("Missing parameters for requestType \"" + string3 + "\"");
            }
            String string4 = (String)map.get("primaryKey");
            if (string4 == null) {
                throw new Exception("Missing primaryKey parameter for requestType \"" + string3 + "\"");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            stringBuffer.append("<head>");
            stringBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
            if (this.stylesheetPath != null) {
                stringBuffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
                stringBuffer.append(string);
                stringBuffer.append(this.stylesheetPath);
                stringBuffer.append("\">");
            }
            stringBuffer.append("</head>\r\n");
            stringBuffer.append("<body><table>\r\n");
            stringBuffer.append("<tr><th>Study ID</th><th>Accession #</th><th>Study Date</th><th>Study Time</th><th>Study Description</th></tr>\r\n");
            String string5 = databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.STUDY);
            ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.STUDY, string4);
            Collections.sort(arrayList, this.compareDatabaseAttributesByStudyDate);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Map map2 = (Map)arrayList.get(i);
                String string6 = (String)map2.get("STUDYID");
                String string7 = (String)map2.get("ACCESSIONNUMBER");
                String string8 = (String)map2.get("STUDYDATE");
                String string9 = (String)map2.get("STUDYTIME");
                String string10 = (String)map2.get("STUDYDESCRIPTION");
                String string11 = (String)map2.get("STUDYINSTANCEUID");
                String string12 = (String)map2.get(string5);
                stringBuffer.append("<tr>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append("<a href=\"");
                stringBuffer.append(string);
                stringBuffer.append("?requestType=SERIESLIST");
                stringBuffer.append("&primaryKey=");
                stringBuffer.append(string12);
                stringBuffer.append("&studyUID=");
                stringBuffer.append(string11);
                stringBuffer.append("\">");
                stringBuffer.append(string6 == null || string6.length() == 0 ? "NONE" : string6);
                stringBuffer.append("</a>");
                stringBuffer.append("</td>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append(string7 == null ? "&nbsp;" : string7);
                stringBuffer.append("</td>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append(string8 == null ? "&nbsp;" : string8);
                stringBuffer.append("</span>");
                stringBuffer.append("</td>");
                stringBuffer.append("<td class=\"centered\">");
                stringBuffer.append(string9 == null ? "&nbsp;" : string9);
                stringBuffer.append("</td>");
                stringBuffer.append("<td>");
                stringBuffer.append(string10 == null ? "&nbsp;" : string10);
                stringBuffer.append("</td>");
                stringBuffer.append("</tr>");
            }
            stringBuffer.append("</table></body></html>\r\n");
            String string13 = stringBuffer.toString();
            this.sendHeaderAndBodyText(outputStream, string13, "studies.html", "text/html");
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            slf4jlogger.debug("generateResponseToGetRequest(): Sending 404 Not Found");
            StudyListRequestHandler.send404NotFound(outputStream, exception.getMessage());
        }
    }

    private class CompareDatabaseAttributesByStudyDate
    implements Comparator {
        private CompareDatabaseAttributesByStudyDate() {
        }

        public int compare(Object object, Object object2) {
            int n = 0;
            String string = (String)((Map)object).get("STUDYDATE");
            String string2 = (String)((Map)object2).get("STUDYDATE");
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            try {
                int n2 = string.length() > 0 ? Integer.parseInt(string) : 0;
                int n3 = string2.length() > 0 ? Integer.parseInt(string2) : 0;
                n = n2 - n3;
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
                n = string.compareTo(string2);
            }
            return n;
        }
    }
}

