/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.web.HttpServer;
import com.pixelmed.web.RequestHandler;
import com.pixelmed.web.WadoRequestHandler;
import com.pixelmed.web.WebRequest;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class WadoServer
extends HttpServer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WadoServer.java,v 1.33 2025/01/29 10:58:10 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(WadoServer.class);
    private DatabaseInformationModel databaseInformationModel;

    @Override
    protected HttpServer.Worker createWorker() {
        return new WADOWorker();
    }

    public WadoServer(String string, String string2, int n, String string3, int n2) {
        try {
            this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(string);
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            new Thread(new StorageSOPClassSCPDispatcher(n, string3, file, new OurReceivedObjectHandler(), null, null, null, false)).start();
            super.initializeThreadPool(n2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static void main(String[] stringArray) {
        String string = "/tmp/testwadodb";
        String string2 = "/tmp/testwadoimages";
        int n = 4007;
        String string3 = "WADOTEST";
        int n2 = 7091;
        new Thread(new WadoServer(string, string2, n, string3, n2)).start();
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                slf4jlogger.debug("Received: {} from {} in {}", string, string3, string2);
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    WadoServer.this.databaseInformationModel.insertObject(attributeList, string, "C");
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to insert {} received from {} in {} into database", string, string3, string2, exception);
                }
            }
        }
    }

    protected class WADOWorker
    extends HttpServer.Worker {
        private WadoRequestHandler wadoRequestHandler = null;

        protected WADOWorker() {
        }

        @Override
        protected void generateResponseToGetRequest(String string, OutputStream outputStream) throws IOException {
            try {
                WebRequest webRequest = new WebRequest(string);
                String string2 = webRequest.getRequestType();
                if (string2 != null && string2.equals("WADO")) {
                    if (this.wadoRequestHandler == null) {
                        this.wadoRequestHandler = new WadoRequestHandler(null);
                    }
                } else {
                    throw new Exception("Unrecognized requestType \"" + string2 + "\"");
                }
                this.wadoRequestHandler.generateResponseToGetRequest(WadoServer.this.databaseInformationModel, null, null, webRequest, null, outputStream);
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                slf4jlogger.debug("WADOWorker.generateResponseToGetRequest(): Sending 404 Not Found");
                RequestHandler.send404NotFound(outputStream, exception.getMessage());
            }
        }
    }
}

