/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.web;

import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class WebRequest {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/web/WebRequest.java,v 1.14 2025/01/29 10:58:10 dclunie Exp $";
    protected String scheme;
    protected String userInfo;
    protected String host;
    protected int port;
    protected String path;
    protected String requestType;
    protected Map parameters;

    public String getScheme() {
        return this.scheme;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Map getParameters() {
        return this.parameters;
    }

    public static Map parseQueryIntoParameters(String string) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                if (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if (stringTokenizer2.hasMoreTokens()) {
                        String string4 = stringTokenizer2.nextToken();
                        if (stringTokenizer2.hasMoreTokens()) {
                            throw new Exception("Unexpected additional text after \"" + string3 + "=" + string4 + "\" in \"" + string2 + "\"");
                        }
                        string3 = URLDecoder.decode(string3, "UTF-8");
                        string4 = URLDecoder.decode(string4, "UTF-8");
                        hashMap.put(string3, string4);
                        continue;
                    }
                    throw new Exception("Missing parameter value for \"" + string3 + "\"");
                }
                throw new Exception("Missing parameter name in \"" + string2 + "\"");
            }
        }
        return hashMap;
    }

    public WebRequest(String string) throws Exception {
        URI uRI = new URI(string);
        this.scheme = uRI.getScheme();
        this.userInfo = uRI.getUserInfo();
        this.host = uRI.getHost();
        this.port = uRI.getPort();
        this.path = uRI.getPath();
        this.parameters = WebRequest.parseQueryIntoParameters(uRI.getRawQuery());
        this.requestType = (String)this.parameters.get("requestType");
    }

    protected WebRequest() {
    }
}

