/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.HuffmanTable;
import com.pixelmed.codec.jpeg.Utilities;
import java.util.Map;

public class MarkerSegmentDHT {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/MarkerSegmentDHT.java,v 1.2 2014/03/21 21:46:20 dclunie Exp $";
    private int nTables = 0;
    private int[] TableClass = new int[4];
    private int[] HuffmanTableIdentifier = new int[4];
    private int[][] nHuffmanCodesOfLengthI = new int[4][];
    private int[][][] ValueOfHuffmanCodeIJ = new int[4][][];

    public MarkerSegmentDHT(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        while (n > 0) {
            int n3;
            if (this.nTables >= 4) {
                throw new Exception("Only 4 tables are permitted");
            }
            this.TableClass[this.nTables] = Utilities.extract8(byArray, n2) >> 4;
            this.HuffmanTableIdentifier[this.nTables] = Utilities.extract8(byArray, n2) & 0xF;
            ++n2;
            --n;
            this.nHuffmanCodesOfLengthI[this.nTables] = new int[16];
            for (n3 = 0; n3 < 16; ++n3) {
                this.nHuffmanCodesOfLengthI[this.nTables][n3] = Utilities.extract8(byArray, n2);
                ++n2;
                --n;
            }
            this.ValueOfHuffmanCodeIJ[this.nTables] = new int[16][];
            for (n3 = 0; n3 < 16; ++n3) {
                this.ValueOfHuffmanCodeIJ[this.nTables][n3] = new int[this.nHuffmanCodesOfLengthI[this.nTables][n3]];
                for (int i = 0; i < this.nHuffmanCodesOfLengthI[this.nTables][n3]; ++i) {
                    this.ValueOfHuffmanCodeIJ[this.nTables][n3][i] = Utilities.extract8(byArray, n2);
                    ++n2;
                    --n;
                }
            }
            ++this.nTables;
        }
    }

    public void addToMapByClassAndIdentifier(Map<String, HuffmanTable> map) {
        for (int i = 0; i < this.nTables; ++i) {
            int n = this.TableClass[i];
            int n2 = this.HuffmanTableIdentifier[i];
            String string = Integer.toString(n) + "+" + Integer.toString(n2);
            map.put(string, new HuffmanTable(n, n2, this.nHuffmanCodesOfLengthI[i], this.ValueOfHuffmanCodeIJ[i]));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tDHT:\n");
        for (int i = 0; i < this.nTables; ++i) {
            stringBuffer.append("\t\t TableClass = " + this.TableClass[i] + "\n");
            stringBuffer.append("\t\t HuffmanTableIdentifier = " + this.HuffmanTableIdentifier[i] + "\n");
            for (int j = 0; j < 16; ++j) {
                stringBuffer.append("\t\t\t nHuffmanCodesOfLength " + j + " = " + this.nHuffmanCodesOfLengthI[i][j] + "\n");
                for (int k = 0; k < this.nHuffmanCodesOfLengthI[i][j]; ++k) {
                    stringBuffer.append("\t\t\t\t ValueOfHuffmanCode " + k + " = " + this.ValueOfHuffmanCodeIJ[i][j][k] + "\n");
                }
            }
        }
        return stringBuffer.toString();
    }
}

