/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple2d;

public abstract class Tuple2f
implements Serializable {
    public float x;
    public float y;

    public Tuple2f(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Tuple2f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
    }

    public Tuple2f(Tuple2f tuple2f) {
        this.x = tuple2f.x;
        this.y = tuple2f.y;
    }

    public Tuple2f(Tuple2d tuple2d) {
        this.x = (float)tuple2d.x;
        this.y = (float)tuple2d.y;
    }

    public Tuple2f() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public final void set(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public final void set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
    }

    public final void set(Tuple2f tuple2f) {
        this.x = tuple2f.x;
        this.y = tuple2f.y;
    }

    public final void set(Tuple2d tuple2d) {
        this.x = (float)tuple2d.x;
        this.y = (float)tuple2d.y;
    }

    public final void get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
    }

    public final void add(Tuple2f tuple2f, Tuple2f tuple2f2) {
        this.x = tuple2f.x + tuple2f2.x;
        this.y = tuple2f.y + tuple2f2.y;
    }

    public final void add(Tuple2f tuple2f) {
        this.x += tuple2f.x;
        this.y += tuple2f.y;
    }

    public final void sub(Tuple2f tuple2f, Tuple2f tuple2f2) {
        this.x = tuple2f.x - tuple2f2.x;
        this.y = tuple2f.y - tuple2f2.y;
    }

    public final void sub(Tuple2f tuple2f) {
        this.x -= tuple2f.x;
        this.y -= tuple2f.y;
    }

    public final void negate(Tuple2f tuple2f) {
        this.x = -tuple2f.x;
        this.y = -tuple2f.y;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public final void scale(float f, Tuple2f tuple2f) {
        this.x = f * tuple2f.x;
        this.y = f * tuple2f.y;
    }

    public final void scale(float f) {
        this.x *= f;
        this.y *= f;
    }

    public final void scaleAdd(float f, Tuple2f tuple2f, Tuple2f tuple2f2) {
        this.x = f * tuple2f.x + tuple2f2.x;
        this.y = f * tuple2f.y + tuple2f2.y;
    }

    public final void scaleAdd(float f, Tuple2f tuple2f) {
        this.x = f * this.x + tuple2f.x;
        this.y = f * this.y + tuple2f.y;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.x);
        int n2 = Float.floatToIntBits(this.y);
        return n ^ n2;
    }

    public boolean equals(Tuple2f tuple2f) {
        return tuple2f != null && this.x == tuple2f.x && this.y == tuple2f.y;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Tuple2f && this.equals((Tuple2f)object);
    }

    public boolean epsilonEquals(Tuple2f tuple2f, float f) {
        return Math.abs(tuple2f.x - this.x) <= f && Math.abs(tuple2f.y - this.y) <= f;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public final void clamp(float f, float f2, Tuple2f tuple2f) {
        this.set(tuple2f);
        this.clamp(f, f2);
    }

    public final void clampMin(float f, Tuple2f tuple2f) {
        this.set(tuple2f);
        this.clampMin(f);
    }

    public final void clampMax(float f, Tuple2f tuple2f) {
        this.set(tuple2f);
        this.clampMax(f);
    }

    public final void absolute(Tuple2f tuple2f) {
        this.set(tuple2f);
        this.absolute();
    }

    public final void clamp(float f, float f2) {
        this.clampMin(f);
        this.clampMax(f2);
    }

    public final void clampMin(float f) {
        if (this.x < f) {
            this.x = f;
        }
        if (this.y < f) {
            this.y = f;
        }
    }

    public final void clampMax(float f) {
        if (this.x > f) {
            this.x = f;
        }
        if (this.y > f) {
            this.y = f;
        }
    }

    public final void absolute() {
        if ((double)this.x < 0.0) {
            this.x = -this.x;
        }
        if ((double)this.y < 0.0) {
            this.y = -this.y;
        }
    }

    public final void interpolate(Tuple2f tuple2f, Tuple2f tuple2f2, float f) {
        this.set(tuple2f);
        this.interpolate(tuple2f2, f);
    }

    public final void interpolate(Tuple2f tuple2f, float f) {
        float f2 = 1.0f - f;
        this.x = f2 * this.x + f * tuple2f.x;
        this.y = f2 * this.y + f * tuple2f.y;
    }
}

