/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple4d;

public abstract class Tuple4f
implements Serializable {
    public float x;
    public float y;
    public float z;
    public float w;

    public Tuple4f(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public Tuple4f(float[] fArray) {
        this.set(fArray);
    }

    public Tuple4f(Tuple4f tuple4f) {
        this.set(tuple4f);
    }

    public Tuple4f(Tuple4d tuple4d) {
        this.set(tuple4d);
    }

    public Tuple4f() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
    }

    public final void set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public final void set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public final void set(Tuple4f tuple4f) {
        this.x = tuple4f.x;
        this.y = tuple4f.y;
        this.z = tuple4f.z;
        this.w = tuple4f.w;
    }

    public final void set(Tuple4d tuple4d) {
        this.x = (float)tuple4d.x;
        this.y = (float)tuple4d.y;
        this.z = (float)tuple4d.z;
        this.w = (float)tuple4d.w;
    }

    public final void get(float[] fArray) {
        fArray[0] = this.x;
        fArray[1] = this.y;
        fArray[2] = this.z;
        fArray[3] = this.w;
    }

    public final void get(Tuple4f tuple4f) {
        tuple4f.x = this.x;
        tuple4f.y = this.y;
        tuple4f.z = this.z;
        tuple4f.w = this.w;
    }

    public final void add(Tuple4f tuple4f, Tuple4f tuple4f2) {
        this.x = tuple4f.x + tuple4f2.x;
        this.y = tuple4f.y + tuple4f2.y;
        this.z = tuple4f.z + tuple4f2.z;
        this.w = tuple4f.w + tuple4f2.w;
    }

    public final void add(Tuple4f tuple4f) {
        this.x += tuple4f.x;
        this.y += tuple4f.y;
        this.z += tuple4f.z;
        this.w += tuple4f.w;
    }

    public final void sub(Tuple4f tuple4f, Tuple4f tuple4f2) {
        this.x = tuple4f.x - tuple4f2.x;
        this.y = tuple4f.y - tuple4f2.y;
        this.z = tuple4f.z - tuple4f2.z;
        this.w = tuple4f.w - tuple4f2.w;
    }

    public final void sub(Tuple4f tuple4f) {
        this.x -= tuple4f.x;
        this.y -= tuple4f.y;
        this.z -= tuple4f.z;
        this.w -= tuple4f.w;
    }

    public final void negate(Tuple4f tuple4f) {
        this.x = -tuple4f.x;
        this.y = -tuple4f.y;
        this.z = -tuple4f.z;
        this.w = -tuple4f.w;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
    }

    public final void scale(float f, Tuple4f tuple4f) {
        this.x = f * tuple4f.x;
        this.y = f * tuple4f.y;
        this.z = f * tuple4f.z;
        this.w = f * tuple4f.w;
    }

    public final void scale(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
    }

    public final void scaleAdd(float f, Tuple4f tuple4f, Tuple4f tuple4f2) {
        this.x = f * tuple4f.x + tuple4f2.x;
        this.y = f * tuple4f.y + tuple4f2.y;
        this.z = f * tuple4f.z + tuple4f2.z;
        this.w = f * tuple4f.w + tuple4f2.w;
    }

    public final void scaleAdd(float f, Tuple4f tuple4f) {
        this.x = f * this.x + tuple4f.x;
        this.y = f * this.y + tuple4f.y;
        this.z = f * this.z + tuple4f.z;
        this.w = f * this.z + tuple4f.w;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y) ^ Float.floatToIntBits(this.z) ^ Float.floatToIntBits(this.w);
    }

    public boolean equals(Tuple4f tuple4f) {
        return tuple4f != null && this.x == tuple4f.x && this.y == tuple4f.y && this.z == tuple4f.z && this.w == tuple4f.w;
    }

    public boolean epsilonEquals(Tuple4f tuple4f, float f) {
        return Math.abs(tuple4f.x - this.x) <= f && Math.abs(tuple4f.y - this.y) <= f && Math.abs(tuple4f.z - this.z) <= f && Math.abs(tuple4f.w - this.w) <= f;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public final void clamp(float f, float f2, Tuple4f tuple4f) {
        this.set(tuple4f);
        this.clamp(f, f2);
    }

    public final void clampMin(float f, Tuple4f tuple4f) {
        this.set(tuple4f);
        this.clampMin(f);
    }

    public final void clampMax(float f, Tuple4f tuple4f) {
        this.set(tuple4f);
        this.clampMax(f);
    }

    public final void absolute(Tuple4f tuple4f) {
        this.set(tuple4f);
        this.absolute();
    }

    public final void clamp(float f, float f2) {
        this.clampMin(f);
        this.clampMax(f2);
    }

    public final void clampMin(float f) {
        if (this.x < f) {
            this.x = f;
        }
        if (this.y < f) {
            this.y = f;
        }
        if (this.z < f) {
            this.z = f;
        }
        if (this.w < f) {
            this.w = f;
        }
    }

    public final void clampMax(float f) {
        if (this.x > f) {
            this.x = f;
        }
        if (this.y > f) {
            this.y = f;
        }
        if (this.z > f) {
            this.z = f;
        }
        if (this.w > f) {
            this.w = f;
        }
    }

    public final void absolute() {
        if ((double)this.x < 0.0) {
            this.x = -this.x;
        }
        if ((double)this.y < 0.0) {
            this.y = -this.y;
        }
        if ((double)this.z < 0.0) {
            this.z = -this.z;
        }
        if ((double)this.w < 0.0) {
            this.w = -this.w;
        }
    }

    public final void interpolate(Tuple4f tuple4f, Tuple4f tuple4f2, float f) {
        this.set(tuple4f);
        this.interpolate(tuple4f2, f);
    }

    public final void interpolate(Tuple4f tuple4f, float f) {
        float f2 = 1.0f - f;
        this.x = f2 * this.x + f * tuple4f.x;
        this.y = f2 * this.y + f * tuple4f.y;
        this.z = f2 * this.z + f * tuple4f.z;
        this.w = f2 * this.w + f * tuple4f.w;
    }
}

