/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.IOException;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.GMatrix;
import javax.vecmath.GVector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;

public class VecmathTest {
    public static String NL = System.getProperty("line.separator");
    public static float epsilon = 1.0E-5f;

    public static boolean equals(double d, double d2) {
        return Math.abs(d - d2) < (double)epsilon;
    }

    public static boolean equals(Matrix3d matrix3d, Matrix3d matrix3d2) {
        return matrix3d.epsilonEquals(matrix3d2, epsilon);
    }

    public static boolean equals(Matrix4d matrix4d, Matrix4d matrix4d2) {
        return matrix4d.epsilonEquals(matrix4d2, (double)epsilon);
    }

    public static boolean equals(Tuple4d tuple4d, Tuple4d tuple4d2) {
        return tuple4d.epsilonEquals(tuple4d2, epsilon);
    }

    public static boolean equals(Tuple3d tuple3d, Tuple3d tuple3d2) {
        return tuple3d.epsilonEquals(tuple3d2, epsilon);
    }

    public static boolean equals(Matrix3f matrix3f, Matrix3f matrix3f2) {
        return matrix3f.epsilonEquals(matrix3f2, epsilon);
    }

    public static boolean equals(Matrix4f matrix4f, Matrix4f matrix4f2) {
        return matrix4f.epsilonEquals(matrix4f2, epsilon);
    }

    public static boolean equals(GMatrix gMatrix, GMatrix gMatrix2) {
        return gMatrix.epsilonEquals(gMatrix2, (double)epsilon);
    }

    public static boolean equals(GVector gVector, GVector gVector2) {
        return gVector.epsilonEquals(gVector2, epsilon);
    }

    public static boolean equals(Tuple4f tuple4f, Tuple4f tuple4f2) {
        return tuple4f.epsilonEquals(tuple4f2, epsilon);
    }

    public static boolean equals(Tuple3f tuple3f, Tuple3f tuple3f2) {
        return tuple3f.epsilonEquals(tuple3f2, epsilon);
    }

    public static boolean equals(AxisAngle4d axisAngle4d, AxisAngle4d axisAngle4d2) {
        if (0.0 < axisAngle4d.x * axisAngle4d2.x + axisAngle4d.y * axisAngle4d2.y + axisAngle4d.z * axisAngle4d2.z) {
            return VecmathTest.equals(axisAngle4d.y * axisAngle4d2.z - axisAngle4d.z * axisAngle4d2.y, 0.0) && VecmathTest.equals(axisAngle4d.z * axisAngle4d2.x - axisAngle4d.x * axisAngle4d2.z, 0.0) && VecmathTest.equals(axisAngle4d.x * axisAngle4d2.y - axisAngle4d.y * axisAngle4d2.x, 0.0) && VecmathTest.equals(axisAngle4d.angle, axisAngle4d2.angle);
        }
        return VecmathTest.equals(axisAngle4d.y * axisAngle4d2.z - axisAngle4d.z * axisAngle4d2.y, 0.0) && VecmathTest.equals(axisAngle4d.z * axisAngle4d2.x - axisAngle4d.x * axisAngle4d2.z, 0.0) && VecmathTest.equals(axisAngle4d.x * axisAngle4d2.y - axisAngle4d.y * axisAngle4d2.x, 0.0) && (VecmathTest.equals(axisAngle4d.angle, -axisAngle4d2.angle) || VecmathTest.equals(axisAngle4d.angle + axisAngle4d2.angle, Math.PI * 2) || VecmathTest.equals(axisAngle4d.angle + axisAngle4d2.angle, Math.PI * -2));
    }

    public static boolean equals(AxisAngle4f axisAngle4f, AxisAngle4f axisAngle4f2) {
        if (0.0f < axisAngle4f.x * axisAngle4f2.x + axisAngle4f.y * axisAngle4f2.y + axisAngle4f.z * axisAngle4f2.z) {
            return VecmathTest.equals(axisAngle4f.y * axisAngle4f2.z - axisAngle4f.z * axisAngle4f2.y, 0.0) && VecmathTest.equals(axisAngle4f.z * axisAngle4f2.x - axisAngle4f.x * axisAngle4f2.z, 0.0) && VecmathTest.equals(axisAngle4f.x * axisAngle4f2.y - axisAngle4f.y * axisAngle4f2.x, 0.0) && VecmathTest.equals(axisAngle4f.angle, axisAngle4f2.angle);
        }
        return VecmathTest.equals(axisAngle4f.y * axisAngle4f2.z - axisAngle4f.z * axisAngle4f2.y, 0.0) && VecmathTest.equals(axisAngle4f.z * axisAngle4f2.x - axisAngle4f.x * axisAngle4f2.z, 0.0) && VecmathTest.equals(axisAngle4f.x * axisAngle4f2.y - axisAngle4f.y * axisAngle4f2.x, 0.0) && (VecmathTest.equals(axisAngle4f.angle, -axisAngle4f2.angle) || VecmathTest.equals(axisAngle4f.angle + axisAngle4f2.angle, Math.PI * 2) || VecmathTest.equals(axisAngle4f.angle + axisAngle4f2.angle, Math.PI * -2));
    }

    public static void ASSERT(boolean bl) {
        if (!bl) {
            throw new InternalError("Vecmath Test Failed!");
        }
    }

    public static void ASSERT(boolean bl, String string) {
        if (!bl) {
            throw new InternalError("Vecmath Test Failed!: " + string);
        }
    }

    public static void exit() {
        System.out.println("java.vecmath all test passed successfully.");
        System.out.print("Quit ?");
        try {
            System.in.read();
        }
        catch (IOException iOException) {}
    }

    public static void main(String[] stringArray) {
        System.out.print("Vector3d ...");
        VecmathTest.Vector3dTest();
        System.out.println("ok.");
        System.out.print("Vector3f ...");
        VecmathTest.Vector3fTest();
        System.out.println("ok.");
        System.out.print("Matrix3d with Quat4d, AxisAngle4d, Point/Vector3d interaction ...");
        VecmathTest.Matrix3dTest();
        System.out.println("ok.");
        System.out.print("Matrix3f with Quat4f, AxisAngle4f, Point/Vector3f interaction ...");
        VecmathTest.Matrix3fTest();
        System.out.println("ok.");
        System.out.print("Matrix4d with Quat4d, AxisAngle4d, Point/Vector3d interaction ...");
        VecmathTest.Matrix4dTest();
        System.out.println("ok.");
        System.out.print("Matrix4f with Quat4f, AxisAngle4f, Point/Vector3f interaction ...");
        VecmathTest.Matrix4fTest();
        System.out.println("ok.");
        System.out.print("GMatrix with GVector interaction ...");
        VecmathTest.GMatrixTest();
        System.out.println("ok.");
        System.out.print("SVD test ...");
        VecmathTest.SVDTest();
        System.out.println("ok.");
        VecmathTest.exit();
    }

    public static void Vector3dTest() {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d(2.0, 3.0, 4.0);
        Vector3d vector3d3 = new Vector3d(2.0, 5.0, -8.0);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d2, vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3d4.dot(vector3d2), 0.0));
        VecmathTest.ASSERT(VecmathTest.equals(vector3d4.dot(vector3d3), 0.0));
        vector3d2.cross(vector3d2, vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2, new Vector3d(-44.0, 24.0, 4.0)));
        VecmathTest.ASSERT(VecmathTest.equals(vector3d3.lengthSquared(), 93.0));
        VecmathTest.ASSERT(VecmathTest.equals(vector3d3.length(), Math.sqrt(93.0)));
        vector3d2.set(vector3d3);
        vector3d3.normalize();
        VecmathTest.ASSERT(VecmathTest.equals(vector3d3.length(), 1.0));
        vector3d2.cross(vector3d3, vector3d2);
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2, vector3d));
        vector3d2.set(1.0, 2.0, 3.0);
        vector3d3.set(-1.0, -6.0, -3.0);
        double d = vector3d2.angle(vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2.length() * vector3d3.length() * Math.cos(d), vector3d2.dot(vector3d3)));
        vector3d2.set(vector3d3);
        d = vector3d2.angle(vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(d, 0.0));
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2.length() * vector3d3.length() * Math.cos(d), vector3d2.dot(vector3d3)));
        vector3d2.set(1.0, 2.0, 3.0);
        vector3d3.set(1.0, 2.0, 3.00001);
        d = vector3d2.angle(vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2.length() * vector3d3.length() * Math.cos(d), vector3d2.dot(vector3d3)));
        vector3d2.set(1.0, 2.0, 3.0);
        vector3d3.set(-1.0, -2.0, -3.00001);
        d = vector3d2.angle(vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2.length() * vector3d3.length() * Math.cos(d), vector3d2.dot(vector3d3)));
    }

    public static void Vector3fTest() {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(2.0f, 3.0f, 4.0f);
        Vector3f vector3f3 = new Vector3f(2.0f, 5.0f, -8.0f);
        Vector3f vector3f4 = new Vector3f();
        vector3f4.cross(vector3f2, vector3f3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3f4.dot(vector3f2), 0.0));
        VecmathTest.ASSERT(VecmathTest.equals(vector3f4.dot(vector3f3), 0.0));
        vector3f2.cross(vector3f2, vector3f3);
        VecmathTest.ASSERT(VecmathTest.equals(vector3f2, new Vector3f(-44.0f, 24.0f, 4.0f)));
        VecmathTest.ASSERT(VecmathTest.equals(vector3f3.lengthSquared(), 93.0));
        VecmathTest.ASSERT(VecmathTest.equals(vector3f3.length(), Math.sqrt(93.0)));
        vector3f2.set(vector3f3);
        vector3f3.normalize();
        VecmathTest.ASSERT(VecmathTest.equals(vector3f3.length(), 1.0));
        vector3f2.cross(vector3f3, vector3f2);
        VecmathTest.ASSERT(VecmathTest.equals(vector3f2, vector3f));
        vector3f2.set(1.0f, 2.0f, 3.0f);
        vector3f3.set(-1.0f, -6.0f, -3.0f);
        double d = vector3f2.angle(vector3f3);
        VecmathTest.ASSERT(VecmathTest.equals((double)(vector3f2.length() * vector3f3.length()) * Math.cos(d), vector3f2.dot(vector3f3)));
        vector3f2.set(vector3f3);
        d = vector3f2.angle(vector3f3);
        VecmathTest.ASSERT(VecmathTest.equals(d, 0.0));
        VecmathTest.ASSERT(VecmathTest.equals((double)(vector3f2.length() * vector3f3.length()) * Math.cos(d), vector3f2.dot(vector3f3)));
    }

    public static void Matrix3dTest() {
        int n;
        Matrix3d matrix3d = new Matrix3d();
        Matrix3d matrix3d2 = new Matrix3d();
        matrix3d2.setIdentity();
        Matrix3d matrix3d3 = new Matrix3d();
        Matrix3d matrix3d4 = new Matrix3d();
        double[] dArray = new double[]{2.0, 1.0, 4.0, 1.0, -2.0, 3.0, -3.0, -1.0, 1.0};
        int n2 = 0;
        while (n2 < 3) {
            n = 0;
            while (n < 3) {
                matrix3d3.setElement(n2, n, n2 * 2 * n + 3);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 3) {
            int n3 = 0;
            while (n3 < 3) {
                VecmathTest.ASSERT(VecmathTest.equals(matrix3d3.getElement(n, n3), n * 2 * n3 + 3));
                ++n3;
            }
            ++n;
        }
        matrix3d3.set(dArray);
        matrix3d4 = new Matrix3d(matrix3d3);
        matrix3d4.mul(matrix3d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4, matrix3d));
        matrix3d4.mul(matrix3d3, matrix3d2);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4, matrix3d3));
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3.determinant(), -36.0));
        matrix3d4.negate(matrix3d3);
        matrix3d4.add(matrix3d3);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4, matrix3d));
        matrix3d4.negate(matrix3d3);
        Matrix3d matrix3d5 = new Matrix3d(matrix3d3);
        matrix3d5.sub(matrix3d4);
        matrix3d5.mul(0.5);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3, matrix3d5));
        matrix3d5.invert(matrix3d4);
        matrix3d5.mul(matrix3d4);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d5, matrix3d2));
        Point3d point3d = new Point3d(1.0, 2.0, 3.0);
        Vector3d vector3d = new Vector3d(2.0, -1.0, -4.0);
        point3d.set(1.0, 0.0, 0.0);
        matrix3d3.rotZ(0.5235987755982988);
        matrix3d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(0.5235987755982988), Math.sin(0.5235987755982988), 0.0)));
        point3d.set(1.0, 0.0, 0.0);
        matrix3d3.rotY(1.0471975511965976);
        matrix3d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(1.0471975511965976), 0.0, -Math.sin(1.0471975511965976))));
        AxisAngle4d axisAngle4d = new AxisAngle4d(0.0, 1.0, 0.0, 1.0471975511965976);
        point3d.set(1.0, 0.0, 0.0);
        matrix3d3.set(axisAngle4d);
        matrix3d3.transform(point3d, point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(1.0471975511965976), 0.0, -Math.sin(1.0471975511965976))));
        Quat4d quat4d = new Quat4d();
        point3d.set(1.0, 0.0, 0.0);
        quat4d.set(axisAngle4d);
        matrix3d4.set(quat4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3, matrix3d4));
        matrix3d4.transform(point3d, point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(1.0471975511965976), 0.0, -Math.sin(1.0471975511965976))));
        axisAngle4d.set(1.0, 2.0, -3.0, 1.0471975511965976);
        VecmathTest.Mat3dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(1.0, 2.0, 3.0, Math.PI);
        VecmathTest.Mat3dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(1.0, 0.1, 0.1, Math.PI);
        VecmathTest.Mat3dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(0.1, 1.0, 0.1, Math.PI);
        VecmathTest.Mat3dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(0.1, 0.1, 1.0, Math.PI);
        VecmathTest.Mat3dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(1.0, 1.0, 1.0, 2.0943951023931953);
        matrix3d3.set(axisAngle4d);
        point3d.set(1.0, 0.0, 0.0);
        matrix3d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(0.0, 1.0, 0.0)));
        matrix3d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(0.0, 0.0, 1.0)));
        matrix3d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(1.0, 0.0, 0.0)));
        matrix3d3.set(axisAngle4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3.determinant(), 1.0));
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3.getScale(), 1.0));
        matrix3d4.set(axisAngle4d);
        matrix3d4.normalize();
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3, matrix3d4));
        matrix3d4.set(axisAngle4d);
        matrix3d4.normalizeCP();
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3, matrix3d4));
        double d = 3.0;
        matrix3d4.rotZ(-0.7853981633974483);
        matrix3d4.mul(d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.determinant(), d * d * d));
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.getScale(), d));
        matrix3d4.normalize();
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.determinant(), 1.0));
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.getScale(), 1.0));
        matrix3d4.rotX(1.0471975511965976);
        matrix3d4.mul(d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.determinant(), d * d * d));
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.getScale(), d));
        matrix3d4.normalizeCP();
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.determinant(), 1.0));
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d4.getScale(), 1.0));
        matrix3d3.set(axisAngle4d);
        matrix3d4.invert(matrix3d3);
        matrix3d3.transpose();
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d3, matrix3d4));
    }

    static void Mat3dQuatAxisAngle(AxisAngle4d axisAngle4d) {
        Matrix3d matrix3d = new Matrix3d();
        Matrix3d matrix3d2 = new Matrix3d();
        AxisAngle4d axisAngle4d2 = new AxisAngle4d();
        Quat4d quat4d = new Quat4d();
        Quat4d quat4d2 = new Quat4d();
        quat4d.set(axisAngle4d);
        axisAngle4d2.set(quat4d);
        VecmathTest.ASSERT(VecmathTest.equals(axisAngle4d, axisAngle4d2));
        quat4d2 = new Quat4d();
        quat4d2.set(axisAngle4d2);
        VecmathTest.ASSERT(VecmathTest.equals(quat4d, quat4d2));
        quat4d.set(axisAngle4d);
        matrix3d.set(quat4d);
        quat4d2.set(matrix3d);
        VecmathTest.ASSERT(VecmathTest.equals(quat4d, quat4d2));
        matrix3d2.set(quat4d2);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d, matrix3d2));
        matrix3d.set(axisAngle4d);
        axisAngle4d2.set(matrix3d);
        VecmathTest.ASSERT(VecmathTest.equals(axisAngle4d, axisAngle4d2));
        matrix3d2.set(axisAngle4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d, matrix3d2));
        axisAngle4d.x *= 2.0;
        axisAngle4d.y *= 2.0;
        axisAngle4d.z *= 2.0;
        matrix3d2.set(axisAngle4d);
        axisAngle4d.x = -axisAngle4d.x;
        axisAngle4d.y = -axisAngle4d.y;
        axisAngle4d.z = -axisAngle4d.z;
        axisAngle4d.angle = -axisAngle4d.angle;
        matrix3d2.set(axisAngle4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d, matrix3d2));
    }

    public static void Matrix3fTest() {
    }

    static void Mat4dQuatAxisAngle(AxisAngle4d axisAngle4d) {
        Matrix4d matrix4d = new Matrix4d();
        Matrix4d matrix4d2 = new Matrix4d();
        AxisAngle4d axisAngle4d2 = new AxisAngle4d();
        Quat4d quat4d = new Quat4d();
        Quat4d quat4d2 = new Quat4d();
        quat4d.set(axisAngle4d);
        axisAngle4d2.set(quat4d);
        VecmathTest.ASSERT(VecmathTest.equals(axisAngle4d, axisAngle4d2));
        quat4d2 = new Quat4d();
        quat4d2.set(axisAngle4d2);
        VecmathTest.ASSERT(VecmathTest.equals(quat4d, quat4d2));
        quat4d.set(axisAngle4d);
        matrix4d.set(quat4d);
        quat4d2.set(matrix4d);
        VecmathTest.ASSERT(VecmathTest.equals(quat4d, quat4d2));
        matrix4d2.set(quat4d2);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d, matrix4d2));
        matrix4d.set(axisAngle4d);
        axisAngle4d2.set(matrix4d);
        VecmathTest.ASSERT(VecmathTest.equals(axisAngle4d, axisAngle4d2));
        matrix4d2.set(axisAngle4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d, matrix4d2));
        axisAngle4d.x *= 2.0;
        axisAngle4d.y *= 2.0;
        axisAngle4d.z *= 2.0;
        matrix4d2.set(axisAngle4d);
        axisAngle4d.x = -axisAngle4d.x;
        axisAngle4d.y = -axisAngle4d.y;
        axisAngle4d.z = -axisAngle4d.z;
        axisAngle4d.angle = -axisAngle4d.angle;
        matrix4d2.set(axisAngle4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d, matrix4d2));
    }

    public static void Matrix4dTest() {
        int n;
        Matrix4d matrix4d = new Matrix4d();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        Matrix4d matrix4d3 = new Matrix4d();
        Matrix4d matrix4d4 = new Matrix4d();
        int n2 = 0;
        while (n2 < 4) {
            n = 0;
            while (n < 4) {
                matrix4d3.setElement(n2, n, n2 * 2 * n + 3);
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 4) {
            int n3 = 0;
            while (n3 < 4) {
                VecmathTest.ASSERT(VecmathTest.equals(matrix4d3.getElement(n, n3), n * 2 * n3 + 3));
                ++n3;
            }
            ++n;
        }
        matrix4d3 = new Matrix4d(2.0, 1.0, 4.0, 1.0, -2.0, 3.0, -3.0, 1.0, -1.0, 1.0, 2.0, 2.0, 0.0, 8.0, 1.0, -10.0);
        matrix4d4 = new Matrix4d(matrix4d3);
        matrix4d4.mul(matrix4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d4, matrix4d), "O = m2 x O");
        matrix4d4.mul(matrix4d3, matrix4d2);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d4, matrix4d3), "m2 = m1 x I");
        matrix4d4.negate(matrix4d3);
        matrix4d4.add(matrix4d3);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d4, matrix4d));
        double[] dArray = new double[]{5.0, 1.0, 4.0, 0.0, 2.0, 3.0, -4.0, -1.0, 2.0, 3.0, -4.0, -1.0, 1.0, 1.0, 1.0, 1.0};
        matrix4d4.set(dArray);
        matrix4d4.negate(matrix4d3);
        Matrix4d matrix4d5 = new Matrix4d(matrix4d3);
        matrix4d5.sub(matrix4d4);
        matrix4d5.mul(0.5);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3, matrix4d5));
        matrix4d4 = new Matrix4d(0.5, 1.0, 4.0, 1.0, -2.0, 3.0, -4.0, -1.0, 1.0, 9.0, 100.0, 2.0, -20.0, 2.0, 1.0, 9.0);
        matrix4d5.invert(matrix4d4);
        matrix4d5.mul(matrix4d4);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d5, matrix4d2));
        matrix4d3 = new Matrix4d(-1.0, 2.0, 0.0, 3.0, -1.0, 1.0, -3.0, -1.0, 1.0, 2.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0);
        Point3d point3d = new Point3d(1.0, 2.0, 3.0);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d(1.0, 2.0, 3.0);
        Vector4d vector4d = new Vector4d(2.0, -1.0, -4.0, 1.0);
        VecmathTest.ASSERT(matrix4d3.toString().equals("[" + NL + "  [-1.0\t2.0\t0.0\t3.0]" + NL + "  [-1.0\t1.0\t-3.0\t-1.0]" + NL + "  [1.0\t2.0\t1.0\t1.0]" + NL + "  [0.0\t0.0\t0.0\t1.0] ]"));
        matrix4d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(6.0, -9.0, 9.0)));
        matrix4d3.transform(vector4d, vector4d);
        VecmathTest.ASSERT(VecmathTest.equals(vector4d, new Vector4d(-1.0, 8.0, -3.0, 1.0)));
        point3d.set(1.0, 0.0, 0.0);
        matrix4d3.rotZ(0.5235987755982988);
        matrix4d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(0.5235987755982988), Math.sin(0.5235987755982988), 0.0)));
        point3d.set(1.0, 0.0, 0.0);
        matrix4d3.rotY(1.0471975511965976);
        matrix4d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(1.0471975511965976), 0.0, -Math.sin(1.0471975511965976))));
        AxisAngle4d axisAngle4d = new AxisAngle4d(0.0, 1.0, 0.0, 1.0471975511965976);
        point3d.set(1.0, 0.0, 0.0);
        matrix4d3.set(axisAngle4d);
        matrix4d3.transform(point3d, point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(1.0471975511965976), 0.0, -Math.sin(1.0471975511965976))));
        Quat4d quat4d = new Quat4d();
        point3d.set(1.0, 0.0, 0.0);
        quat4d.set(axisAngle4d);
        matrix4d4.set(quat4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3, matrix4d4));
        matrix4d4.transform(point3d, point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(Math.cos(1.0471975511965976), 0.0, -Math.sin(1.0471975511965976))));
        axisAngle4d.set(1.0, 2.0, -3.0, 1.0471975511965976);
        VecmathTest.Mat4dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(1.0, 2.0, 3.0, Math.PI);
        VecmathTest.Mat4dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(1.0, 0.1, 0.1, Math.PI);
        VecmathTest.Mat4dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(0.1, 1.0, 0.1, Math.PI);
        VecmathTest.Mat4dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(0.1, 0.1, 1.0, Math.PI);
        VecmathTest.Mat4dQuatAxisAngle(axisAngle4d);
        axisAngle4d.set(1.0, 1.0, 1.0, 2.0943951023931953);
        matrix4d3.set(axisAngle4d);
        point3d.set(1.0, 0.0, 0.0);
        matrix4d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(0.0, 1.0, 0.0)));
        matrix4d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(0.0, 0.0, 1.0)));
        matrix4d3.transform(point3d);
        VecmathTest.ASSERT(VecmathTest.equals(point3d, new Point3d(1.0, 0.0, 0.0)));
        matrix4d3.set(axisAngle4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3.determinant(), 1.0));
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3.getScale(), 1.0));
        matrix4d4.set(axisAngle4d);
        matrix4d3.set(axisAngle4d);
        matrix4d4.invert(matrix4d3);
        matrix4d3.transpose();
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3, matrix4d4));
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.set(axisAngle4d);
        Matrix3d matrix3d2 = new Matrix3d();
        vector3d2.set(2.0, -1.0, -1.0);
        matrix4d3.set(matrix3d, vector3d2, 0.4);
        matrix4d4.set(matrix3d, vector3d2, 0.4);
        Vector3d vector3d3 = new Vector3d();
        double d = matrix4d3.get(matrix3d2, vector3d3);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d, matrix3d2));
        VecmathTest.ASSERT(VecmathTest.equals(d, 0.4));
        VecmathTest.ASSERT(VecmathTest.equals(vector3d2, vector3d3));
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3, matrix4d4));
    }

    public static void Matrix4fTest() {
    }

    public static void GMatrixTest() {
        GMatrix gMatrix = new GMatrix(4, 4);
        GMatrix gMatrix2 = new GMatrix(4, 4);
        gMatrix2.setZero();
        GMatrix gMatrix3 = new GMatrix(3, 4);
        gMatrix3.setZero();
        GMatrix gMatrix4 = new GMatrix(3, 4);
        GMatrix gMatrix5 = new GMatrix(3, 4);
        Matrix3d matrix3d = new Matrix3d();
        Matrix3d matrix3d2 = new Matrix3d();
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 4) {
                gMatrix4.setElement(n, n2, (n + 1) * (n2 + 2));
                if (n2 < 3) {
                    matrix3d.setElement(n, n2, (n + 1) * (n2 + 2));
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < 3) {
            int n4 = 0;
            while (n4 < 4) {
                VecmathTest.ASSERT(VecmathTest.equals(gMatrix4.getElement(n3, n4), (n3 + 1) * (n4 + 2)));
                ++n4;
            }
            ++n3;
        }
        gMatrix4.get(matrix3d2);
        VecmathTest.ASSERT(VecmathTest.equals(matrix3d, matrix3d2));
        gMatrix5.mul(gMatrix4, gMatrix);
        VecmathTest.ASSERT(VecmathTest.equals(gMatrix4, gMatrix5));
        gMatrix5.mul(gMatrix4, gMatrix2);
        VecmathTest.ASSERT(VecmathTest.equals(gMatrix3, gMatrix5));
        Matrix4d matrix4d = new Matrix4d(1.0, 2.0, 3.0, 4.0, -2.0, 3.0, -1.0, 3.0, -1.0, -2.0, -4.0, 1.0, 1.0, 1.0, -1.0, -2.0);
        Matrix4d matrix4d2 = new Matrix4d();
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.set(matrix4d);
        gMatrix4.setSize(4, 4);
        gMatrix5.setSize(4, 4);
        gMatrix4.set(matrix4d);
        VecmathTest.ASSERT(gMatrix4.toString().equals("[" + NL + "  [1.0\t2.0\t3.0\t4.0]" + NL + "  [-2.0\t3.0\t-1.0\t3.0]" + NL + "  [-1.0\t-2.0\t-4.0\t1.0]" + NL + "  [1.0\t1.0\t-1.0\t-2.0] ]"));
        gMatrix5.set(gMatrix4);
        gMatrix4.invert();
        matrix4d.invert();
        matrix4d3.mul(matrix4d);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d3, new Matrix4d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0)));
        gMatrix4.get(matrix4d2);
        VecmathTest.ASSERT(VecmathTest.equals(matrix4d, matrix4d2));
        gMatrix4.mul(gMatrix5);
        VecmathTest.ASSERT(VecmathTest.equals(gMatrix4, gMatrix));
        Matrix4d matrix4d4 = new Matrix4d(1.0, 2.0, 3.0, 4.0, -2.0, 3.0, -1.0, 3.0, -1.0, -2.0, -4.0, 1.0, 1.0, 1.0, -1.0, -2.0);
        Vector4d vector4d = new Vector4d(1.0, -1.0, -1.0, 2.0);
        Vector4d vector4d2 = new Vector4d();
        Vector4d vector4d3 = new Vector4d(4.0, 2.0, 7.0, -3.0);
        matrix4d4.transform(vector4d, vector4d2);
        VecmathTest.ASSERT(VecmathTest.equals(vector4d2, vector4d3));
        gMatrix4.set(matrix4d4);
        GVector gVector = new GVector(4);
        GVector gVector2 = new GVector(4);
        GVector gVector3 = new GVector(4);
        gVector.set(vector4d);
        gVector3.set(vector4d3);
        GVector gVector4 = new GVector(4);
        gVector4.mul(gMatrix4, gVector);
        VecmathTest.ASSERT(VecmathTest.equals(gVector4, gVector3));
        GVector gVector5 = new GVector(4);
        gMatrix4.LUD(gMatrix5, gVector5);
        VecmathTest.ASSERT(VecmathTest.checkLUD(gMatrix4, gMatrix5, gVector5));
        GVector gVector6 = new GVector(4);
        gVector6.LUDBackSolve(gMatrix5, gVector3, gVector5);
        VecmathTest.ASSERT(VecmathTest.equals(gVector6, gVector));
        GMatrix gMatrix6 = new GMatrix(gMatrix4.getNumRow(), gMatrix4.getNumRow());
        GMatrix gMatrix7 = new GMatrix(gMatrix4.getNumRow(), gMatrix4.getNumCol());
        GMatrix gMatrix8 = new GMatrix(gMatrix4.getNumCol(), gMatrix4.getNumCol());
        int n5 = gMatrix4.SVD(gMatrix6, gMatrix7, gMatrix8);
        VecmathTest.ASSERT(n5 == 4);
        VecmathTest.ASSERT(VecmathTest.checkSVD(gMatrix4, gMatrix6, gMatrix7, gMatrix8));
        gVector6.SVDBackSolve(gMatrix6, gMatrix7, gMatrix8, gVector3);
        VecmathTest.ASSERT(VecmathTest.equals(gVector6, gVector));
    }

    static boolean checkLUD(GMatrix gMatrix, GMatrix gMatrix2, GVector gVector) {
        int n = gMatrix.getNumCol();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                double d = 0.0;
                int n4 = n2 < n3 ? n2 : n3;
                int n5 = 0;
                while (n5 <= n4) {
                    d = n2 != n5 ? (d += gMatrix2.getElement(n2, n5) * gMatrix2.getElement(n5, n3)) : (d += gMatrix2.getElement(n5, n3));
                    ++n5;
                }
                if (Math.abs(d - gMatrix.getElement((int)gVector.getElement(n2), n3)) > (double)epsilon) {
                    System.out.println("a[" + n2 + "," + n3 + "] = " + d + "(LU)ij ! = " + gMatrix.getElement((int)gVector.getElement(n2), n3));
                    bl = false;
                }
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    static boolean checkSVD(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3, GMatrix gMatrix4) {
        boolean bl = true;
        int n = gMatrix3.getNumRow() < gMatrix3.getNumRow() ? gMatrix3.getNumRow() : gMatrix3.getNumCol();
        int n2 = 0;
        while (n2 < gMatrix.getNumRow()) {
            int n3 = 0;
            while (n3 < gMatrix.getNumCol()) {
                double d = 0.0;
                int n4 = 0;
                while (n4 < gMatrix.getNumCol()) {
                    d += gMatrix2.getElement(n2, n4) * gMatrix3.getElement(n4, n4) * gMatrix4.getElement(n3, n4);
                    ++n4;
                }
                if ((double)epsilon < Math.abs(gMatrix.getElement(n2, n3) - d)) {
                    System.out.println("(SVD)ij = " + d + " != a[" + n2 + "," + n3 + "] = " + gMatrix.getElement(n2, n3));
                    bl = false;
                }
                ++n3;
            }
            ++n2;
        }
        if (!bl) {
            System.out.print("[W] = ");
            System.out.println(gMatrix3);
            System.out.print("[U] = ");
            System.out.println(gMatrix2);
            System.out.print("[V] = ");
            System.out.println(gMatrix4);
        }
        return bl;
    }

    public static void SVDTest() {
        double[] dArray = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0, 1.0};
        int n = 5;
        int n2 = 4;
        GMatrix gMatrix = new GMatrix(n, n2, dArray);
        GMatrix gMatrix2 = new GMatrix(n, n);
        GMatrix gMatrix3 = new GMatrix(n, n2);
        GMatrix gMatrix4 = new GMatrix(n2, n2);
        int n3 = gMatrix.SVD(gMatrix2, gMatrix3, gMatrix4);
        GMatrix gMatrix5 = new GMatrix(n, n2);
        gMatrix5.mul(gMatrix2, gMatrix3);
        gMatrix4.transpose();
        gMatrix5.mul(gMatrix4);
        if (!VecmathTest.equals(gMatrix5, gMatrix)) {
            System.out.println("matU=" + gMatrix2);
            System.out.println("matW=" + gMatrix3);
            System.out.println("matV=" + gMatrix4);
            System.out.println("matA=" + gMatrix);
            System.out.println("UWV=" + gMatrix5);
        }
        VecmathTest.ASSERT(VecmathTest.equals(gMatrix5, gMatrix));
    }
}

