<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="CommonDicomIODValidationRules.xsl"/>
<xsl:output method="text"/>
<xsl:template match="/DicomObject">
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.66.4'">
<xsl:text>Found Segmentation IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SegmentationSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SegmentationSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="count(//DerivationImageSequence) = 0 or count(FrameOfReferenceUID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedGeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedGeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: ImagePixelModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SegmentationImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SegmentationImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsCommonModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsForSegmentationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsForSegmentationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameDimensionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameDimensionModule"/>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="count(//DerivationImageSequence) &gt; 0 or count(ReferencedSeriesSequence) &gt; 0 or count(StudiesContainingOtherReferencedInstancesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CommonInstanceReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonInstanceReferenceModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:if test="count(FrameExtractionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameExtractionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameExtractionModule"/>
</xsl:if>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.66'">
<xsl:text>Found RawData IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
<xsl:if test="count(SynchronizationFrameOfReferenceUID) &gt; 0 or count(SynchronizationTrigger) &gt; 0              or count(TriggerSourceOrType) &gt; 0 or count(SynchronizationChannel) &gt; 0              or count(AcquisitionTimeSynchronized) &gt; 0 or count(TimeSource) &gt; 0              or count(TimeDistributionProtocol) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: AcquisitionContextModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextModule"/>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: RawDataModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RawDataModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.2.1'">
<xsl:text>Found EnhancedCTImage IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: CTSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTSeriesModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
<xsl:if test="count(SynchronizationFrameOfReferenceUID) &gt; 0 or count(SynchronizationTrigger) &gt; 0              or count(TriggerSourceOrType) &gt; 0 or count(SynchronizationChannel) &gt; 0              or count(AcquisitionTimeSynchronized) &gt; 0 or count(TimeSource) &gt; 0              or count(TimeDistributionProtocol) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedGeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedGeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: ImagePixelModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelModule"/>
<xsl:if test="count(ContrastBolusAgentSequence) &gt; 0 or count(//ContrastBolusUsageSequence) &gt; 0              or count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): EnhancedContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedContrastBolusModule"/>
</xsl:if>
<xsl:if test="count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ContrastBolusModuleNotWanted</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusModuleNotWanted"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsCommonModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsForEnhancedCTImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsForEnhancedCTImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameDimensionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameDimensionModule"/>
<xsl:if test="count(CardiacSynchronizationTechnique) &gt; 0 or count(CardiacSignalSource) &gt; 0              or count(CardiacRRIntervalSpecified) &gt; 0 or count(CardiacBeatRejectionTechnique) &gt; 0              or count(LowRRValue) &gt; 0 or count(HighRRValue) &gt; 0              or count(IntervalsAcquired) &gt; 0 or count(IntervalsRejected) &gt; 0              or count(//CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CardiacSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationModule"/>
</xsl:if>
<xsl:if test="count(RespiratoryMotionCompensationTechnique) &gt; 0 or count(RespiratorySignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): RespiratorySynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationModule"/>
</xsl:if>
<xsl:if test="PixelPresentation/value[@number=1]='COLOR' or PixelPresentation/value[@number=1]='MIXED'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SupplementalPaletteColorLookupTableModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SupplementalPaletteColorLookupTableModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: AcquisitionContextModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextModule"/>
<xsl:if test="count(DeviceSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): DeviceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DeviceModule"/>
</xsl:if>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedCTImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedCTImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:if test="count(ReferencedSeriesSequence) &gt; 0 or count(StudiesContainingOtherReferencedInstancesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CommonInstanceReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonInstanceReferenceModule"/>
</xsl:if>
<xsl:if test="count(FrameExtractionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameExtractionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameExtractionModule"/>
</xsl:if>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.2.2'">
<xsl:text>Found LegacyConvertedEnhancedCTImage IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: CTSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTSeriesModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
<xsl:if test="count(SynchronizationFrameOfReferenceUID) &gt; 0 or count(SynchronizationTrigger) &gt; 0              or count(TriggerSourceOrType) &gt; 0 or count(SynchronizationChannel) &gt; 0              or count(AcquisitionTimeSynchronized) &gt; 0 or count(TimeSource) &gt; 0              or count(TimeDistributionProtocol) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: ImagePixelModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelModule"/>
<xsl:if test="count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusModule"/>
</xsl:if>
<xsl:if test="count(ContrastBolusAgentSequence/ContrastBolusAgentNumber) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): EnhancedContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedContrastBolusModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsCommonModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule"/>
<xsl:if test="count(DimensionOrganizationSequence) &gt; 0 or count(DimensionIndexSequence) &gt; 0 or count(//DimensionIndexValues) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): MultiFrameDimensionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameDimensionModule"/>
</xsl:if>
<xsl:if test="count(CardiacSynchronizationTechnique) &gt; 0 or count(CardiacSignalSource) &gt; 0              or count(CardiacRRIntervalSpecified) &gt; 0 or count(CardiacBeatRejectionTechnique) &gt; 0              or count(LowRRValue) &gt; 0 or count(HighRRValue) &gt; 0              or count(IntervalsAcquired) &gt; 0 or count(IntervalsRejected) &gt; 0              or count(//CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CardiacSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationModule"/>
</xsl:if>
<xsl:if test="count(RespiratoryMotionCompensationTechnique) &gt; 0 or count(RespiratorySignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): RespiratorySynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: AcquisitionContextModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextModule"/>
<xsl:if test="count(DeviceSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): DeviceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DeviceModule"/>
</xsl:if>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedCTImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedCTImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:if test="count(ReferencedSeriesSequence) &gt; 0 or count(StudiesContainingOtherReferencedInstancesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CommonInstanceReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonInstanceReferenceModule"/>
</xsl:if>
<xsl:if test="count(FrameExtractionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameExtractionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameExtractionModule"/>
</xsl:if>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.4.1'">
<xsl:text>Found EnhancedMRImage IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MRSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSeriesModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
<xsl:if test="count(SynchronizationFrameOfReferenceUID) &gt; 0 or count(SynchronizationTrigger) &gt; 0              or count(TriggerSourceOrType) &gt; 0 or count(SynchronizationChannel) &gt; 0              or count(AcquisitionTimeSynchronized) &gt; 0 or count(TimeSource) &gt; 0              or count(TimeDistributionProtocol) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedGeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedGeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: ImagePixelModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelModule"/>
<xsl:if test="count(ContrastBolusAgentSequence) &gt; 0 or count(//ContrastBolusUsageSequence) &gt; 0              or count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): EnhancedContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedContrastBolusModule"/>
</xsl:if>
<xsl:if test="count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ContrastBolusModuleNotWanted</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusModuleNotWanted"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsCommonModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsForEnhancedMRImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsForEnhancedMRImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameDimensionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameDimensionModule"/>
<xsl:if test="count(CardiacSynchronizationTechnique) &gt; 0 or count(CardiacSignalSource) &gt; 0              or count(CardiacRRIntervalSpecified) &gt; 0 or count(CardiacBeatRejectionTechnique) &gt; 0              or count(LowRRValue) &gt; 0 or count(HighRRValue) &gt; 0              or count(IntervalsAcquired) &gt; 0 or count(IntervalsRejected) &gt; 0              or count(//CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CardiacSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationModule"/>
</xsl:if>
<xsl:if test="count(RespiratoryMotionCompensationTechnique) &gt; 0 or count(RespiratorySignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): RespiratorySynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationModule"/>
</xsl:if>
<xsl:if test="count(BulkMotionCompensationTechnique) &gt; 0 or count(BulkMotionSignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): BulkMotionSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="BulkMotionSynchronizationModule"/>
</xsl:if>
<xsl:if test="PixelPresentation/value[@number=1]='COLOR' or PixelPresentation/value[@number=1]='MIXED'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SupplementalPaletteColorLookupTableModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SupplementalPaletteColorLookupTableModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: AcquisitionContextModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextModule"/>
<xsl:if test="count(DeviceSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): DeviceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DeviceModule"/>
</xsl:if>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedMRImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedMRImageModule"/>
<xsl:if test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'              or count(PulseSequenceName) &gt; 0 or count(MRAcquisitionType) &gt; 0              or count(EchoPulseSequence) &gt; 0 or count(MultipleSpinEcho) &gt; 0              or count(MultiPlanarExcitation) &gt; 0 or count(PhaseContrast) &gt; 0              or count(TimeOfFlightContrast) &gt; 0 or count(SteadyStatePulseSequence) &gt; 0              or count(EchoPlanarPulseSequence) &gt; 0 or count(SaturationRecovery) &gt; 0              or count(SpectrallySelectedSuppression) &gt; 0 or count(OversamplingPhase) &gt; 0              or count(GeometryOfKSpaceTraversal) &gt; 0 or count(RectilinearPhaseEncodeReordering) &gt; 0              or count(SegmentedKSpaceTraversal) &gt; 0 or count(CoverageOfKSpace) &gt; 0              or count(NumberOfKSpaceTrajectories) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): MRPulseSequenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRPulseSequenceModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:if test="count(ReferencedSeriesSequence) &gt; 0 or count(StudiesContainingOtherReferencedInstancesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CommonInstanceReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonInstanceReferenceModule"/>
</xsl:if>
<xsl:if test="count(FrameExtractionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameExtractionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameExtractionModule"/>
</xsl:if>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:text>Found LegacyConvertedEnhancedMRImage IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MRSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSeriesModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
<xsl:if test="count(SynchronizationFrameOfReferenceUID) &gt; 0 or count(SynchronizationTrigger) &gt; 0              or count(TriggerSourceOrType) &gt; 0 or count(SynchronizationChannel) &gt; 0              or count(AcquisitionTimeSynchronized) &gt; 0 or count(TimeSource) &gt; 0              or count(TimeDistributionProtocol) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: ImagePixelModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelModule"/>
<xsl:if test="count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusModule"/>
</xsl:if>
<xsl:if test="count(ContrastBolusAgentSequence/ContrastBolusAgentNumber) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): EnhancedContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedContrastBolusModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsCommonModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule"/>
<xsl:if test="count(DimensionOrganizationSequence) &gt; 0 or count(DimensionIndexSequence) &gt; 0 or count(//DimensionIndexValues) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): MultiFrameDimensionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameDimensionModule"/>
</xsl:if>
<xsl:if test="count(CardiacSynchronizationTechnique) &gt; 0 or count(CardiacSignalSource) &gt; 0              or count(CardiacRRIntervalSpecified) &gt; 0 or count(CardiacBeatRejectionTechnique) &gt; 0              or count(LowRRValue) &gt; 0 or count(HighRRValue) &gt; 0              or count(IntervalsAcquired) &gt; 0 or count(IntervalsRejected) &gt; 0              or count(//CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CardiacSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationModule"/>
</xsl:if>
<xsl:if test="count(RespiratoryMotionCompensationTechnique) &gt; 0 or count(RespiratorySignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): RespiratorySynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationModule"/>
</xsl:if>
<xsl:if test="count(BulkMotionCompensationTechnique) &gt; 0 or count(BulkMotionSignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): BulkMotionSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="BulkMotionSynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: AcquisitionContextModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextModule"/>
<xsl:if test="count(DeviceSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): DeviceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DeviceModule"/>
</xsl:if>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedMRImageModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedMRImageModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:if test="count(ReferencedSeriesSequence) &gt; 0 or count(StudiesContainingOtherReferencedInstancesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CommonInstanceReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonInstanceReferenceModule"/>
</xsl:if>
<xsl:if test="count(FrameExtractionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameExtractionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameExtractionModule"/>
</xsl:if>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:when test="/DicomObject/SOPClassUID/value = '1.2.840.10008.5.1.4.1.1.4.2'">
<xsl:text>Found MRSpectroscopy IOD</xsl:text>
<xsl:value-of select="$newline"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FileMetaInformationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FileMetaInformationModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: PatientModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientModule"/>
<xsl:if test="count(ClinicalTrialSponsorName) &gt; 0 or count(ClinicalTrialProtocolID) &gt; 0              or count(ClinicalTrialProtocolName) &gt; 0 or count(ClinicalTrialSiteID) &gt; 0              or count(ClinicalTrialSiteName) &gt; 0 or count(ClinicalTrialSubjectID) &gt; 0              or count(ClinicalTrialSubjectReadingID) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSubjectModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSubjectModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralStudyModule"/>
<xsl:if test="count(AdmittingDiagnosesDescription) &gt; 0 or count(AdmittingDiagnosesCodeSequence) &gt; 0              or count(PatientAge) &gt; 0 or count(PatientSize) &gt; 0              or count(PatientWeight) &gt; 0 or count(PatientSizeCodeSequence) &gt; 0 or count(Occupation) &gt; 0              or count(AdditionalPatientHistory) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): PatientStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientStudyModule"/>
</xsl:if>
<xsl:if test="count(ClinicalTrialTimePointID) &gt; 0 or count(ClinicalTrialTimePointDescription) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialStudyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialStudyModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralSeriesModule"/>
<xsl:if test="count(ClinicalTrialCoordinatingCenterName) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ClinicalTrialSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ClinicalTrialSeriesModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MRSeriesModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSeriesModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: FrameOfReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameOfReferenceModule"/>
<xsl:if test="count(SynchronizationFrameOfReferenceUID) &gt; 0 or count(SynchronizationTrigger) &gt; 0              or count(TriggerSourceOrType) &gt; 0 or count(SynchronizationChannel) &gt; 0              or count(AcquisitionTimeSynchronized) &gt; 0 or count(TimeSource) &gt; 0              or count(TimeDistributionProtocol) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SynchronizationModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: GeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="GeneralEquipmentModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: EnhancedGeneralEquipmentModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedGeneralEquipmentModule"/>
<xsl:if test="count(ContrastBolusAgentSequence) &gt; 0 or count(//ContrastBolusUsageSequence) &gt; 0              or count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): EnhancedContrastBolusModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="EnhancedContrastBolusModule"/>
</xsl:if>
<xsl:if test="count(ContrastBolusAgent) &gt; 0 or count(ContrastBolusAgentSequence) &gt; 0              or count(ContrastBolusRoute) &gt; 0 or count(ContrastBolusAdministrationRouteSequence) &gt; 0              or count(ContrastBolusVolume) &gt; 0 or count(ContrastBolusStartTime) &gt; 0              or count(ContrastBolusStopTime) &gt; 0 or count(ContrastBolusTotalDose) &gt; 0              or count(ContrastBolusFlowRate) &gt; 0 or count(ContrastBolusDuration) &gt; 0              or count(ContrastBolusIngredient) &gt; 0 or count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): ContrastBolusModuleNotWanted</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusModuleNotWanted"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsCommonModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameFunctionalGroupsForMRImageSpectroscopyModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MultiFrameDimensionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MultiFrameDimensionModule"/>
<xsl:if test="count(CardiacSynchronizationTechnique) &gt; 0 or count(CardiacSignalSource) &gt; 0              or count(CardiacRRIntervalSpecified) &gt; 0 or count(CardiacBeatRejectionTechnique) &gt; 0              or count(LowRRValue) &gt; 0 or count(HighRRValue) &gt; 0              or count(IntervalsAcquired) &gt; 0 or count(IntervalsRejected) &gt; 0              or count(//CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CardiacSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationModule"/>
</xsl:if>
<xsl:if test="count(RespiratoryMotionCompensationTechnique) &gt; 0 or count(RespiratorySignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): RespiratorySynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationModule"/>
</xsl:if>
<xsl:if test="count(BulkMotionCompensationTechnique) &gt; 0 or count(BulkMotionSignalSource) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): BulkMotionSynchronizationModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="BulkMotionSynchronizationModule"/>
</xsl:if>
<xsl:if test="PixelPresentation/value[@number=1]='COLOR' or PixelPresentation/value[@number=1]='MIXED'">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SupplementalPaletteColorLookupTableModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SupplementalPaletteColorLookupTableModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: AcquisitionContextModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AcquisitionContextModule"/>
<xsl:if test="count(ContainerIdentifier) &gt; 0 or count(IssuerOfTheContainerIdentifierSequence) &gt; 0 or count(AlternateContainerIdentifierSequence) &gt; 0 or count(ContainerTypeCodeSequence) &gt; 0 or count(ContainerDescription) &gt; 0 or count(ContainerComponentSequence) &gt; 0 or count(SpecimenDescriptionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): SpecimenModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MRSpectroscopyModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyModule"/>
<xsl:if test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'              or count(PulseSequenceName) &gt; 0 or count(MRSpectroscopyAcquisitionType) &gt; 0              or count(EchoPulseSequence) &gt; 0 or count(MultipleSpinEcho) &gt; 0              or count(MultiPlanarExcitation) &gt; 0 or count(SteadyStatePulseSequence) &gt; 0              or count(EchoPlanarPulseSequence) &gt; 0 or count(SpectrallySelectedSuppression) &gt; 0              or count(GeometryOfKSpaceTraversal) &gt; 0 or count(RectilinearPhaseEncodeReordering) &gt; 0              or count(SegmentedKSpaceTraversal) &gt; 0 or count(CoverageOfKSpace) &gt; 0              or count(NumberOfKSpaceTrajectories) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): MRSpectroscopyPulseSequenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyPulseSequenceModule"/>
</xsl:if>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: MRSpectroscopyDataModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyDataModule"/>
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module: SOPCommonModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPCommonModule"/>
<xsl:if test="count(ReferencedSeriesSequence) &gt; 0 or count(StudiesContainingOtherReferencedInstancesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): CommonInstanceReferenceModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonInstanceReferenceModule"/>
</xsl:if>
<xsl:if test="count(FrameExtractionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Module (condition true): FrameExtractionModule</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameExtractionModule"/>
</xsl:if>
<xsl:text>IOD validation complete</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:when>
<xsl:otherwise>
<xsl:text>IOD (SOP Class) unrecognized</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:otherwise>
</xsl:choose>
</xsl:template>
<xsl:template name="FileMetaInformationModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/FileMetaInformationGroupLength/'"/>
<xsl:with-param name="element" select="FileMetaInformationGroupLength"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/FileMetaInformationGroupLength/'"/>
<xsl:with-param name="element" select="FileMetaInformationGroupLength"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/FileMetaInformationVersion/'"/>
<xsl:with-param name="element" select="FileMetaInformationVersion"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/FileMetaInformationVersion/'"/>
<xsl:with-param name="element" select="FileMetaInformationVersion"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/MediaStorageSOPInstanceUID/'"/>
<xsl:with-param name="element" select="MediaStorageSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/MediaStorageSOPInstanceUID/'"/>
<xsl:with-param name="element" select="MediaStorageSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/TransferSyntaxUID/'"/>
<xsl:with-param name="element" select="TransferSyntaxUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/TransferSyntaxUID/'"/>
<xsl:with-param name="element" select="TransferSyntaxUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/ImplementationClassUID/'"/>
<xsl:with-param name="element" select="ImplementationClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/ImplementationClassUID/'"/>
<xsl:with-param name="element" select="ImplementationClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/ImplementationVersionName/'"/>
<xsl:with-param name="element" select="ImplementationVersionName"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/ImplementationVersionName/'"/>
<xsl:with-param name="element" select="ImplementationVersionName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/SourceApplicationEntityTitle/'"/>
<xsl:with-param name="element" select="SourceApplicationEntityTitle"/>
<xsl:with-param name="vr" select="'AE'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/SourceApplicationEntityTitle/'"/>
<xsl:with-param name="element" select="SourceApplicationEntityTitle"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/PrivateInformationCreatorUID/'"/>
<xsl:with-param name="element" select="PrivateInformationCreatorUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'FileMetaInformationModule/PrivateInformationCreatorUID/'"/>
<xsl:with-param name="element" select="PrivateInformationCreatorUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FileMetaInformationModule/PrivateInformation/'"/>
<xsl:with-param name="element" select="PrivateInformation"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PrivateInformationCreatorUID) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'FileMetaInformationModule/PrivateInformation/'"/>
<xsl:with-param name="element" select="PrivateInformation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'FileMetaInformationModule/PrivateInformation/'"/>
<xsl:with-param name="element" select="PrivateInformation"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'FileMetaInformationModule/PrivateInformation/'"/>
<xsl:with-param name="element" select="PrivateInformation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="PatientModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientName/'"/>
<xsl:with-param name="element" select="PatientName"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientName/'"/>
<xsl:with-param name="element" select="PatientName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: IssuerOfPatientIDMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IssuerOfPatientIDMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientBirthDate/'"/>
<xsl:with-param name="element" select="PatientBirthDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientBirthDate/'"/>
<xsl:with-param name="element" select="PatientBirthDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientSex/'"/>
<xsl:with-param name="element" select="PatientSex"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientSex/'"/>
<xsl:with-param name="element" select="PatientSex"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(PatientSex/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PatientSex/value[@number=1] = 'M'">T</xsl:when>
<xsl:when test="PatientSex/value[@number=1] = 'F'">T</xsl:when>
<xsl:when test="PatientSex/value[@number=1] = 'O'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: PatientModule/PatientSex/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PatientSex"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PatientSex/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientModule/ReferencedPatientSequence/'"/>
<xsl:with-param name="element" select="ReferencedPatientSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPatientSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/ReferencedPatientSequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'PatientModule/ReferencedPatientSequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/ReferencedPatientSequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'PatientModule/ReferencedPatientSequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientBirthTime/'"/>
<xsl:with-param name="element" select="PatientBirthTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientBirthTime/'"/>
<xsl:with-param name="element" select="PatientBirthTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDs/'"/>
<xsl:with-param name="element" select="OtherPatientIDs"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDs/'"/>
<xsl:with-param name="element" select="OtherPatientIDs"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDsSequence/'"/>
<xsl:with-param name="element" select="OtherPatientIDsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="OtherPatientIDsSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDsSequence/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDsSequence/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: IssuerOfPatientIDMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IssuerOfPatientIDMacro"/>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDsSequence/TypeOfPatientID/'"/>
<xsl:with-param name="element" select="TypeOfPatientID"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'PatientModule/OtherPatientIDsSequence/TypeOfPatientID/'"/>
<xsl:with-param name="element" select="TypeOfPatientID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
				<xsl:if test="count(TypeOfPatientID/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="TypeOfPatientID/value[@number=1] = 'TEXT'">T</xsl:when>
<xsl:when test="TypeOfPatientID/value[@number=1] = 'RFID'">T</xsl:when>
<xsl:when test="TypeOfPatientID/value[@number=1] = 'BARCODE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: PatientModule/OtherPatientIDsSequence/TypeOfPatientID/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TypeOfPatientID"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="TypeOfPatientID/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/OtherPatientNames/'"/>
<xsl:with-param name="element" select="OtherPatientNames"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/OtherPatientNames/'"/>
<xsl:with-param name="element" select="OtherPatientNames"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/EthnicGroup/'"/>
<xsl:with-param name="element" select="EthnicGroup"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/EthnicGroup/'"/>
<xsl:with-param name="element" select="EthnicGroup"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientComments/'"/>
<xsl:with-param name="element" select="PatientComments"/>
<xsl:with-param name="vr" select="'LT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientComments/'"/>
<xsl:with-param name="element" select="PatientComments"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesDescription/'"/>
<xsl:with-param name="element" select="PatientSpeciesDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PatientSpeciesCodeSequence) = 0 and (count(PatientSpeciesDescription) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0 or count(StrainDescription) &gt; 0 or count(StrainNomenclature) &gt; 0 or count(StrainCodeSequence) &gt; 0 or count(StrainAdditionalInformation) &gt; 0 or count(StrainStockSequence) &gt; 0)">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesDescription/'"/>
<xsl:with-param name="element" select="PatientSpeciesDescription"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesDescription/'"/>
<xsl:with-param name="element" select="PatientSpeciesDescription"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesDescription/'"/>
<xsl:with-param name="element" select="PatientSpeciesDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:choose>
<xsl:when test="count(PatientSpeciesDescription) = 0 and (count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0 or count(StrainDescription) &gt; 0 or count(StrainNomenclature) &gt; 0 or count(StrainCodeSequence) &gt; 0 or count(StrainAdditionalInformation) &gt; 0 or count(StrainStockSequence) &gt; 0)">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesCodeSequence/'"/>
<xsl:with-param name="element" select="PatientSpeciesCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesCodeSequence/'"/>
<xsl:with-param name="element" select="PatientSpeciesCodeSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/PatientSpeciesCodeSequence/'"/>
<xsl:with-param name="element" select="PatientSpeciesCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PatientSpeciesCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientBreedDescription/'"/>
<xsl:with-param name="element" select="PatientBreedDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PatientBreedCodeSequence/Item) = 0 and (count(PatientSpeciesDescription) &gt; 0 or count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0 or count(StrainDescription) &gt; 0 or count(StrainNomenclature) &gt; 0 or count(StrainCodeSequence) &gt; 0 or count(StrainAdditionalInformation) &gt; 0 or count(StrainStockSequence) &gt; 0)">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientBreedDescription/'"/>
<xsl:with-param name="element" select="PatientBreedDescription"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientBreedDescription/'"/>
<xsl:with-param name="element" select="PatientBreedDescription"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/PatientBreedDescription/'"/>
<xsl:with-param name="element" select="PatientBreedDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:choose>
<xsl:when test="count(PatientSpeciesDescription) &gt; 0 or count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0 or count(StrainDescription) &gt; 0 or count(StrainNomenclature) &gt; 0 or count(StrainCodeSequence) &gt; 0 or count(StrainAdditionalInformation) &gt; 0 or count(StrainStockSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientBreedCodeSequence/'"/>
<xsl:with-param name="element" select="PatientBreedCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/PatientBreedCodeSequence/'"/>
<xsl:with-param name="element" select="PatientBreedCodeSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/PatientBreedCodeSequence/'"/>
<xsl:with-param name="element" select="PatientBreedCodeSequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PatientBreedCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:choose>
<xsl:when test="count(PatientSpeciesDescription) &gt; 0 or count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0 or count(StrainDescription) &gt; 0 or count(StrainNomenclature) &gt; 0 or count(StrainCodeSequence) &gt; 0 or count(StrainAdditionalInformation) &gt; 0 or count(StrainStockSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/BreedRegistrationSequence/'"/>
<xsl:with-param name="element" select="BreedRegistrationSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/BreedRegistrationSequence/'"/>
<xsl:with-param name="element" select="BreedRegistrationSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/BreedRegistrationSequence/'"/>
<xsl:with-param name="element" select="BreedRegistrationSequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="BreedRegistrationSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/BreedRegistrationSequence/BreedRegistrationNumber/'"/>
<xsl:with-param name="element" select="BreedRegistrationNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'PatientModule/BreedRegistrationSequence/BreedRegistrationNumber/'"/>
<xsl:with-param name="element" select="BreedRegistrationNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
			<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'PatientModule/BreedRegistrationSequence/BreedRegistryCodeSequence/'"/>
<xsl:with-param name="element" select="BreedRegistryCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="BreedRegistryCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/StrainDescription/'"/>
<xsl:with-param name="element" select="StrainDescription"/>
<xsl:with-param name="vr" select="'UC'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/StrainDescription/'"/>
<xsl:with-param name="element" select="StrainDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/StrainNomenclature/'"/>
<xsl:with-param name="element" select="StrainNomenclature"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/StrainNomenclature/'"/>
<xsl:with-param name="element" select="StrainNomenclature"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientModule/StrainCodeSequence/'"/>
<xsl:with-param name="element" select="StrainCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="StrainCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/StrainAdditionalInformation/'"/>
<xsl:with-param name="element" select="StrainAdditionalInformation"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/StrainAdditionalInformation/'"/>
<xsl:with-param name="element" select="StrainAdditionalInformation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientModule/StrainStockSequence/'"/>
<xsl:with-param name="element" select="StrainStockSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="StrainStockSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/StrainStockSequence/StrainStockNumber/'"/>
<xsl:with-param name="element" select="StrainStockNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/StrainStockSequence/StrainStockNumber/'"/>
<xsl:with-param name="element" select="StrainStockNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/StrainStockSequence/StrainSource/'"/>
<xsl:with-param name="element" select="StrainSource"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/StrainStockSequence/StrainSource/'"/>
<xsl:with-param name="element" select="StrainSource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientModule/StrainStockSequence/StrainSourceRegistryCodeSequence/'"/>
<xsl:with-param name="element" select="StrainSourceRegistryCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="StrainSourceRegistryCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePerson/'"/>
<xsl:with-param name="element" select="ResponsiblePerson"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PatientSpeciesDescription) &gt; 0 or count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePerson/'"/>
<xsl:with-param name="element" select="ResponsiblePerson"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePerson/'"/>
<xsl:with-param name="element" select="ResponsiblePerson"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePerson/'"/>
<xsl:with-param name="element" select="ResponsiblePerson"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePersonRole/'"/>
<xsl:with-param name="element" select="ResponsiblePersonRole"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ResponsiblePerson) &gt; 0 and string-length(ResponsiblePerson/value[@number=1]) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePersonRole/'"/>
<xsl:with-param name="element" select="ResponsiblePersonRole"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePersonRole/'"/>
<xsl:with-param name="element" select="ResponsiblePersonRole"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/ResponsiblePersonRole/'"/>
<xsl:with-param name="element" select="ResponsiblePersonRole"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ResponsiblePersonRole/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'OWNER'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'PARENT'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'CHILD'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'SPOUSE'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'SIBLING'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'RELATIVE'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'GUARDIAN'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'CUSTODIAN'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'AGENT'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'INVESTIGATOR'">T</xsl:when>
<xsl:when test="ResponsiblePersonRole/value[@number=1] = 'VETERINARIAN'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: PatientModule/ResponsiblePersonRole/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ResponsiblePersonRole"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ResponsiblePersonRole/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/ResponsibleOrganization/'"/>
<xsl:with-param name="element" select="ResponsibleOrganization"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PatientSpeciesDescription) &gt; 0 or count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/ResponsibleOrganization/'"/>
<xsl:with-param name="element" select="ResponsibleOrganization"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/ResponsibleOrganization/'"/>
<xsl:with-param name="element" select="ResponsibleOrganization"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/ResponsibleOrganization/'"/>
<xsl:with-param name="element" select="ResponsibleOrganization"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/PatientIdentityRemoved/'"/>
<xsl:with-param name="element" select="PatientIdentityRemoved"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientModule/PatientIdentityRemoved/'"/>
<xsl:with-param name="element" select="PatientIdentityRemoved"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(PatientIdentityRemoved/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PatientIdentityRemoved/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="PatientIdentityRemoved/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: PatientModule/PatientIdentityRemoved/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PatientIdentityRemoved"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="PatientIdentityRemoved/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethod/'"/>
<xsl:with-param name="element" select="DeidentificationMethod"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PatientIdentityRemoved/value[@number=1] = 'YES' and count(DeidentificationMethodCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethod/'"/>
<xsl:with-param name="element" select="DeidentificationMethod"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethod/'"/>
<xsl:with-param name="element" select="DeidentificationMethod"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethod/'"/>
<xsl:with-param name="element" select="DeidentificationMethod"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:choose>
<xsl:when test="PatientIdentityRemoved/value[@number=1] = 'YES' and count(DeidentificationMethod) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethodCodeSequence/'"/>
<xsl:with-param name="element" select="DeidentificationMethodCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethodCodeSequence/'"/>
<xsl:with-param name="element" select="DeidentificationMethodCodeSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'PatientModule/DeidentificationMethodCodeSequence/'"/>
<xsl:with-param name="element" select="DeidentificationMethodCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="DeidentificationMethodCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: PatientGroupMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PatientGroupMacro"/>
	</xsl:template>
<xsl:template name="ClinicalTrialSubjectModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSponsorName/'"/>
<xsl:with-param name="element" select="ClinicalTrialSponsorName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSponsorName/'"/>
<xsl:with-param name="element" select="ClinicalTrialSponsorName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialProtocolID/'"/>
<xsl:with-param name="element" select="ClinicalTrialProtocolID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialProtocolID/'"/>
<xsl:with-param name="element" select="ClinicalTrialProtocolID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialProtocolName/'"/>
<xsl:with-param name="element" select="ClinicalTrialProtocolName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialProtocolName/'"/>
<xsl:with-param name="element" select="ClinicalTrialProtocolName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSiteID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSiteID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSiteID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSiteID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSiteName/'"/>
<xsl:with-param name="element" select="ClinicalTrialSiteName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSiteName/'"/>
<xsl:with-param name="element" select="ClinicalTrialSiteName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ClinicalTrialSubjectReadingID) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectID"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectID"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectReadingID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectReadingID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ClinicalTrialSubjectID) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectReadingID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectReadingID"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectReadingID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectReadingID"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ClinicalTrialSubjectModule/ClinicalTrialSubjectReadingID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSubjectReadingID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="GeneralStudyModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyDate/'"/>
<xsl:with-param name="element" select="StudyDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyDate/'"/>
<xsl:with-param name="element" select="StudyDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyTime/'"/>
<xsl:with-param name="element" select="StudyTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyTime/'"/>
<xsl:with-param name="element" select="StudyTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferringPhysicianName/'"/>
<xsl:with-param name="element" select="ReferringPhysicianName"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferringPhysicianName/'"/>
<xsl:with-param name="element" select="ReferringPhysicianName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferringPhysicianIdentificationSequence/'"/>
<xsl:with-param name="element" select="ReferringPhysicianIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferringPhysicianIdentificationSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: PersonIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PersonIdentificationMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyID/'"/>
<xsl:with-param name="element" select="StudyID"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyID/'"/>
<xsl:with-param name="element" select="StudyID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/AccessionNumber/'"/>
<xsl:with-param name="element" select="AccessionNumber"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/AccessionNumber/'"/>
<xsl:with-param name="element" select="AccessionNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralStudyModule/IssuerOfAccessionNumberSequence/'"/>
<xsl:with-param name="element" select="IssuerOfAccessionNumberSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="IssuerOfAccessionNumberSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HL7v2HierarchicDesignatorMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HL7v2HierarchicDesignatorMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyDescription/'"/>
<xsl:with-param name="element" select="StudyDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/StudyDescription/'"/>
<xsl:with-param name="element" select="StudyDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/PhysiciansOfRecord/'"/>
<xsl:with-param name="element" select="PhysiciansOfRecord"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/PhysiciansOfRecord/'"/>
<xsl:with-param name="element" select="PhysiciansOfRecord"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralStudyModule/PhysiciansOfRecordIdentificationSequence/'"/>
<xsl:with-param name="element" select="PhysiciansOfRecordIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PhysiciansOfRecordIdentificationSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: PersonIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PersonIdentificationMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/NameOfPhysiciansReadingStudy/'"/>
<xsl:with-param name="element" select="NameOfPhysiciansReadingStudy"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/NameOfPhysiciansReadingStudy/'"/>
<xsl:with-param name="element" select="NameOfPhysiciansReadingStudy"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralStudyModule/PhysiciansReadingStudyIdentificationSequence/'"/>
<xsl:with-param name="element" select="PhysiciansReadingStudyIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PhysiciansReadingStudyIdentificationSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: PersonIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PersonIdentificationMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferencedStudySequence/'"/>
<xsl:with-param name="element" select="ReferencedStudySequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedStudySequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferencedStudySequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferencedStudySequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferencedStudySequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'GeneralStudyModule/ReferencedStudySequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralStudyModule/ProcedureCodeSequence/'"/>
<xsl:with-param name="element" select="ProcedureCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ProcedureCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="PatientStudyModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/AdmittingDiagnosesDescription/'"/>
<xsl:with-param name="element" select="AdmittingDiagnosesDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/AdmittingDiagnosesDescription/'"/>
<xsl:with-param name="element" select="AdmittingDiagnosesDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientStudyModule/AdmittingDiagnosesCodeSequence/'"/>
<xsl:with-param name="element" select="AdmittingDiagnosesCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="AdmittingDiagnosesCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/PatientAge/'"/>
<xsl:with-param name="element" select="PatientAge"/>
<xsl:with-param name="vr" select="'AS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/PatientAge/'"/>
<xsl:with-param name="element" select="PatientAge"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSize/'"/>
<xsl:with-param name="element" select="PatientSize"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSize/'"/>
<xsl:with-param name="element" select="PatientSize"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/PatientWeight/'"/>
<xsl:with-param name="element" select="PatientWeight"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/PatientWeight/'"/>
<xsl:with-param name="element" select="PatientWeight"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSizeCodeSequence/'"/>
<xsl:with-param name="element" select="PatientSizeCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PatientSizeCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/Occupation/'"/>
<xsl:with-param name="element" select="Occupation"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/Occupation/'"/>
<xsl:with-param name="element" select="Occupation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/AdditionalPatientHistory/'"/>
<xsl:with-param name="element" select="AdditionalPatientHistory"/>
<xsl:with-param name="vr" select="'LT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/AdditionalPatientHistory/'"/>
<xsl:with-param name="element" select="AdditionalPatientHistory"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>

		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/AdmissionID/'"/>
<xsl:with-param name="element" select="AdmissionID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/AdmissionID/'"/>
<xsl:with-param name="element" select="AdmissionID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientStudyModule/IssuerOfAdmissionIDSequence/'"/>
<xsl:with-param name="element" select="IssuerOfAdmissionIDSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="IssuerOfAdmissionIDSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HL7v2HierarchicDesignatorMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HL7v2HierarchicDesignatorMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/ServiceEpisodeID/'"/>
<xsl:with-param name="element" select="ServiceEpisodeID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/ServiceEpisodeID/'"/>
<xsl:with-param name="element" select="ServiceEpisodeID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientStudyModule/IssuerOfServiceEpisodeIDSequence/'"/>
<xsl:with-param name="element" select="IssuerOfServiceEpisodeIDSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="IssuerOfServiceEpisodeIDSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HL7v2HierarchicDesignatorMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HL7v2HierarchicDesignatorMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/ServiceEpisodeDescription/'"/>
<xsl:with-param name="element" select="ServiceEpisodeDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientStudyModule/ServiceEpisodeDescription/'"/>
<xsl:with-param name="element" select="ServiceEpisodeDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSexNeutered/'"/>
<xsl:with-param name="element" select="PatientSexNeutered"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PatientSpeciesDescription) &gt; 0 or count(PatientSpeciesCodeSequence) &gt; 0 or count(PatientBreedDescription) &gt; 0 or count(PatientBreedCodeSequence) &gt; 0 or count(BreedRegistrationSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSexNeutered/'"/>
<xsl:with-param name="element" select="PatientSexNeutered"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSexNeutered/'"/>
<xsl:with-param name="element" select="PatientSexNeutered"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'PatientStudyModule/PatientSexNeutered/'"/>
<xsl:with-param name="element" select="PatientSexNeutered"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(PatientSexNeutered/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PatientSexNeutered/value[@number=1] = 'ALTERED'">T</xsl:when>
<xsl:when test="PatientSexNeutered/value[@number=1] = 'UNALTERED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: PatientStudyModule/PatientSexNeutered/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PatientSexNeutered"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="PatientSexNeutered/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="ClinicalTrialStudyModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialStudyModule/ClinicalTrialTimePointID/'"/>
<xsl:with-param name="element" select="ClinicalTrialTimePointID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'ClinicalTrialStudyModule/ClinicalTrialTimePointID/'"/>
<xsl:with-param name="element" select="ClinicalTrialTimePointID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialStudyModule/ClinicalTrialTimePointDescription/'"/>
<xsl:with-param name="element" select="ClinicalTrialTimePointDescription"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ClinicalTrialStudyModule/ClinicalTrialTimePointDescription/'"/>
<xsl:with-param name="element" select="ClinicalTrialTimePointDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="GeneralSeriesModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(Modality/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="Modality/value[@number=1] = 'CR'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'CT'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'MR'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'NM'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'US'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'OT'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'BI'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'CD'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'DD'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'DG'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'ES'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'LS'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'PT'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RG'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'ST'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'TG'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'XA'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RF'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RTIMAGE'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RTDOSE'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RTSTRUCT'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RTPLAN'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'RTRECORD'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'HC'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'DX'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'MG'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'IO'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'PX'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'GM'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'SM'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'XC'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'PR'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'AU'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'ECG'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'EPS'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'HD'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'SR'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'IVUS'">T</xsl:when>
<xsl:when test="Modality/value[@number=1] = 'SEG'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: GeneralSeriesModule/Modality/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Modality"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="Modality/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesInstanceUID/'"/>
<xsl:with-param name="element" select="SeriesInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesInstanceUID/'"/>
<xsl:with-param name="element" select="SeriesInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesNumber/'"/>
<xsl:with-param name="element" select="SeriesNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesNumber/'"/>
<xsl:with-param name="element" select="SeriesNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/Laterality/'"/>
<xsl:with-param name="element" select="Laterality"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ImageLaterality) = 0 and count(//FrameLaterality) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'GeneralSeriesModule/Laterality/'"/>
<xsl:with-param name="element" select="Laterality"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'GeneralSeriesModule/Laterality/'"/>
<xsl:with-param name="element" select="Laterality"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralSeriesModule/Laterality/'"/>
<xsl:with-param name="element" select="Laterality"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(Laterality/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="Laterality/value[@number=1] = 'R'">T</xsl:when>
<xsl:when test="Laterality/value[@number=1] = 'L'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralSeriesModule/Laterality/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Laterality"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="Laterality/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesDate/'"/>
<xsl:with-param name="element" select="SeriesDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesDate/'"/>
<xsl:with-param name="element" select="SeriesDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesTime/'"/>
<xsl:with-param name="element" select="SeriesTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesTime/'"/>
<xsl:with-param name="element" select="SeriesTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformingPhysicianName/'"/>
<xsl:with-param name="element" select="PerformingPhysicianName"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformingPhysicianName/'"/>
<xsl:with-param name="element" select="PerformingPhysicianName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformingPhysicianIdentificationSequence/'"/>
<xsl:with-param name="element" select="PerformingPhysicianIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerformingPhysicianIdentificationSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: PersonIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PersonIdentificationMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/ProtocolName/'"/>
<xsl:with-param name="element" select="ProtocolName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/ProtocolName/'"/>
<xsl:with-param name="element" select="ProtocolName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesDescription/'"/>
<xsl:with-param name="element" select="SeriesDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/SeriesDescription/'"/>
<xsl:with-param name="element" select="SeriesDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/OperatorsName/'"/>
<xsl:with-param name="element" select="OperatorsName"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/OperatorsName/'"/>
<xsl:with-param name="element" select="OperatorsName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/OperatorIdentificationSequence/'"/>
<xsl:with-param name="element" select="OperatorIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="OperatorIdentificationSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: PersonIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PersonIdentificationMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/ReferencedPerformedProcedureStepSequence/'"/>
<xsl:with-param name="element" select="ReferencedPerformedProcedureStepSequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPerformedProcedureStepSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/BodyPartExamined/'"/>
<xsl:with-param name="element" select="BodyPartExamined"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/BodyPartExamined/'"/>
<xsl:with-param name="element" select="BodyPartExamined"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(BodyPartExamined/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ABDOMENPELVIS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ADRENAL'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ANKLE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'AORTA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ARM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'AXILLA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'BACK'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'BLADDER'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'BRAIN'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'BREAST'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'BRONCHUS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'BUTTOCK'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CALCANEUS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CALF'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CAROTID'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CEREBELLUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CERVIX'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CHEEK'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CHEST'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CHESTABDOMEN'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CHESTABDPELVIS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CIRCLEOFWILLIS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CLAVICLE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'COCCYX'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'COLON'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CORNEA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CORONARYARTERY'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'CTSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'DUODENUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'EAR'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ELBOW'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ESOPHAGUS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'EXTREMITY'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'EYE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'EYELID'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'FACE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'FEMUR'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'FINGER'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'FOOT'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'GALLBLADDER'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'HAND'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'HEAD'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'HEADNECK'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'HEART'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'HIP'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'HUMERUS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'IAC'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ILEUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ILIUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'JAW'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'JAW'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'JEJUNUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'KIDNEY'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'KNEE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'LARYNX'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'LEG'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'LIVER'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'LSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'LSSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'LUNG'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'MAXILLA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'MEDIASTINUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'MOUTH'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'NECK'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'NECKCHEST'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'NECKCHESTABDOMEN'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'NECKCHESTABDPELV'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'NOSE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ORBIT'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'OVARY'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PANCREAS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PAROTID'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PATELLA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PELVIS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PENIS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PHARYNX'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'PROSTATE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'RECTUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'RIB'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SCALP'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SCAPULA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SCLERA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SCROTUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SHOULDER'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SKULL'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SPLEEN'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'STERNUM'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'STOMACH'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'SUBMANDIBULAR'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TESTIS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'THIGH'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'THUMB'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'THYMUS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'THYROID'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TLSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TMJ'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TOE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TONGUE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TRACHEA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'TSPINE'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'URETER'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'URETHRA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'UTERUS'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'VAGINA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'VULVA'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'WHOLEBODY'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'WRIST'">T</xsl:when>
<xsl:when test="BodyPartExamined/value[@number=1] = 'ZYGOMA'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: GeneralSeriesModule/BodyPartExamined/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BodyPartExamined"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="BodyPartExamined/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/PatientPosition/'"/>
<xsl:with-param name="element" select="PatientPosition"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PatientOrientationCodeSequence) = 0 and (Modality/value[@number=1]='CT' or Modality/value[@number=1]='MR')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'GeneralSeriesModule/PatientPosition/'"/>
<xsl:with-param name="element" select="PatientPosition"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'GeneralSeriesModule/PatientPosition/'"/>
<xsl:with-param name="element" select="PatientPosition"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralSeriesModule/PatientPosition/'"/>
<xsl:with-param name="element" select="PatientPosition"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(PatientPosition/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PatientPosition/value[@number=1] = 'HFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'HFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'HFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'HFDL'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFDL'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'LFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'LFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'RFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'RFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'AFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'AFDL'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'PFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'PFDL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: GeneralSeriesModule/PatientPosition/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PatientPosition"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="PatientPosition/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/SmallestPixelValueInSeries/'"/>
<xsl:with-param name="element" select="SmallestPixelValueInSeries"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/SmallestPixelValueInSeries/'"/>
<xsl:with-param name="element" select="SmallestPixelValueInSeries"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/LargestPixelValueInSeries/'"/>
<xsl:with-param name="element" select="LargestPixelValueInSeries"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/LargestPixelValueInSeries/'"/>
<xsl:with-param name="element" select="LargestPixelValueInSeries"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/RequestAttributesSequence/'"/>
<xsl:with-param name="element" select="RequestAttributesSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="RequestAttributesSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: RequestAttributesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RequestAttributesMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepID/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepID"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepID/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepStartDate/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepStartDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepStartDate/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepStartDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepStartTime/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepStartTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepStartTime/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepStartTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepDescription/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProcedureStepDescription/'"/>
<xsl:with-param name="element" select="PerformedProcedureStepDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/PerformedProtocolCodeSequence/'"/>
<xsl:with-param name="element" select="PerformedProtocolCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerformedProtocolCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralSeriesModule/CommentsOnThePerformedProcedureStep/'"/>
<xsl:with-param name="element" select="CommentsOnThePerformedProcedureStep"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralSeriesModule/CommentsOnThePerformedProcedureStep/'"/>
<xsl:with-param name="element" select="CommentsOnThePerformedProcedureStep"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="ClinicalTrialSeriesModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSeriesModule/ClinicalTrialCoordinatingCenterName/'"/>
<xsl:with-param name="element" select="ClinicalTrialCoordinatingCenterName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSeriesModule/ClinicalTrialCoordinatingCenterName/'"/>
<xsl:with-param name="element" select="ClinicalTrialCoordinatingCenterName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSeriesModule/ClinicalTrialSeriesID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSeriesID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSeriesModule/ClinicalTrialSeriesID/'"/>
<xsl:with-param name="element" select="ClinicalTrialSeriesID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ClinicalTrialSeriesModule/ClinicalTrialSeriesDescription/'"/>
<xsl:with-param name="element" select="ClinicalTrialSeriesDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ClinicalTrialSeriesModule/ClinicalTrialSeriesDescription/'"/>
<xsl:with-param name="element" select="ClinicalTrialSeriesDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="MRSeriesModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(Modality/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="Modality/value[@number=1] = 'MR'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSeriesModule/Modality/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Modality"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="Modality/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'MRSeriesModule/ReferencedPerformedProcedureStepSequence/'"/>
<xsl:with-param name="element" select="ReferencedPerformedProcedureStepSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPerformedProcedureStepSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="FrameOfReferenceModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameOfReferenceModule/FrameOfReferenceUID/'"/>
<xsl:with-param name="element" select="FrameOfReferenceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FrameOfReferenceModule/FrameOfReferenceUID/'"/>
<xsl:with-param name="element" select="FrameOfReferenceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameOfReferenceModule/PositionReferenceIndicator/'"/>
<xsl:with-param name="element" select="PositionReferenceIndicator"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'FrameOfReferenceModule/PositionReferenceIndicator/'"/>
<xsl:with-param name="element" select="PositionReferenceIndicator"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="SynchronizationModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/SynchronizationFrameOfReferenceUID/'"/>
<xsl:with-param name="element" select="SynchronizationFrameOfReferenceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SynchronizationModule/SynchronizationFrameOfReferenceUID/'"/>
<xsl:with-param name="element" select="SynchronizationFrameOfReferenceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/SynchronizationTrigger/'"/>
<xsl:with-param name="element" select="SynchronizationTrigger"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SynchronizationModule/SynchronizationTrigger/'"/>
<xsl:with-param name="element" select="SynchronizationTrigger"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SynchronizationTrigger/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SynchronizationTrigger/value[@number=1] = 'SOURCE'">T</xsl:when>
<xsl:when test="SynchronizationTrigger/value[@number=1] = 'EXTERNAL'">T</xsl:when>
<xsl:when test="SynchronizationTrigger/value[@number=1] = 'PASSTHRU'">T</xsl:when>
<xsl:when test="SynchronizationTrigger/value[@number=1] = 'NO TRIGGER'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SynchronizationModule/SynchronizationTrigger/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SynchronizationTrigger"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SynchronizationTrigger/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/TriggerSourceOrType/'"/>
<xsl:with-param name="element" select="TriggerSourceOrType"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SynchronizationModule/TriggerSourceOrType/'"/>
<xsl:with-param name="element" select="TriggerSourceOrType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/SynchronizationChannel/'"/>
<xsl:with-param name="element" select="SynchronizationChannel"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SynchronizationModule/SynchronizationChannel/'"/>
<xsl:with-param name="element" select="SynchronizationChannel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/AcquisitionTimeSynchronized/'"/>
<xsl:with-param name="element" select="AcquisitionTimeSynchronized"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SynchronizationModule/AcquisitionTimeSynchronized/'"/>
<xsl:with-param name="element" select="AcquisitionTimeSynchronized"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionTimeSynchronized/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="AcquisitionTimeSynchronized/value[@number=1] = 'Y'">T</xsl:when>
<xsl:when test="AcquisitionTimeSynchronized/value[@number=1] = 'N'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SynchronizationModule/AcquisitionTimeSynchronized/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionTimeSynchronized"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="AcquisitionTimeSynchronized/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/TimeSource/'"/>
<xsl:with-param name="element" select="TimeSource"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SynchronizationModule/TimeSource/'"/>
<xsl:with-param name="element" select="TimeSource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SynchronizationModule/TimeDistributionProtocol/'"/>
<xsl:with-param name="element" select="TimeDistributionProtocol"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SynchronizationModule/TimeDistributionProtocol/'"/>
<xsl:with-param name="element" select="TimeDistributionProtocol"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(TimeDistributionProtocol/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="TimeDistributionProtocol/value[@number=1] = 'NTP'">T</xsl:when>
<xsl:when test="TimeDistributionProtocol/value[@number=1] = 'IRIG'">T</xsl:when>
<xsl:when test="TimeDistributionProtocol/value[@number=1] = 'GPS'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: SynchronizationModule/TimeDistributionProtocol/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TimeDistributionProtocol"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="TimeDistributionProtocol/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="GeneralEquipmentModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/InstitutionAddress/'"/>
<xsl:with-param name="element" select="InstitutionAddress"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/InstitutionAddress/'"/>
<xsl:with-param name="element" select="InstitutionAddress"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/StationName/'"/>
<xsl:with-param name="element" select="StationName"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/StationName/'"/>
<xsl:with-param name="element" select="StationName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/InstitutionalDepartmentName/'"/>
<xsl:with-param name="element" select="InstitutionalDepartmentName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/InstitutionalDepartmentName/'"/>
<xsl:with-param name="element" select="InstitutionalDepartmentName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/SoftwareVersions/'"/>
<xsl:with-param name="element" select="SoftwareVersions"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/SoftwareVersions/'"/>
<xsl:with-param name="element" select="SoftwareVersions"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/SpatialResolution/'"/>
<xsl:with-param name="element" select="SpatialResolution"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/SpatialResolution/'"/>
<xsl:with-param name="element" select="SpatialResolution"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralEquipmentModule/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralEquipmentModule/PixelPaddingValue/'"/>
<xsl:with-param name="element" select="PixelPaddingValue"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PixelPaddingRangeLimit) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'GeneralEquipmentModule/PixelPaddingValue/'"/>
<xsl:with-param name="element" select="PixelPaddingValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'GeneralEquipmentModule/PixelPaddingValue/'"/>
<xsl:with-param name="element" select="PixelPaddingValue"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralEquipmentModule/PixelPaddingValue/'"/>
<xsl:with-param name="element" select="PixelPaddingValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="EnhancedGeneralEquipmentModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/SoftwareVersions/'"/>
<xsl:with-param name="element" select="SoftwareVersions"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedGeneralEquipmentModule/SoftwareVersions/'"/>
<xsl:with-param name="element" select="SoftwareVersions"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="ImagePixelModule">
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ImagePixelMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelModule/PixelDataProviderURL/'"/>
<xsl:with-param name="element" select="PixelDataProviderURL"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="SOPClassUID/value[@number=1] = '1.2.840.10008.1.2.4.94' or SOPClassUID/value[@number=1] = '1.2.840.10008.1.2.4.95'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelModule/PixelDataProviderURL/'"/>
<xsl:with-param name="element" select="PixelDataProviderURL"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelModule/PixelDataProviderURL/'"/>
<xsl:with-param name="element" select="PixelDataProviderURL"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelModule/PixelDataProviderURL/'"/>
<xsl:with-param name="element" select="PixelDataProviderURL"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelModule/PixelPaddingRangeLimit/'"/>
<xsl:with-param name="element" select="PixelPaddingRangeLimit"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelModule/PixelPaddingRangeLimit/'"/>
<xsl:with-param name="element" select="PixelPaddingRangeLimit"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="ContrastBolusModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusAgent/'"/>
<xsl:with-param name="element" select="ContrastBolusAgent"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusAgent/'"/>
<xsl:with-param name="element" select="ContrastBolusAgent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusAgentSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusAgentSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusAgentSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusRoute/'"/>
<xsl:with-param name="element" select="ContrastBolusRoute"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusRoute/'"/>
<xsl:with-param name="element" select="ContrastBolusRoute"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusAdministrationRouteSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusAdministrationRouteSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusAdministrationRouteSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusAdministrationRouteSequence/AdditionalDrugSequence/'"/>
<xsl:with-param name="element" select="AdditionalDrugSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="AdditionalDrugSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusStartTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStartTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusStartTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStartTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusStopTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStopTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusStopTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStopTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusTotalDose/'"/>
<xsl:with-param name="element" select="ContrastBolusTotalDose"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusTotalDose/'"/>
<xsl:with-param name="element" select="ContrastBolusTotalDose"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastFlowRate/'"/>
<xsl:with-param name="element" select="ContrastFlowRate"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastFlowRate/'"/>
<xsl:with-param name="element" select="ContrastFlowRate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastFlowDuration/'"/>
<xsl:with-param name="element" select="ContrastFlowDuration"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastFlowDuration/'"/>
<xsl:with-param name="element" select="ContrastFlowDuration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusIngredient/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredient"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusIngredient/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredient"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusIngredientConcentration/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientConcentration"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModule/ContrastBolusIngredientConcentration/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientConcentration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="ContrastBolusModuleNotWanted">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusAgent/'"/>
<xsl:with-param name="element" select="ContrastBolusAgent"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusAgent/'"/>
<xsl:with-param name="element" select="ContrastBolusAgent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusAgent) &gt; 0">
<xsl:if test="count(ContrastBolusAgent) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusAgent/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusAgent"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusAgentSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusAgentSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusAgentSequence/Item">
			<xsl:if test="count(ContrastBolusAgentSequence) &gt; 0">
<xsl:if test="count(ContrastBolusAgentSequence) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusAgentSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusAgentSequence"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusRoute/'"/>
<xsl:with-param name="element" select="ContrastBolusRoute"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusRoute/'"/>
<xsl:with-param name="element" select="ContrastBolusRoute"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusRoute) &gt; 0">
<xsl:if test="count(ContrastBolusRoute) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusRoute/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusRoute"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusAdministrationRouteSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusAdministrationRouteSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusAdministrationRouteSequence/Item">
			<xsl:if test="count(ContrastBolusAdministrationRouteSequence) &gt; 0">
<xsl:if test="count(ContrastBolusAdministrationRouteSequence) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusAdministrationRouteSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusAdministrationRouteSequence"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusVolume) &gt; 0">
<xsl:if test="count(ContrastBolusVolume) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusVolume/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusVolume"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusStartTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStartTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusStartTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStartTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusStartTime) &gt; 0">
<xsl:if test="count(ContrastBolusStartTime) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusStartTime/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusStartTime"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusStopTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStopTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusStopTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStopTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusStopTime) &gt; 0">
<xsl:if test="count(ContrastBolusStopTime) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusStopTime/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusStopTime"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusTotalDose/'"/>
<xsl:with-param name="element" select="ContrastBolusTotalDose"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusTotalDose/'"/>
<xsl:with-param name="element" select="ContrastBolusTotalDose"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusTotalDose) &gt; 0">
<xsl:if test="count(ContrastBolusTotalDose) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusTotalDose/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusTotalDose"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastFlowRate/'"/>
<xsl:with-param name="element" select="ContrastFlowRate"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastFlowRate/'"/>
<xsl:with-param name="element" select="ContrastFlowRate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastFlowRate) &gt; 0">
<xsl:if test="count(ContrastFlowRate) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastFlowRate/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastFlowRate"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastFlowDuration/'"/>
<xsl:with-param name="element" select="ContrastFlowDuration"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastFlowDuration/'"/>
<xsl:with-param name="element" select="ContrastFlowDuration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastFlowDuration) &gt; 0">
<xsl:if test="count(ContrastFlowDuration) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastFlowDuration/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastFlowDuration"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusIngredient/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredient"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusIngredient/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredient"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusIngredient) &gt; 0">
<xsl:if test="count(ContrastBolusIngredient) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusIngredient/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusIngredient"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusIngredientConcentration/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientConcentration"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ContrastBolusModuleNotWanted/ContrastBolusIngredientConcentration/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientConcentration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:if test="count(ContrastBolusIngredientConcentration) &gt; 0">
<xsl:text>Error: ContrastBolusModuleNotWanted/ContrastBolusIngredientConcentration/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusIngredientConcentration"/>
</xsl:call-template>
<xsl:text>: should not be present; Enhanced Contrast Bolus Module required</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="EnhancedContrastBolusModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusAgentSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusAgentSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusAgentNumber/'"/>
<xsl:with-param name="element" select="ContrastBolusAgentNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusAgentNumber/'"/>
<xsl:with-param name="element" select="ContrastBolusAgentNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusAdministrationRouteSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusAdministrationRouteSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusAdministrationRouteSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckType2SequenceAttribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusIngredientCodeSequence/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientCodeSequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastBolusIngredientCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusIngredientConcentration/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientConcentration"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusIngredientConcentration/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientConcentration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusIngredientOpaque/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientOpaque"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusIngredientOpaque/'"/>
<xsl:with-param name="element" select="ContrastBolusIngredientOpaque"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:if test="count(ContrastBolusIngredientOpaque/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ContrastBolusIngredientOpaque/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="ContrastBolusIngredientOpaque/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastBolusIngredientOpaque/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContrastBolusIngredientOpaque"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ContrastBolusIngredientOpaque/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/'"/>
<xsl:with-param name="element" select="ContrastAdministrationProfileSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContrastAdministrationProfileSequence/Item">
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastBolusVolume/'"/>
<xsl:with-param name="element" select="ContrastBolusVolume"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastBolusStartTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStartTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastBolusStartTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStartTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastBolusStopTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStopTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastBolusStopTime/'"/>
<xsl:with-param name="element" select="ContrastBolusStopTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastFlowRate/'"/>
<xsl:with-param name="element" select="ContrastFlowRate"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastFlowRate/'"/>
<xsl:with-param name="element" select="ContrastFlowRate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastFlowDuration/'"/>
<xsl:with-param name="element" select="ContrastFlowDuration"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedContrastBolusModule/ContrastBolusAgentSequence/ContrastAdministrationProfileSequence/ContrastFlowDuration/'"/>
<xsl:with-param name="element" select="ContrastFlowDuration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsCommonModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ContentDate/'"/>
<xsl:with-param name="element" select="ContentDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ContentDate/'"/>
<xsl:with-param name="element" select="ContentDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ContentTime/'"/>
<xsl:with-param name="element" select="ContentTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ContentTime/'"/>
<xsl:with-param name="element" select="ContentTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/NumberOfFrames/'"/>
<xsl:with-param name="element" select="NumberOfFrames"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/NumberOfFrames/'"/>
<xsl:with-param name="element" select="NumberOfFrames"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
			<xsl:if test="count(NumberOfFrames) &gt; 0">
<xsl:if test="number(NumberOfFrames/value)=0">
<xsl:text>Error: MultiFrameFunctionalGroupsCommonModule/NumberOfFrames/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="NumberOfFrames"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/StereoPairsPresent/'"/>
<xsl:with-param name="element" select="StereoPairsPresent"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/StereoPairsPresent/'"/>
<xsl:with-param name="element" select="StereoPairsPresent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(StereoPairsPresent/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="StereoPairsPresent/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="StereoPairsPresent/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MultiFrameFunctionalGroupsCommonModule/StereoPairsPresent/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="StereoPairsPresent"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="StereoPairsPresent/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ConcatenationFrameOffsetNumber/'"/>
<xsl:with-param name="element" select="ConcatenationFrameOffsetNumber"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ConcatenationUID) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ConcatenationFrameOffsetNumber/'"/>
<xsl:with-param name="element" select="ConcatenationFrameOffsetNumber"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ConcatenationFrameOffsetNumber/'"/>
<xsl:with-param name="element" select="ConcatenationFrameOffsetNumber"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ConcatenationFrameOffsetNumber/'"/>
<xsl:with-param name="element" select="ConcatenationFrameOffsetNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/RepresentativeFrameNumber/'"/>
<xsl:with-param name="element" select="RepresentativeFrameNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/RepresentativeFrameNumber/'"/>
<xsl:with-param name="element" select="RepresentativeFrameNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ConcatenationUID/'"/>
<xsl:with-param name="element" select="ConcatenationUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/ConcatenationUID/'"/>
<xsl:with-param name="element" select="ConcatenationUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/SOPInstanceUIDOfConcatenationSource/'"/>
<xsl:with-param name="element" select="SOPInstanceUIDOfConcatenationSource"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ConcatenationUID) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/SOPInstanceUIDOfConcatenationSource/'"/>
<xsl:with-param name="element" select="SOPInstanceUIDOfConcatenationSource"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/SOPInstanceUIDOfConcatenationSource/'"/>
<xsl:with-param name="element" select="SOPInstanceUIDOfConcatenationSource"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/SOPInstanceUIDOfConcatenationSource/'"/>
<xsl:with-param name="element" select="SOPInstanceUIDOfConcatenationSource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationNumber/'"/>
<xsl:with-param name="element" select="InConcatenationNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ConcatenationUID) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationNumber/'"/>
<xsl:with-param name="element" select="InConcatenationNumber"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationNumber/'"/>
<xsl:with-param name="element" select="InConcatenationNumber"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationNumber/'"/>
<xsl:with-param name="element" select="InConcatenationNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationTotalNumber/'"/>
<xsl:with-param name="element" select="InConcatenationTotalNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ConcatenationUID) &gt; 0"/>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationTotalNumber/'"/>
<xsl:with-param name="element" select="InConcatenationTotalNumber"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsCommonModule/InConcatenationTotalNumber/'"/>
<xsl:with-param name="element" select="InConcatenationTotalNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsForSegmentationModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="SharedFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SharedFunctionalGroupsSequence/Item">
			<xsl:if test="count(//DerivationImageSequence) = 0 or count(PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(PixelMeasuresSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelMeasuresSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(//DerivationImageSequence) = 0 or count(PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlanePositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(//DerivationImageSequence) = 0 or count(PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlaneOrientationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(//PixelMeasuresSequence) = 0 or count(//PlanePositionSequence) = 0 or count(//PlaneOrientationSequence) = 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: DerivationImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameContentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameContentSequence cannot be in SharedFunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/SegmentIdentificationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/SegmentIdentificationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): SegmentationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SegmentationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/SegmentIdentificationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/SegmentIdentificationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: SegmentIdentificationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		</xsl:for-each>
		<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item) != /DicomObject/NumberOfFrames/value[@number=1]">
<xsl:text>Error: MultiFrameFunctionalGroupsForSegmentationModule/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiFrameFunctionalGroupsForSegmentationModule"/>
</xsl:call-template>
<xsl:text>: Number of PerFrameFunctionalGroupsSequence Items must equal NumberOfFrames</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForSegmentationModule/PerFrameFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="PerFrameFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerFrameFunctionalGroupsSequence/Item">
			<xsl:if test="count(//DerivationImageSequence) = 0 or count(PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(//DerivationImageSequence) = 0 or count(PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(//DerivationImageSequence) = 0 or count(PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(//PixelMeasuresSequence) = 0 or count(//PlanePositionSequence) = 0 or count(//PlaneOrientationSequence) = 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: FrameContentMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameContentMacro"/>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/SegmentIdentificationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/SegmentIdentificationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): SegmentationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SegmentationMacro"/>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsForEnhancedCTImageModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="SharedFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SharedFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(PixelMeasuresSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelMeasuresSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameContentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameContentSequence cannot be in SharedFunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlanePositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlaneOrientationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ReferencedImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: DerivationImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/CardiacSynchronizationTechnique) &gt; 0 and /DicomObject/CardiacSynchronizationTechnique/value[@number=1] != 'NONE') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CardiacSynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameAnatomySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameVOILUTSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RealWorldValueMappingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RealWorldValueMappingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RealWorldValueMappingSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RealWorldValueMappingSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RealWorldValueMappingSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusAgentSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusAgentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ContrastBolusAgentSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/RespiratoryMotionCompensationTechnique) &gt; 0 and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'NONE' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'REALTIME' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'BREATH_HOLD') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RespiratorySynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/IrradiationEventIdentificationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/IrradiationEventIdentificationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): IrradiationEventIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IrradiationEventIdentificationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/IrradiationEventIdentificationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/IrradiationEventIdentificationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: IrradiationEventIdentificationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTImageFrameTypeSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionTypeSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTAcquisitionTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTAcquisitionTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionTypeSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionTypeSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTAcquisitionTypeSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionDetailsSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionDetailsSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTAcquisitionDetailsMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTAcquisitionDetailsMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionDetailsSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionDetailsSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTAcquisitionDetailsSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTTableDynamicsSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTTableDynamicsSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTTableDynamicsMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTTableDynamicsMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTTableDynamicsSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTTableDynamicsSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTTableDynamicsSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTPositionSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTPositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTPositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTPositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTPositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTGeometrySequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTGeometrySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTGeometryMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTGeometryMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTGeometrySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTGeometrySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTGeometrySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionTypeSequence/Item[@number=1]/AcquisitionType/value[@number=1] != 'CONSTANT_ANGLE' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionTypeSequence/Item[@number=1]/AcquisitionType/value[@number=1] != 'CONSTANT_ANGLE') and ((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTReconstructionSequence) = 0)) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTReconstructionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTReconstructionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTReconstructionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTReconstructionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTReconstructionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTReconstructionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTExposureSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTExposureSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTExposureMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTExposureMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTExposureSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTExposureSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTExposureSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTXRayDetailsSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTXRayDetailsSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTXRayDetailsMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTXRayDetailsMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTXRayDetailsSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTXRayDetailsSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTXRayDetailsSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTPixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTPixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelValueTransformationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAdditionalXRaySourceSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTAdditionalXRaySourceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTAdditionalXRaySourceMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAdditionalXRaySourceSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAdditionalXRaySourceSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTAdditionalXRaySourceSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: TemporalPositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		</xsl:for-each>
		<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item) != /DicomObject/NumberOfFrames/value[@number=1]">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedCTImageModule/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiFrameFunctionalGroupsForEnhancedCTImageModule"/>
</xsl:call-template>
<xsl:text>: Number of PerFrameFunctionalGroupsSequence Items must equal NumberOfFrames</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForEnhancedCTImageModule/PerFrameFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="PerFrameFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerFrameFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: FrameContentMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameContentMacro"/>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/CardiacSynchronizationTechnique) &gt; 0 and /DicomObject/CardiacSynchronizationTechnique/value[@number=1] != 'NONE') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RealWorldValueMappingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RealWorldValueMappingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/RespiratoryMotionCompensationTechnique) &gt; 0 and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'NONE' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'REALTIME' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'BREATH_HOLD') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/IrradiationEventIdentificationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/IrradiationEventIdentificationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): IrradiationEventIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IrradiationEventIdentificationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionTypeSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTAcquisitionTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTAcquisitionTypeMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionDetailsSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionDetailsSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTAcquisitionDetailsMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTAcquisitionDetailsMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTTableDynamicsSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTTableDynamicsSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTTableDynamicsMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTTableDynamicsMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTPositionSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTPositionMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTGeometrySequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTGeometrySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTGeometryMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTGeometryMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTAcquisitionTypeSequence/Item[@number=1]/AcquisitionType/value[@number=1] != 'CONSTANT_ANGLE' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAcquisitionTypeSequence/Item[@number=1]/AcquisitionType/value[@number=1] != 'CONSTANT_ANGLE') and ((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[*]/CTReconstructionSequence) = 0)) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[@number=1]/CTReconstructionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTReconstructionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTReconstructionMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTExposureSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTExposureSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTExposureMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTExposureMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTXRayDetailsSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTXRayDetailsSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTXRayDetailsMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTXRayDetailsMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTPixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTPixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTAdditionalXRaySourceSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTAdditionalXRaySourceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTAdditionalXRaySourceMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="SharedFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SharedFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(PixelMeasuresSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelMeasuresSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameContentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameContentSequence cannot be in SharedFunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlanePositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlaneOrientationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ReferencedImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: DerivationImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CardiacSynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameAnatomySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameVOILUTSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusAgentSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusAgentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ContrastBolusAgentSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RespiratorySynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/IrradiationEventIdentificationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): IrradiationEventIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IrradiationEventIdentificationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/IrradiationEventIdentificationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/IrradiationEventIdentificationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: IrradiationEventIdentificationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTImageFrameTypeSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTPixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTPixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelValueTransformationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: TemporalPositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: UnassignedSharedConvertedAttributesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="UnassignedSharedConvertedAttributesMacro"/>
		</xsl:for-each>
		<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item) != /DicomObject/NumberOfFrames/value[@number=1]">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule"/>
</xsl:call-template>
<xsl:text>: Number of PerFrameFunctionalGroupsSequence Items must equal NumberOfFrames</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForLegacyConvertedEnhancedCTImageModule/PerFrameFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="PerFrameFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerFrameFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: FrameContentMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameContentMacro"/>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/IrradiationEventIdentificationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): IrradiationEventIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IrradiationEventIdentificationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CTPixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CTPixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: UnassignedPerFrameConvertedAttributesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="UnassignedPerFrameConvertedAttributesMacro"/>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ImageFrameConversionSourceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImageFrameConversionSourceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsForEnhancedMRImageModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="SharedFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SharedFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(PixelMeasuresSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelMeasuresSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameContentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameContentSequence cannot be in SharedFunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlanePositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlaneOrientationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ReferencedImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: DerivationImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/CardiacSynchronizationTechnique) &gt; 0 and /DicomObject/CardiacSynchronizationTechnique/value[@number=1] != 'NONE') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CardiacSynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameAnatomySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelValueTransformationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameVOILUTSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RealWorldValueMappingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RealWorldValueMappingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RealWorldValueMappingSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RealWorldValueMappingSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RealWorldValueMappingSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusAgentSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusAgentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ContrastBolusAgentSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/RespiratoryMotionCompensationTechnique) &gt; 0 and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'NONE' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'REALTIME' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'BREATH_HOLD') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RespiratorySynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRImageFrameTypeSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTimingAndRelatedParametersSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTimingAndRelatedParametersSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTimingAndRelatedParametersMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTimingAndRelatedParametersMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTimingAndRelatedParametersSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTimingAndRelatedParametersSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRTimingAndRelatedParametersSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/GeometryOfKSpaceTraversal) &gt; 0 and /DicomObject/GeometryOfKSpaceTraversal/value[@number=1] = 'RECTILINEAR') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRFOVGeometrySequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRFOVGeometrySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRFOVGeometryMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRFOVGeometryMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRFOVGeometrySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRFOVGeometrySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRFOVGeometrySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MREchoSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MREchoSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MREchoMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MREchoMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MREchoSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MREchoSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MREchoSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRModifierMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRModifierMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRModifierSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImagingModifierSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImagingModifierSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRImagingModifierMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImagingModifierMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImagingModifierSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImagingModifierSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRImagingModifierSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRReceiveCoilSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRReceiveCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRReceiveCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRReceiveCoilMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRReceiveCoilSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRReceiveCoilSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRReceiveCoilSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTransmitCoilSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTransmitCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTransmitCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTransmitCoilMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTransmitCoilSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTransmitCoilSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRTransmitCoilSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRDiffusionSequence) &gt; 0) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRDiffusionSequence) = 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRDiffusionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRDiffusionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRDiffusionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRDiffusionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRDiffusionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRAveragesSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRAveragesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRAveragesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRAveragesMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRAveragesSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRAveragesSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRAveragesSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpatialSaturationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpatialSaturationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpatialSaturationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpatialSaturationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpatialSaturationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpatialSaturationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRSpatialSaturationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(/DicomObject/ImageType/value[@number=3] = 'METABOLITE_MAP' and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRMetaboliteMapSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRMetaboliteMapSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRMetaboliteMapMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRMetaboliteMapMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRMetaboliteMapSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRMetaboliteMapSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRMetaboliteMapSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/PhaseContrast/value[@number=1] = 'YES' and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRVelocityEncodingSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRVelocityEncodingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRVelocityEncodingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRVelocityEncodingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRVelocityEncodingSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRVelocityEncodingSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRVelocityEncodingSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(/DicomObject/ImageType/value[@number=3] = 'ASL' and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRArterialSpinLabelingSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRArterialSpinLabelingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRArterialSpinLabelingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRArterialSpinLabelingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRArterialSpinLabelingSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRArterialSpinLabelingSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRArterialSpinLabelingSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: TemporalPositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		</xsl:for-each>
		<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item) != /DicomObject/NumberOfFrames/value[@number=1]">
<xsl:text>Error: MultiFrameFunctionalGroupsForEnhancedMRImageModule/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiFrameFunctionalGroupsForEnhancedMRImageModule"/>
</xsl:call-template>
<xsl:text>: Number of PerFrameFunctionalGroupsSequence Items must equal NumberOfFrames</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForEnhancedMRImageModule/PerFrameFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="PerFrameFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerFrameFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: FrameContentMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameContentMacro"/>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/CardiacSynchronizationTechnique) &gt; 0 and /DicomObject/CardiacSynchronizationTechnique/value[@number=1] != 'NONE') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RealWorldValueMappingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RealWorldValueMappingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/RespiratoryMotionCompensationTechnique) &gt; 0 and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'NONE' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'REALTIME' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'BREATH_HOLD') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTimingAndRelatedParametersSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTimingAndRelatedParametersSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTimingAndRelatedParametersMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTimingAndRelatedParametersMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/GeometryOfKSpaceTraversal) &gt; 0 and /DicomObject/GeometryOfKSpaceTraversal/value[@number=1] = 'RECTILINEAR') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRFOVGeometrySequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRFOVGeometrySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRFOVGeometryMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRFOVGeometryMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MREchoSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MREchoSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MREchoMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MREchoMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRModifierMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRModifierMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImagingModifierSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImagingModifierSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRImagingModifierMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImagingModifierMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRReceiveCoilSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRReceiveCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRReceiveCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRReceiveCoilMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTransmitCoilSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTransmitCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTransmitCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTransmitCoilMacro"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRDiffusionSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRDiffusionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRDiffusionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRDiffusionMacro"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpatialSaturationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpatialSaturationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpatialSaturationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpatialSaturationMacro"/>
</xsl:if>
			<xsl:if test="(/DicomObject/ImageType/value[@number=3] = 'METABOLITE_MAP' and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRMetaboliteMapSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRMetaboliteMapSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRMetaboliteMapMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRMetaboliteMapMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/PhaseContrast/value[@number=1] = 'YES' and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRVelocityEncodingSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRVelocityEncodingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRVelocityEncodingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRVelocityEncodingMacro"/>
</xsl:if>
			<xsl:if test="(/DicomObject/ImageType/value[@number=3] = 'ASL' and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRArterialSpinLabelingSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRArterialSpinLabelingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRArterialSpinLabelingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRArterialSpinLabelingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="SharedFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SharedFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(PixelMeasuresSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelMeasuresSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameContentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameContentSequence cannot be in SharedFunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlanePositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlaneOrientationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ReferencedImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: DerivationImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CardiacSynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameAnatomySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelValueTransformationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelValueTransformationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameVOILUTSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameVOILUTSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RealWorldValueMappingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RealWorldValueMappingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RealWorldValueMappingSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RealWorldValueMappingSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RealWorldValueMappingSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusAgentSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusAgentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ContrastBolusAgentSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RespiratorySynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CTImageFrameTypeSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CTImageFrameTypeSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CTImageFrameTypeSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/TemporalPositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: TemporalPositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: UnassignedSharedConvertedAttributesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="UnassignedSharedConvertedAttributesMacro"/>
		</xsl:for-each>
		<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item) != /DicomObject/NumberOfFrames/value[@number=1]">
<xsl:text>Error: MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule"/>
</xsl:call-template>
<xsl:text>: Number of PerFrameFunctionalGroupsSequence Items must equal NumberOfFrames</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForLegacyConvertedEnhancedMRImageModule/PerFrameFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="PerFrameFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerFrameFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: FrameContentMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameContentMacro"/>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelValueTransformationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelValueTransformationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelValueTransformationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameVOILUTSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameVOILUTMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameVOILUTMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RealWorldValueMappingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RealWorldValueMappingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRImageFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/TemporalPositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): TemporalPositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="TemporalPositionMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: UnassignedPerFrameConvertedAttributesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="UnassignedPerFrameConvertedAttributesMacro"/>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ImageFrameConversionSourceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImageFrameConversionSourceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameFunctionalGroupsForMRImageSpectroscopyModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="SharedFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SharedFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="count(PixelMeasuresSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PixelMeasuresSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameContentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameContentSequence cannot be in SharedFunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlanePositionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: PlaneOrientationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ReferencedImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ReferencedImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/DerivationImageSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: DerivationImageSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/CardiacSynchronizationTechnique) &gt; 0 and /DicomObject/CardiacSynchronizationTechnique/value[@number=1] != 'NONE') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: CardiacSynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: FrameAnatomySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusAgentSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusAgentSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: ContrastBolusAgentSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/RespiratoryMotionCompensationTechnique) &gt; 0 and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'NONE' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'REALTIME' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'BREATH_HOLD') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: RespiratorySynchronizationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpectroscopyFrameTypeSequence) = 0 or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpectroscopyFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpectroscopyFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpectroscopyFrameTypeSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpectroscopyFrameTypeSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRSpectroscopyFrameTypeSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTimingAndRelatedParametersSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTimingAndRelatedParametersSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTimingAndRelatedParametersMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTimingAndRelatedParametersMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTimingAndRelatedParametersSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTimingAndRelatedParametersSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRTimingAndRelatedParametersSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/GeometryOfKSpaceTraversal) &gt; 0 and /DicomObject/GeometryOfKSpaceTraversal/value[@number=1] = 'RECTILINEAR') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpectroscopyFOVGeometrySequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpectroscopyFOVGeometrySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpectroscopyFOVGeometryMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyFOVGeometryMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpectroscopyFOVGeometrySequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpectroscopyFOVGeometrySequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRSpectroscopyFOVGeometrySequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MREchoSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MREchoSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MREchoMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MREchoMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MREchoSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MREchoSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MREchoSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRModifierMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRModifierMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRModifierSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRReceiveCoilSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRReceiveCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRReceiveCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRReceiveCoilMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRReceiveCoilSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRReceiveCoilSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRReceiveCoilSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTransmitCoilSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTransmitCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTransmitCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTransmitCoilMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTransmitCoilSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTransmitCoilSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRTransmitCoilSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRDiffusionSequence) &gt; 0) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRDiffusionSequence) = 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRDiffusionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRDiffusionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRDiffusionSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRDiffusionSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRDiffusionSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRAveragesSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRAveragesSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRAveragesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRAveragesMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRAveragesSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRAveragesSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRAveragesSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpatialSaturationSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpatialSaturationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpatialSaturationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpatialSaturationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpatialSaturationSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpatialSaturationSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRSpatialSaturationSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
			<xsl:if test="((/DicomObject/PhaseContrast/value[@number=1] = 'YES' and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRVelocityEncodingSequence) = 0) or count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRVelocityEncodingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRVelocityEncodingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRVelocityEncodingMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRVelocityEncodingSequence) &gt; 0 and count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRVelocityEncodingSequence) &gt; 0">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/SharedFunctionalGroupsSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SharedFunctionalGroupsSequence"/>
</xsl:call-template>
<xsl:text>: MRVelocityEncodingSequence cannot be in both Shared and PerFrame FunctionalGroupsSequence</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		</xsl:for-each>
		
		<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item) != /DicomObject/NumberOfFrames/value[@number=1]">
<xsl:text>Error: MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiFrameFunctionalGroupsForMRImageSpectroscopyModule"/>
</xsl:call-template>
<xsl:text>: Number of PerFrameFunctionalGroupsSequence Items must equal NumberOfFrames</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameFunctionalGroupsForMRImageSpectroscopyModule/PerFrameFunctionalGroupsSequence/'"/>
<xsl:with-param name="element" select="PerFrameFunctionalGroupsSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PerFrameFunctionalGroupsSequence/Item">
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PixelMeasuresSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PixelMeasuresSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PixelMeasuresMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PixelMeasuresMacro"/>
</xsl:if>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: FrameContentMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameContentMacro"/>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlanePositionSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlanePositionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlanePositionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlanePositionMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/PlaneOrientationSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/PlaneOrientationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): PlaneOrientationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="PlaneOrientationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ReferencedImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ReferencedImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ReferencedImageMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/DerivationImageSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): DerivationImageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DerivationImageMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/CardiacSynchronizationTechnique) &gt; 0 and /DicomObject/CardiacSynchronizationTechnique/value[@number=1] != 'NONE') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/CardiacSynchronizationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/CardiacSynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): CardiacSynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CardiacSynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/FrameAnatomySequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/FrameAnatomySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): FrameAnatomyMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="FrameAnatomyMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/ContrastBolusAgentSequence) &gt; 0 and (count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/ContrastBolusUsageSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/ContrastBolusUsageSequence) &gt; 0)">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): ContrastBolusUsageMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContrastBolusUsageMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/RespiratoryMotionCompensationTechnique) &gt; 0 and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'NONE' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'REALTIME' and /DicomObject/RespiratoryMotionCompensationTechnique/value[@number=1] != 'BREATH_HOLD') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/RespiratorySynchronizationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/RespiratorySynchronizationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): RespiratorySynchronizationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RespiratorySynchronizationMacro"/>
</xsl:if>
			<xsl:if test="count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpectroscopyFrameTypeSequence) = 0 or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpectroscopyFrameTypeSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpectroscopyFrameTypeMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyFrameTypeMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTimingAndRelatedParametersSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTimingAndRelatedParametersSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTimingAndRelatedParametersMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTimingAndRelatedParametersMacro"/>
</xsl:if>
			<xsl:if test="(((count(/DicomObject/GeometryOfKSpaceTraversal) &gt; 0 and /DicomObject/GeometryOfKSpaceTraversal/value[@number=1] = 'RECTILINEAR') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpectroscopyFOVGeometrySequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpectroscopyFOVGeometrySequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpectroscopyFOVGeometryMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyFOVGeometryMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MREchoSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MREchoSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MREchoMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MREchoMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRModifierMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRModifierMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRReceiveCoilSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRReceiveCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRReceiveCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRReceiveCoilMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED') and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRTransmitCoilSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRTransmitCoilSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRTransmitCoilMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRTransmitCoilMacro"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence/Item[@number=1]/AcquisitionContrast/value[@number=1] = 'DIFFUSION') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRDiffusionSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRDiffusionSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRDiffusionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRDiffusionMacro"/>
</xsl:if>
			<xsl:if test="(((/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB' or /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRModifierSequence/Item[@number=1]/SpatialPresaturation/value[@number=1] = 'SLAB') and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRSpatialSaturationSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRSpatialSaturationSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRSpatialSaturationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpatialSaturationMacro"/>
</xsl:if>
			<xsl:if test="((/DicomObject/PhaseContrast/value[@number=1] = 'YES' and (/DicomObject/ImageType/value[@number=1] = 'ORIGINAL' or /DicomObject/ImageType/value[@number=1] = 'MIXED')) and count(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRVelocityEncodingSequence) = 0) or count(/DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRVelocityEncodingSequence) &gt; 0">
<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro (condition true): MRVelocityEncodingMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRVelocityEncodingMacro"/>
</xsl:if>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MultiFrameDimensionModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionOrganizationSequence/'"/>
<xsl:with-param name="element" select="DimensionOrganizationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="DimensionOrganizationSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionOrganizationSequence/DimensionOrganizationUID/'"/>
<xsl:with-param name="element" select="DimensionOrganizationUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionOrganizationSequence/DimensionOrganizationUID/'"/>
<xsl:with-param name="element" select="DimensionOrganizationUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionOrganizationType/'"/>
<xsl:with-param name="element" select="DimensionOrganizationType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionOrganizationType/'"/>
<xsl:with-param name="element" select="DimensionOrganizationType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(DimensionOrganizationType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="DimensionOrganizationType/value[@number=1] = '3D'">T</xsl:when>
<xsl:when test="DimensionOrganizationType/value[@number=1] = '3D_TEMPORAL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MultiFrameDimensionModule/DimensionOrganizationType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DimensionOrganizationType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="DimensionOrganizationType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/'"/>
<xsl:with-param name="element" select="DimensionIndexSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="DimensionIndexSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionIndexPointer/'"/>
<xsl:with-param name="element" select="DimensionIndexPointer"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionIndexPointer/'"/>
<xsl:with-param name="element" select="DimensionIndexPointer"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionIndexPrivateCreator/'"/>
<xsl:with-param name="element" select="DimensionIndexPrivateCreator"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionIndexPrivateCreator/'"/>
<xsl:with-param name="element" select="DimensionIndexPrivateCreator"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/FunctionalGroupPointer/'"/>
<xsl:with-param name="element" select="FunctionalGroupPointer"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="         DimensionIndexPointer/value[@number=1] != 'CTAcquisitionDetailsSequence'     and DimensionIndexPointer/value[@number=1] != 'CTAcquisitionTypeSequence'     and DimensionIndexPointer/value[@number=1] != 'CTExposureSequence'     and DimensionIndexPointer/value[@number=1] != 'CTGeometrySequence'     and DimensionIndexPointer/value[@number=1] != 'CTImageFrameTypeSequence'     and DimensionIndexPointer/value[@number=1] != 'CTPositionSequence'     and DimensionIndexPointer/value[@number=1] != 'CTReconstructionSequence'     and DimensionIndexPointer/value[@number=1] != 'CTTableDynamicsSequence'     and DimensionIndexPointer/value[@number=1] != 'CTXRayDetailsSequence'     and DimensionIndexPointer/value[@number=1] != 'CalibrationSequence'     and DimensionIndexPointer/value[@number=1] != 'CardiacSynchronizationSequence'     and DimensionIndexPointer/value[@number=1] != 'CollimatorShapeSequence'     and DimensionIndexPointer/value[@number=1] != 'ContrastBolusUsageSequence'     and DimensionIndexPointer/value[@number=1] != 'DerivationImageSequence'     and DimensionIndexPointer/value[@number=1] != 'ExposureControlSensingRegionsSequence'     and DimensionIndexPointer/value[@number=1] != 'FieldOfViewSequence'     and DimensionIndexPointer/value[@number=1] != 'FrameAcquisitionSequence'     and DimensionIndexPointer/value[@number=1] != 'FrameAnatomySequence'     and DimensionIndexPointer/value[@number=1] != 'FrameDetectorParametersSequence'     and DimensionIndexPointer/value[@number=1] != 'FrameDisplayShutterSequence'     and DimensionIndexPointer/value[@number=1] != 'FramePixelDataPropertiesSequence'     and DimensionIndexPointer/value[@number=1] != 'FramePixelShiftSequence'     and DimensionIndexPointer/value[@number=1] != 'FrameVOILUTSequence'     and DimensionIndexPointer/value[@number=1] != 'IrradiationEventIdentificationSequence'     and DimensionIndexPointer/value[@number=1] != 'IsocenterReferenceSystemSequence'     and DimensionIndexPointer/value[@number=1] != 'MRAveragesSequence'     and DimensionIndexPointer/value[@number=1] != 'MRDiffusionSequence'     and DimensionIndexPointer/value[@number=1] != 'MREchoSequence'     and DimensionIndexPointer/value[@number=1] != 'MRFOVGeometrySequence'     and DimensionIndexPointer/value[@number=1] != 'MRImageFrameTypeSequence'     and DimensionIndexPointer/value[@number=1] != 'MRImagingModifierSequence'     and DimensionIndexPointer/value[@number=1] != 'MRMetaboliteMapSequence'     and DimensionIndexPointer/value[@number=1] != 'MRModifierSequence'     and DimensionIndexPointer/value[@number=1] != 'MRReceiveCoilSequence'     and DimensionIndexPointer/value[@number=1] != 'MRSpatialSaturationSequence'     and DimensionIndexPointer/value[@number=1] != 'MRSpectroscopyFOVGeometrySequence'     and DimensionIndexPointer/value[@number=1] != 'MRSpectroscopyFrameTypeSequence'     and DimensionIndexPointer/value[@number=1] != 'MRTimingAndRelatedParametersSequence'     and DimensionIndexPointer/value[@number=1] != 'MRTransmitCoilSequence'     and DimensionIndexPointer/value[@number=1] != 'MRVelocityEncodingSequence'     and DimensionIndexPointer/value[@number=1] != 'ObjectThicknessSequence'     and DimensionIndexPointer/value[@number=1] != 'PatientOrientationInFrameSequence'     and DimensionIndexPointer/value[@number=1] != 'PixelIntensityRelationshipLUTSequence'     and DimensionIndexPointer/value[@number=1] != 'PixelMeasuresSequence'     and DimensionIndexPointer/value[@number=1] != 'PixelValueTransformationSequence'     and DimensionIndexPointer/value[@number=1] != 'PlaneOrientationSequence'     and DimensionIndexPointer/value[@number=1] != 'PlanePositionSequence'     and DimensionIndexPointer/value[@number=1] != 'PositionerPositionSequence'     and DimensionIndexPointer/value[@number=1] != 'ProjectionPixelCalibrationSequence'     and DimensionIndexPointer/value[@number=1] != 'RealWorldValueMappingSequence'     and DimensionIndexPointer/value[@number=1] != 'ReferencedImageSequence'     and DimensionIndexPointer/value[@number=1] != 'RespiratorySynchronizationSequence'     and DimensionIndexPointer/value[@number=1] != 'TablePositionSequence'     and DimensionIndexPointer/value[@number=1] != 'XRayGeometrySequence'     and DimensionIndexPointer/value[@number=1] != 'XAXRFFrameCharacteristicsSequence'     ">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/FunctionalGroupPointer/'"/>
<xsl:with-param name="element" select="FunctionalGroupPointer"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/FunctionalGroupPointer/'"/>
<xsl:with-param name="element" select="FunctionalGroupPointer"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/FunctionalGroupPointer/'"/>
<xsl:with-param name="element" select="FunctionalGroupPointer"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/FunctionalGroupPrivateCreator/'"/>
<xsl:with-param name="element" select="FunctionalGroupPrivateCreator"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/FunctionalGroupPrivateCreator/'"/>
<xsl:with-param name="element" select="FunctionalGroupPrivateCreator"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionOrganizationUID/'"/>
<xsl:with-param name="element" select="DimensionOrganizationUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionOrganizationUID/'"/>
<xsl:with-param name="element" select="DimensionOrganizationUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionDescriptionLabel/'"/>
<xsl:with-param name="element" select="DimensionDescriptionLabel"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MultiFrameDimensionModule/DimensionIndexSequence/DimensionDescriptionLabel/'"/>
<xsl:with-param name="element" select="DimensionDescriptionLabel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="CardiacSynchronizationModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSynchronizationTechnique/'"/>
<xsl:with-param name="element" select="CardiacSynchronizationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSynchronizationTechnique/'"/>
<xsl:with-param name="element" select="CardiacSynchronizationTechnique"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSynchronizationTechnique/'"/>
<xsl:with-param name="element" select="CardiacSynchronizationTechnique"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSynchronizationTechnique/'"/>
<xsl:with-param name="element" select="CardiacSynchronizationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(CardiacSynchronizationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CardiacSynchronizationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="CardiacSynchronizationTechnique/value[@number=1] = 'REALTIME'">T</xsl:when>
<xsl:when test="CardiacSynchronizationTechnique/value[@number=1] = 'PROSPECTIVE'">T</xsl:when>
<xsl:when test="CardiacSynchronizationTechnique/value[@number=1] = 'RETROSPECTIVE'">T</xsl:when>
<xsl:when test="CardiacSynchronizationTechnique/value[@number=1] = 'PACED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CardiacSynchronizationModule/CardiacSynchronizationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacSynchronizationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="CardiacSynchronizationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSignalSource/'"/>
<xsl:with-param name="element" select="CardiacSignalSource"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and CardiacSynchronizationTechnique/value[@number=1]!='NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSignalSource/'"/>
<xsl:with-param name="element" select="CardiacSignalSource"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSignalSource/'"/>
<xsl:with-param name="element" select="CardiacSignalSource"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacSignalSource/'"/>
<xsl:with-param name="element" select="CardiacSignalSource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(CardiacSignalSource) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: CardiacSynchronizationModule/CardiacSignalSource/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacSignalSource"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(CardiacSignalSource/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CardiacSignalSource/value[@number=1] = 'ECG'">T</xsl:when>
<xsl:when test="CardiacSignalSource/value[@number=1] = 'VCG'">T</xsl:when>
<xsl:when test="CardiacSignalSource/value[@number=1] = 'PP'">T</xsl:when>
<xsl:when test="CardiacSignalSource/value[@number=1] = 'MR'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: CardiacSynchronizationModule/CardiacSignalSource/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacSignalSource"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CardiacSignalSource/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacRRIntervalSpecified/'"/>
<xsl:with-param name="element" select="CardiacRRIntervalSpecified"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and CardiacSynchronizationTechnique/value[@number=1]!='NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacRRIntervalSpecified/'"/>
<xsl:with-param name="element" select="CardiacRRIntervalSpecified"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacRRIntervalSpecified/'"/>
<xsl:with-param name="element" select="CardiacRRIntervalSpecified"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacRRIntervalSpecified/'"/>
<xsl:with-param name="element" select="CardiacRRIntervalSpecified"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(CardiacRRIntervalSpecified) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: CardiacSynchronizationModule/CardiacRRIntervalSpecified/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacRRIntervalSpecified"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacBeatRejectionTechnique/'"/>
<xsl:with-param name="element" select="CardiacBeatRejectionTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and (CardiacSynchronizationTechnique/value[@number=1]='PROSPECTIVE' or CardiacSynchronizationTechnique/value[@number=1]='RETROSPECTIVE') and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacBeatRejectionTechnique/'"/>
<xsl:with-param name="element" select="CardiacBeatRejectionTechnique"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacBeatRejectionTechnique/'"/>
<xsl:with-param name="element" select="CardiacBeatRejectionTechnique"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacBeatRejectionTechnique/'"/>
<xsl:with-param name="element" select="CardiacBeatRejectionTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(CardiacBeatRejectionTechnique) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]!='PROSPECTIVE' and CardiacSynchronizationTechnique/value[@number=1]!='RETROSPECTIVE'">
<xsl:text>Error: CardiacSynchronizationModule/CardiacBeatRejectionTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacBeatRejectionTechnique"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is other than PROSPECTIVE or RETROSPECTIVE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(CardiacBeatRejectionTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CardiacBeatRejectionTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="CardiacBeatRejectionTechnique/value[@number=1] = 'RR_INTERVAL'">T</xsl:when>
<xsl:when test="CardiacBeatRejectionTechnique/value[@number=1] = 'QRS_LOOP'">T</xsl:when>
<xsl:when test="CardiacBeatRejectionTechnique/value[@number=1] = 'PVC'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: CardiacSynchronizationModule/CardiacBeatRejectionTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacBeatRejectionTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CardiacBeatRejectionTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/LowRRValue/'"/>
<xsl:with-param name="element" select="LowRRValue"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and (CardiacSynchronizationTechnique/value[@number=1]='PROSPECTIVE' or CardiacSynchronizationTechnique/value[@number=1]='RETROSPECTIVE') and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/LowRRValue/'"/>
<xsl:with-param name="element" select="LowRRValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/LowRRValue/'"/>
<xsl:with-param name="element" select="LowRRValue"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/LowRRValue/'"/>
<xsl:with-param name="element" select="LowRRValue"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(LowRRValue) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]!='PROSPECTIVE' and CardiacSynchronizationTechnique/value[@number=1]!='RETROSPECTIVE'">
<xsl:text>Error: CardiacSynchronizationModule/LowRRValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LowRRValue"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is other than PROSPECTIVE or RETROSPECTIVE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/HighRRValue/'"/>
<xsl:with-param name="element" select="HighRRValue"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and (CardiacSynchronizationTechnique/value[@number=1]='PROSPECTIVE' or CardiacSynchronizationTechnique/value[@number=1]='RETROSPECTIVE') and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/HighRRValue/'"/>
<xsl:with-param name="element" select="HighRRValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/HighRRValue/'"/>
<xsl:with-param name="element" select="HighRRValue"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/HighRRValue/'"/>
<xsl:with-param name="element" select="HighRRValue"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(HighRRValue) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]!='PROSPECTIVE' and CardiacSynchronizationTechnique/value[@number=1]!='RETROSPECTIVE'">
<xsl:text>Error: CardiacSynchronizationModule/HighRRValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighRRValue"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is other than PROSPECTIVE or RETROSPECTIVE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsAcquired/'"/>
<xsl:with-param name="element" select="IntervalsAcquired"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and CardiacSynchronizationTechnique/value[@number=1]!='NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsAcquired/'"/>
<xsl:with-param name="element" select="IntervalsAcquired"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsAcquired/'"/>
<xsl:with-param name="element" select="IntervalsAcquired"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsAcquired/'"/>
<xsl:with-param name="element" select="IntervalsAcquired"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(IntervalsAcquired) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: CardiacSynchronizationModule/IntervalsAcquired/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="IntervalsAcquired"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsRejected/'"/>
<xsl:with-param name="element" select="IntervalsRejected"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CardiacSynchronizationTechnique) &gt; 0 and CardiacSynchronizationTechnique/value[@number=1]!='NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsRejected/'"/>
<xsl:with-param name="element" select="IntervalsRejected"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsRejected/'"/>
<xsl:with-param name="element" select="IntervalsRejected"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/IntervalsRejected/'"/>
<xsl:with-param name="element" select="IntervalsRejected"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(IntervalsRejected) &gt; 0">
<xsl:if test="CardiacSynchronizationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: CardiacSynchronizationModule/IntervalsRejected/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="IntervalsRejected"/>
</xsl:call-template>
<xsl:text>: may not be present when CardiacSynchronizationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/SkipBeats/'"/>
<xsl:with-param name="element" select="SkipBeats"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/SkipBeats/'"/>
<xsl:with-param name="element" select="SkipBeats"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacFramingType/'"/>
<xsl:with-param name="element" select="CardiacFramingType"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CardiacSynchronizationModule/CardiacFramingType/'"/>
<xsl:with-param name="element" select="CardiacFramingType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
			<xsl:if test="count(CardiacFramingType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CardiacFramingType/value[@number=1] = 'FORW'">T</xsl:when>
<xsl:when test="CardiacFramingType/value[@number=1] = 'BACK'">T</xsl:when>
<xsl:when test="CardiacFramingType/value[@number=1] = 'PCNT'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: CardiacSynchronizationModule/CardiacFramingType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CardiacFramingType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CardiacFramingType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="RespiratorySynchronizationModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratoryMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="RespiratoryMotionCompensationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratoryMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="RespiratoryMotionCompensationTechnique"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratoryMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="RespiratoryMotionCompensationTechnique"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratoryMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="RespiratoryMotionCompensationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(RespiratoryMotionCompensationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'BREATH_HOLD'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'REALTIME'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'GATING'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'TRACKING'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'PHASE_ORDERING'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'PHASE_RESCANNING'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'RETROSPECTIVE'">T</xsl:when>
<xsl:when test="RespiratoryMotionCompensationTechnique/value[@number=1] = 'CORRECTION'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: RespiratorySynchronizationModule/RespiratoryMotionCompensationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RespiratoryMotionCompensationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="RespiratoryMotionCompensationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratorySignalSource/'"/>
<xsl:with-param name="element" select="RespiratorySignalSource"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(RespiratoryMotionCompensationTechnique) &gt; 0 and RespiratoryMotionCompensationTechnique/value[@number=1]!='NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratorySignalSource/'"/>
<xsl:with-param name="element" select="RespiratorySignalSource"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratorySignalSource/'"/>
<xsl:with-param name="element" select="RespiratorySignalSource"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratorySignalSource/'"/>
<xsl:with-param name="element" select="RespiratorySignalSource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(RespiratorySignalSource) &gt; 0">
<xsl:if test="RespiratoryMotionCompensationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: RespiratorySynchronizationModule/RespiratorySignalSource/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RespiratorySignalSource"/>
</xsl:call-template>
<xsl:text>: may not be present when RespiratoryMotionCompensationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RespiratorySignalSource/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'BELT'">T</xsl:when>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'NASAL_PROBE'">T</xsl:when>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'CO2_SENSOR'">T</xsl:when>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'NAVIGATOR'">T</xsl:when>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'MR_PHASE'">T</xsl:when>
<xsl:when test="RespiratorySignalSource/value[@number=1] = 'ECG'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: RespiratorySynchronizationModule/RespiratorySignalSource/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RespiratorySignalSource"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="RespiratorySignalSource/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratoryTriggerType/'"/>
<xsl:with-param name="element" select="RespiratoryTriggerType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'RespiratorySynchronizationModule/RespiratoryTriggerType/'"/>
<xsl:with-param name="element" select="RespiratoryTriggerType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(RespiratoryTriggerType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RespiratoryTriggerType/value[@number=1] = 'TIME'">T</xsl:when>
<xsl:when test="RespiratoryTriggerType/value[@number=1] = 'AMPLITUDE'">T</xsl:when>
<xsl:when test="RespiratoryTriggerType/value[@number=1] = 'BOTH'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: RespiratorySynchronizationModule/RespiratoryTriggerType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RespiratoryTriggerType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="RespiratoryTriggerType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="BulkMotionSynchronizationModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="BulkMotionCompensationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="BulkMotionCompensationTechnique"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="BulkMotionCompensationTechnique"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionCompensationTechnique/'"/>
<xsl:with-param name="element" select="BulkMotionCompensationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(BulkMotionCompensationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BulkMotionCompensationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="BulkMotionCompensationTechnique/value[@number=1] = 'REALTIME'">T</xsl:when>
<xsl:when test="BulkMotionCompensationTechnique/value[@number=1] = 'GATING'">T</xsl:when>
<xsl:when test="BulkMotionCompensationTechnique/value[@number=1] = 'TRACKING'">T</xsl:when>
<xsl:when test="BulkMotionCompensationTechnique/value[@number=1] = 'RETROSPECTIVE'">T</xsl:when>
<xsl:when test="BulkMotionCompensationTechnique/value[@number=1] = 'CORRECTION'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: BulkMotionSynchronizationModule/BulkMotionCompensationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BulkMotionCompensationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="BulkMotionCompensationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionSignalSource/'"/>
<xsl:with-param name="element" select="BulkMotionSignalSource"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(BulkMotionCompensationTechnique) &gt; 0 and BulkMotionCompensationTechnique/value[@number=1]!='NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionSignalSource/'"/>
<xsl:with-param name="element" select="BulkMotionSignalSource"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionSignalSource/'"/>
<xsl:with-param name="element" select="BulkMotionSignalSource"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'BulkMotionSynchronizationModule/BulkMotionSignalSource/'"/>
<xsl:with-param name="element" select="BulkMotionSignalSource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(BulkMotionSignalSource) &gt; 0">
<xsl:if test="BulkMotionCompensationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: BulkMotionSynchronizationModule/BulkMotionSignalSource/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BulkMotionSignalSource"/>
</xsl:call-template>
<xsl:text>: may not be present when BulkMotionCompensationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BulkMotionSignalSource/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BulkMotionSignalSource/value[@number=1] = 'JOINT'">T</xsl:when>
<xsl:when test="BulkMotionSignalSource/value[@number=1] = 'NAVIGATOR'">T</xsl:when>
<xsl:when test="BulkMotionSignalSource/value[@number=1] = 'MR_PHASE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: BulkMotionSynchronizationModule/BulkMotionSignalSource/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BulkMotionSignalSource"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="BulkMotionSignalSource/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="SupplementalPaletteColorLookupTableModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/RedPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/RedPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/GreenPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/GreenPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/BluePaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/BluePaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/RedPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableData"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/RedPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/GreenPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableData"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/GreenPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/BluePaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableData"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SupplementalPaletteColorLookupTableModule/BluePaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="AcquisitionContextModule">
		<xsl:call-template name="CheckType2SequenceAttribute">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/'"/>
<xsl:with-param name="element" select="AcquisitionContextSequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="AcquisitionContextSequence/Item">
			<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/ConceptNameCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptNameCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ConceptNameCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/ReferencedFrameNumbers/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumbers"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/ReferencedFrameNumbers/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumbers"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
				<xsl:if test="count(ReferencedFrameNumbers) &gt; 0">
<xsl:if test="count(DicomObject/NumberOfFrames) = 0 or DicomObject/NumberOfFrames/value[@number=1] = 0">
<xsl:text>Error: AcquisitionContextModule/AcquisitionContextSequence/ReferencedFrameNumbers/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ReferencedFrameNumbers"/>
</xsl:call-template>
<xsl:text>: May not be present unless this is a Multi-frame SOP Instance</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(Date) = 0 and count(Time) = 0 and count(PersonName) = 0 and count(TextValue) = 0 and count(ConceptCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
			<xsl:choose>
<xsl:when test="count(NumericValue) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/MeasurementUnitsCodeSequence/'"/>
<xsl:with-param name="element" select="MeasurementUnitsCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/MeasurementUnitsCodeSequence/'"/>
<xsl:with-param name="element" select="MeasurementUnitsCodeSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/MeasurementUnitsCodeSequence/'"/>
<xsl:with-param name="element" select="MeasurementUnitsCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="MeasurementUnitsCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Date/'"/>
<xsl:with-param name="element" select="Date"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(NumericValue) = 0 and count(Time) = 0 and count(PersonName) = 0 and count(TextValue) = 0 and count(ConceptCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Date/'"/>
<xsl:with-param name="element" select="Date"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Date/'"/>
<xsl:with-param name="element" select="Date"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Date/'"/>
<xsl:with-param name="element" select="Date"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Time/'"/>
<xsl:with-param name="element" select="Time"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(NumericValue) = 0 and count(Date) = 0 and count(PersonName) = 0 and count(TextValue) = 0 and count(ConceptCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Time/'"/>
<xsl:with-param name="element" select="Time"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Time/'"/>
<xsl:with-param name="element" select="Time"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/Time/'"/>
<xsl:with-param name="element" select="Time"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(NumericValue) = 0 and count(Date) = 0 and count(Time) = 0 and count(TextValue) = 0 and count(ConceptCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(NumericValue) = 0 and count(Date) = 0 and count(Time) = 0 and count(PersonName) = 0 and count(ConceptCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
			<xsl:choose>
<xsl:when test="count(NumericValue) = 0 and count(Date) = 0 and count(Time) = 0 and count(PersonName) = 0 and count(TextValue) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/ConceptCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/ConceptCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptCodeSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/ConceptCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ConceptCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/AcquisitionContextDescription/'"/>
<xsl:with-param name="element" select="AcquisitionContextDescription"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'AcquisitionContextModule/AcquisitionContextSequence/AcquisitionContextDescription/'"/>
<xsl:with-param name="element" select="AcquisitionContextDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="EnhancedMRImageModule">
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: MRImageAndMRSpectroscopyInstanceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageAndMRSpectroscopyInstanceMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vmmin" select="'4'"/>
<xsl:with-param name="vmmax" select="'4'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=1] = 'ORIGINAL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'DERIVED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=2] = 'PRIMARY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=3] = 'ANGIO'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDIAC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDIAC_GATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDRESP_GATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'DYNAMIC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'FLUOROSCOPY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'LOCALIZER'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'MOTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PERFUSION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PRE_CONTRAST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'POST_CONTRAST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'RESP_GATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'REST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'STATIC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'STRESS'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'VOLUME'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'NON_PARALLEL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PARALLEL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'WHOLE_BODY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'ANGIO_TIME'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'ASL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CINE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'DIFFUSION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'DIXON'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'FLOW_ENCODED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'FLUID_ATTENUATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'FMRI'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'MAX_IP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'MIN_IP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'M_MODE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'METABOLITE_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'MULTIECHO'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PROTON_DENSITY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'REALTIME'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'STIR'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'TAGGING'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'TEMPERATURE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'T1'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'T2'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'T2_STAR'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'TOF'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'VELOCITY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="3"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ImageType/value[@number=3]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=4] = 'ADDITION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIVISION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MASKED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MAXIMUM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MEAN'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MINIMUM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MTT'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MULTIPLICATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RCBF'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RCBV'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RESAMPLED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'STD_DEVIATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'SUBTRACTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'T_TEST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'TTP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'Z_SCORE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'NONE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'ADC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIFFUSION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIFFUSION_ANISO'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIFFUSION_ATTNTD'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIFFUSION_ISO'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'FAT'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'FAT_FRACTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'FIELD_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'IN_PHASE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'METABOLITE_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'NEI'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'OUT_OF_PHASE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'PERFUSION_ASL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'R_COEFFICIENT'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'R2_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'R2_STAR_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RHO'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'SCM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'SNR_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'T1_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'T2_STAR_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'T2_MAP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'TCS'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'TEMPERATURE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'VELOCITY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'WATER'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'WATER_FRACTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="4"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ImageType/value[@number=4]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='ORIGINAL' and ImageType/value[@number=4]!='NONE'">
<xsl:text>Error: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must be NONE when value 1 is ORIGINAL</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='DERIVED' and ImageType/value[@number=4]='NONE'">
<xsl:text>Error: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must not be NONE when value 1 is DERIVED</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='MIXED' and ImageType/value[@number=4]!='MIXED'">
<xsl:text>Error: EnhancedMRImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must be MIXED when value 1 is MIXED</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CommonCTMRImageDescriptionAtImageLevelMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonCTMRImageDescriptionAtImageLevelMacro"/>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: MRImageDescriptionAtImageLevelMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageDescriptionAtImageLevelMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(SamplesPerPixel/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SamplesPerPixel/value[@number=1] = '1'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SamplesPerPixel/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PhotometricInterpretation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'MONOCHROME2'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/PhotometricInterpretation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PhotometricInterpretation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PhotometricInterpretation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LargestMonochromePixelValue/'"/>
<xsl:with-param name="element" select="LargestMonochromePixelValue"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LargestMonochromePixelValue/'"/>
<xsl:with-param name="element" select="LargestMonochromePixelValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="count(LargestMonochromePixelValue) != 0">
<xsl:text>Warning: EnhancedMRImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue is retired and should not be used</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="LargestMonochromePixelValue/value + 1 != RedPaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: EnhancedMRImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue should be one less than RedPaletteColorLookupTableDescriptor value 2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="LargestMonochromePixelValue/value + 1 != GreenPaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: EnhancedMRImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue should be one less than GreenPaletteColorLookupTableDescriptor value 2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="LargestMonochromePixelValue/value + 1 != BluePaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: EnhancedMRImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue should be one less than BluePaletteColorLookupTableDescriptor value 2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsAllocated/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BitsAllocated/value[@number=1] = '8'">T</xsl:when>
<xsl:when test="BitsAllocated/value[@number=1] = '16'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BitsAllocated/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BitsAllocated) &gt; 0">
<xsl:if test="BitsStored/value = 8 and BitsAllocated/value != 8">
<xsl:text>Error: EnhancedMRImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>: Must be 8 when BitsStored is 8</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BitsAllocated) &gt; 0">
<xsl:if test="(BitsStored/value = 12 or BitsStored/value = 16) and BitsAllocated/value != 16">
<xsl:text>Error: EnhancedMRImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>: Must be 16 when BitsStored is 12 or 16</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsStored/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BitsStored/value[@number=1] = '8'">T</xsl:when>
<xsl:when test="BitsStored/value[@number=1] = '12'">T</xsl:when>
<xsl:when test="BitsStored/value[@number=1] = '16'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/BitsStored/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsStored"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BitsStored/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(HighBit/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="HighBit/value[@number=1] = '7'">T</xsl:when>
<xsl:when test="HighBit/value[@number=1] = '11'">T</xsl:when>
<xsl:when test="HighBit/value[@number=1] = '15'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="HighBit/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(HighBit) &gt; 0">
<xsl:if test="BitsStored/value != (HighBit/value + 1)">
<xsl:text>Error: EnhancedMRImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>: Must be one less than BitsStored</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/SpacingBetweenSlices/'"/>
<xsl:with-param name="element" select="SpacingBetweenSlices"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/SpacingBetweenSlices/'"/>
<xsl:with-param name="element" select="SpacingBetweenSlices"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedMRImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(BurnedInAnnotation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BurnedInAnnotation/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/BurnedInAnnotation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BurnedInAnnotation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BurnedInAnnotation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/RecognizableVisualFeatures/'"/>
<xsl:with-param name="element" select="RecognizableVisualFeatures"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/RecognizableVisualFeatures/'"/>
<xsl:with-param name="element" select="RecognizableVisualFeatures"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(RecognizableVisualFeatures/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RecognizableVisualFeatures/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="RecognizableVisualFeatures/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/RecognizableVisualFeatures/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RecognizableVisualFeatures"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="RecognizableVisualFeatures/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(LossyImageCompression/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="LossyImageCompression/value[@number=1] = '00'">T</xsl:when>
<xsl:when test="LossyImageCompression/value[@number=1] = '01'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/LossyImageCompression/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LossyImageCompression"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="LossyImageCompression/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="LossyImageCompression/value='01'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="LossyImageCompression/value='01'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedMRImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedMRImageModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedMRImageModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PresentationLUTShape/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PresentationLUTShape/value[@number=1] = 'IDENTITY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedMRImageModule/PresentationLUTShape/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PresentationLUTShape"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PresentationLUTShape/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: OptionalViewAndSliceProgressionDirectionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="OptionalViewAndSliceProgressionDirectionMacro"/>
	</xsl:template>
<xsl:template name="MRPulseSequenceModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MRAcquisitionType/'"/>
<xsl:with-param name="element" select="MRAcquisitionType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MRAcquisitionType/'"/>
<xsl:with-param name="element" select="MRAcquisitionType"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MRAcquisitionType/'"/>
<xsl:with-param name="element" select="MRAcquisitionType"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MRAcquisitionType/'"/>
<xsl:with-param name="element" select="MRAcquisitionType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(MRAcquisitionType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MRAcquisitionType/value[@number=1] = '1D'">T</xsl:when>
<xsl:when test="MRAcquisitionType/value[@number=1] = '2D'">T</xsl:when>
<xsl:when test="MRAcquisitionType/value[@number=1] = '3D'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRPulseSequenceModule/MRAcquisitionType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MRAcquisitionType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="MRAcquisitionType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(EchoPulseSequence/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="EchoPulseSequence/value[@number=1] = 'SPIN'">T</xsl:when>
<xsl:when test="EchoPulseSequence/value[@number=1] = 'GRADIENT'">T</xsl:when>
<xsl:when test="EchoPulseSequence/value[@number=1] = 'BOTH'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/EchoPulseSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="EchoPulseSequence"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="EchoPulseSequence/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')                    and (EchoPulseSequence/value[@number=1]='SPIN' or EchoPulseSequence/value[@number=1]='BOTH')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(MultipleSpinEcho) &gt; 0">
<xsl:if test="EchoPulseSequence/value[@number=1]!='SPIN' and EchoPulseSequence/value[@number=1]!='BOTH'">
<xsl:text>Error: MRPulseSequenceModule/MultipleSpinEcho/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultipleSpinEcho"/>
</xsl:call-template>
<xsl:text>: Can only be present when EchoPulseSequence is SPIN or BOTH</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(MultipleSpinEcho/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MultipleSpinEcho/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="MultipleSpinEcho/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/MultipleSpinEcho/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultipleSpinEcho"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="MultipleSpinEcho/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(MultiPlanarExcitation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MultiPlanarExcitation/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="MultiPlanarExcitation/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/MultiPlanarExcitation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiPlanarExcitation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="MultiPlanarExcitation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PhaseContrast/'"/>
<xsl:with-param name="element" select="PhaseContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PhaseContrast/'"/>
<xsl:with-param name="element" select="PhaseContrast"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PhaseContrast/'"/>
<xsl:with-param name="element" select="PhaseContrast"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/PhaseContrast/'"/>
<xsl:with-param name="element" select="PhaseContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PhaseContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PhaseContrast/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="PhaseContrast/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/PhaseContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PhaseContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PhaseContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:choose>
<xsl:when test="PhaseContrast/value[@number=1]='YES'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/VelocityEncodingAcquisitionSequence/'"/>
<xsl:with-param name="element" select="VelocityEncodingAcquisitionSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/VelocityEncodingAcquisitionSequence/'"/>
<xsl:with-param name="element" select="VelocityEncodingAcquisitionSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/VelocityEncodingAcquisitionSequence/'"/>
<xsl:with-param name="element" select="VelocityEncodingAcquisitionSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="VelocityEncodingAcquisitionSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/VelocityEncodingAcquisitionSequence/VelocityEncodingDirection/'"/>
<xsl:with-param name="element" select="VelocityEncodingDirection"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRPulseSequenceModule/VelocityEncodingAcquisitionSequence/VelocityEncodingDirection/'"/>
<xsl:with-param name="element" select="VelocityEncodingDirection"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/TimeOfFlightContrast/'"/>
<xsl:with-param name="element" select="TimeOfFlightContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/TimeOfFlightContrast/'"/>
<xsl:with-param name="element" select="TimeOfFlightContrast"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/TimeOfFlightContrast/'"/>
<xsl:with-param name="element" select="TimeOfFlightContrast"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/TimeOfFlightContrast/'"/>
<xsl:with-param name="element" select="TimeOfFlightContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(TimeOfFlightContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="TimeOfFlightContrast/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="TimeOfFlightContrast/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/TimeOfFlightContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TimeOfFlightContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="TimeOfFlightContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/ArterialSpinLabelingContrast/'"/>
<xsl:with-param name="element" select="ArterialSpinLabelingContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=3]='ASL'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/ArterialSpinLabelingContrast/'"/>
<xsl:with-param name="element" select="ArterialSpinLabelingContrast"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/ArterialSpinLabelingContrast/'"/>
<xsl:with-param name="element" select="ArterialSpinLabelingContrast"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/ArterialSpinLabelingContrast/'"/>
<xsl:with-param name="element" select="ArterialSpinLabelingContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ArterialSpinLabelingContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ArterialSpinLabelingContrast/value[@number=1] = 'CONTINUOUS '">T</xsl:when>
<xsl:when test="ArterialSpinLabelingContrast/value[@number=1] = 'PSEUDOCONTINUOUS '">T</xsl:when>
<xsl:when test="ArterialSpinLabelingContrast/value[@number=1] = 'PULSED '">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/ArterialSpinLabelingContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ArterialSpinLabelingContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ArterialSpinLabelingContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SteadyStatePulseSequence/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'FREE_PRECESSION'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'TRANSVERSE'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'TIME_REVERSED'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'LONGITUDINAL'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRPulseSequenceModule/SteadyStatePulseSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SteadyStatePulseSequence"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SteadyStatePulseSequence/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(EchoPlanarPulseSequence/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="EchoPlanarPulseSequence/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="EchoPlanarPulseSequence/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/EchoPlanarPulseSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="EchoPlanarPulseSequence"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="EchoPlanarPulseSequence/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SaturationRecovery/'"/>
<xsl:with-param name="element" select="SaturationRecovery"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SaturationRecovery/'"/>
<xsl:with-param name="element" select="SaturationRecovery"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SaturationRecovery/'"/>
<xsl:with-param name="element" select="SaturationRecovery"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SaturationRecovery/'"/>
<xsl:with-param name="element" select="SaturationRecovery"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SaturationRecovery/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SaturationRecovery/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="SaturationRecovery/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/SaturationRecovery/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SaturationRecovery"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SaturationRecovery/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SpectrallySelectedSuppression/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'FAT'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'WATER'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'FAT_AND_WATER'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'SILICON_GEL'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRPulseSequenceModule/SpectrallySelectedSuppression/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpectrallySelectedSuppression"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SpectrallySelectedSuppression/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/OversamplingPhase/'"/>
<xsl:with-param name="element" select="OversamplingPhase"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/OversamplingPhase/'"/>
<xsl:with-param name="element" select="OversamplingPhase"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/OversamplingPhase/'"/>
<xsl:with-param name="element" select="OversamplingPhase"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/OversamplingPhase/'"/>
<xsl:with-param name="element" select="OversamplingPhase"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(OversamplingPhase/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="OversamplingPhase/value[@number=1] = '2D'">T</xsl:when>
<xsl:when test="OversamplingPhase/value[@number=1] = '3D'">T</xsl:when>
<xsl:when test="OversamplingPhase/value[@number=1] = '2D_3D'">T</xsl:when>
<xsl:when test="OversamplingPhase/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/OversamplingPhase/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="OversamplingPhase"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="OversamplingPhase/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(GeometryOfKSpaceTraversal/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="GeometryOfKSpaceTraversal/value[@number=1] = 'RECTILINEAR'">T</xsl:when>
<xsl:when test="GeometryOfKSpaceTraversal/value[@number=1] = 'RADIAL'">T</xsl:when>
<xsl:when test="GeometryOfKSpaceTraversal/value[@number=1] = 'SPIRAL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRPulseSequenceModule/GeometryOfKSpaceTraversal/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="GeometryOfKSpaceTraversal"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="GeometryOfKSpaceTraversal/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')                    and  GeometryOfKSpaceTraversal/value[@number=1]='RECTILINEAR'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(RectilinearPhaseEncodeReordering) &gt; 0">
<xsl:if test="GeometryOfKSpaceTraversal/value[@number=1]!='RECTILINEAR'">
<xsl:text>Error: MRPulseSequenceModule/RectilinearPhaseEncodeReordering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RectilinearPhaseEncodeReordering"/>
</xsl:call-template>
<xsl:text>: Can only be present when GeometryOfKSpaceTraversal is RECTILINEAR</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RectilinearPhaseEncodeReordering/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'LINEAR'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'CENTRIC'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'SEGMENTED'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'REVERSE_LINEAR'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'REVERSE_CENTRIC'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRPulseSequenceModule/RectilinearPhaseEncodeReordering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RectilinearPhaseEncodeReordering"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="RectilinearPhaseEncodeReordering/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SegmentedKSpaceTraversal/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SegmentedKSpaceTraversal/value[@number=1] = 'SINGLE'">T</xsl:when>
<xsl:when test="SegmentedKSpaceTraversal/value[@number=1] = 'PARTIAL'">T</xsl:when>
<xsl:when test="SegmentedKSpaceTraversal/value[@number=1] = 'FULL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRPulseSequenceModule/SegmentedKSpaceTraversal/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SegmentedKSpaceTraversal"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SegmentedKSpaceTraversal/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')                     and  MRAcquisitionType/value[@number=1]='3D'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(CoverageOfKSpace) &gt; 0">
<xsl:if test="MRAcquisitionType/value[@number=1]!='3D'">
<xsl:text>Error: MRPulseSequenceModule/CoverageOfKSpace/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CoverageOfKSpace"/>
</xsl:call-template>
<xsl:text>: Can only be present when MRAcquisitionType is 3D</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(CoverageOfKSpace/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'FULL'">T</xsl:when>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'CYLINDRICAL'">T</xsl:when>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'ELLIPSOIDAL'">T</xsl:when>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'WEIGHTED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRPulseSequenceModule/CoverageOfKSpace/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CoverageOfKSpace"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CoverageOfKSpace/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="SoftcopyPresentationLUTModule">
		<xsl:choose>
<xsl:when test="count(PresentationLUTShape) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/'"/>
<xsl:with-param name="element" select="PresentationLUTSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/'"/>
<xsl:with-param name="element" select="PresentationLUTSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/'"/>
<xsl:with-param name="element" select="PresentationLUTSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PresentationLUTSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/LUTDescriptor/'"/>
<xsl:with-param name="element" select="LUTDescriptor"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/LUTDescriptor/'"/>
<xsl:with-param name="element" select="LUTDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/LUTExplanation/'"/>
<xsl:with-param name="element" select="LUTExplanation"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/LUTExplanation/'"/>
<xsl:with-param name="element" select="LUTExplanation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/LUTData/'"/>
<xsl:with-param name="element" select="LUTData"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTSequence/LUTData/'"/>
<xsl:with-param name="element" select="LUTData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(PresentationLUTSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SoftcopyPresentationLUTModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PresentationLUTShape/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PresentationLUTShape/value[@number=1] = 'IDENTITY'">T</xsl:when>
<xsl:when test="PresentationLUTShape/value[@number=1] = 'INVERSE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SoftcopyPresentationLUTModule/PresentationLUTShape/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PresentationLUTShape"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PresentationLUTShape/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="SOPCommonModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/SOPClassUID/'"/>
<xsl:with-param name="element" select="SOPClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/SOPClassUID/'"/>
<xsl:with-param name="element" select="SOPClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/SOPInstanceUID/'"/>
<xsl:with-param name="element" select="SOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/SOPInstanceUID/'"/>
<xsl:with-param name="element" select="SOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/SpecificCharacterSet/'"/>
<xsl:with-param name="element" select="SpecificCharacterSet"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/SpecificCharacterSet/'"/>
<xsl:with-param name="element" select="SpecificCharacterSet"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>	
			<xsl:if test="count(SpecificCharacterSet/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="count(SpecificCharacterSet/value[@number=1]) = 0 or SpecificCharacterSet/value[@number=1] = ''">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 100'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 101'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 109'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 110'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 144'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 127'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 126'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 138'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 148'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 13'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO_IR 166'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 6'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 100'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 101'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 109'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 110'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 144'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 127'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 126'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 138'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 148'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 13'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=1] = 'ISO 2022 IR 166'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: SOPCommonModule/SpecificCharacterSet/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpecificCharacterSet"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SpecificCharacterSet/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SpecificCharacterSet/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="count(SpecificCharacterSet/value[@number=2]) = 0 or SpecificCharacterSet/value[@number=2] = ''">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=2] = 'ISO 2022 IR 87'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=2] = 'ISO 2022 IR 159'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=2] = 'ISO 2022 IR 149'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=2] = 'ISO 2022 IR 58'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: SOPCommonModule/SpecificCharacterSet/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpecificCharacterSet"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SpecificCharacterSet/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SpecificCharacterSet/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="count(SpecificCharacterSet/value[@number=3]) = 0 or SpecificCharacterSet/value[@number=3] = ''">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=3] = 'ISO 2022 IR 87'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=3] = 'ISO 2022 IR 159'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=3] = 'ISO 2022 IR 149'">T</xsl:when>
<xsl:when test="SpecificCharacterSet/value[@number=3] = 'ISO 2022 IR 58'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: SOPCommonModule/SpecificCharacterSet/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpecificCharacterSet"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="3"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SpecificCharacterSet/value[@number=3]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceCreationDate/'"/>
<xsl:with-param name="element" select="InstanceCreationDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceCreationDate/'"/>
<xsl:with-param name="element" select="InstanceCreationDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceCreationTime/'"/>
<xsl:with-param name="element" select="InstanceCreationTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceCreationTime/'"/>
<xsl:with-param name="element" select="InstanceCreationTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceCreatorUID/'"/>
<xsl:with-param name="element" select="InstanceCreatorUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceCreatorUID/'"/>
<xsl:with-param name="element" select="InstanceCreatorUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/'"/>
<xsl:with-param name="element" select="CodingSchemeIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="CodingSchemeIdentificationSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeDesignator/'"/>
<xsl:with-param name="element" select="CodingSchemeDesignator"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeDesignator/'"/>
<xsl:with-param name="element" select="CodingSchemeDesignator"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeRegistry/'"/>
<xsl:with-param name="element" select="CodingSchemeRegistry"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeRegistry/'"/>
<xsl:with-param name="element" select="CodingSchemeRegistry"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
				<xsl:if test="count(CodingSchemeRegistry/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CodingSchemeRegistry/value[@number=1] = 'HL7'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeRegistry/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CodingSchemeRegistry"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CodingSchemeRegistry/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeUID/'"/>
<xsl:with-param name="element" select="CodingSchemeUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeUID/'"/>
<xsl:with-param name="element" select="CodingSchemeUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeExternalID/'"/>
<xsl:with-param name="element" select="CodingSchemeExternalID"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeExternalID/'"/>
<xsl:with-param name="element" select="CodingSchemeExternalID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
				<xsl:if test="count(CodingSchemeExternalID) &gt; 0">
<xsl:if test="count(CodingSchemeUID) &gt; 0">
<xsl:text>Error: SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeExternalID/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CodingSchemeExternalID"/>
</xsl:call-template>
<xsl:text>: May only be present when CodingSchemeUID is not</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeName/'"/>
<xsl:with-param name="element" select="CodingSchemeName"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeName/'"/>
<xsl:with-param name="element" select="CodingSchemeName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeVersion/'"/>
<xsl:with-param name="element" select="CodingSchemeVersion"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/CodingSchemeVersion/'"/>
<xsl:with-param name="element" select="CodingSchemeVersion"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/ResponsibleOrganization/'"/>
<xsl:with-param name="element" select="ResponsibleOrganization"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/CodingSchemeIdentificationSequence/ResponsibleOrganization/'"/>
<xsl:with-param name="element" select="ResponsibleOrganization"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/TimezoneOffsetFromUTC/'"/>
<xsl:with-param name="element" select="TimezoneOffsetFromUTC"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/TimezoneOffsetFromUTC/'"/>
<xsl:with-param name="element" select="TimezoneOffsetFromUTC"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/'"/>
<xsl:with-param name="element" select="ContributingEquipmentSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContributingEquipmentSequence/Item">
			<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/PurposeOfReferenceCodeSequence/'"/>
<xsl:with-param name="element" select="PurposeOfReferenceCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PurposeOfReferenceCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/InstitutionAddress/'"/>
<xsl:with-param name="element" select="InstitutionAddress"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/InstitutionAddress/'"/>
<xsl:with-param name="element" select="InstitutionAddress"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/StationName/'"/>
<xsl:with-param name="element" select="StationName"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/StationName/'"/>
<xsl:with-param name="element" select="StationName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/InstitutionalDepartmentName/'"/>
<xsl:with-param name="element" select="InstitutionalDepartmentName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/InstitutionalDepartmentName/'"/>
<xsl:with-param name="element" select="InstitutionalDepartmentName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/SoftwareVersions/'"/>
<xsl:with-param name="element" select="SoftwareVersions"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/SoftwareVersions/'"/>
<xsl:with-param name="element" select="SoftwareVersions"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/SpatialResolution/'"/>
<xsl:with-param name="element" select="SpatialResolution"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/SpatialResolution/'"/>
<xsl:with-param name="element" select="SpatialResolution"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/DateOfLastCalibration/'"/>
<xsl:with-param name="element" select="DateOfLastCalibration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/ContributionDateTime/'"/>
<xsl:with-param name="element" select="ContributionDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/ContributionDateTime/'"/>
<xsl:with-param name="element" select="ContributionDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/ContributionDescription/'"/>
<xsl:with-param name="element" select="ContributionDescription"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/ContributingEquipmentSequence/ContributionDescription/'"/>
<xsl:with-param name="element" select="ContributionDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/SOPInstanceStatus/'"/>
<xsl:with-param name="element" select="SOPInstanceStatus"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/SOPInstanceStatus/'"/>
<xsl:with-param name="element" select="SOPInstanceStatus"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(SOPInstanceStatus/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SOPInstanceStatus/value[@number=1] = 'NS'">T</xsl:when>
<xsl:when test="SOPInstanceStatus/value[@number=1] = 'OR'">T</xsl:when>
<xsl:when test="SOPInstanceStatus/value[@number=1] = 'AO'">T</xsl:when>
<xsl:when test="SOPInstanceStatus/value[@number=1] = 'AC'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SOPCommonModule/SOPInstanceStatus/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SOPInstanceStatus"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SOPInstanceStatus/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/SOPAuthorizationDateTime/'"/>
<xsl:with-param name="element" select="SOPAuthorizationDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/SOPAuthorizationDateTime/'"/>
<xsl:with-param name="element" select="SOPAuthorizationDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/SOPAuthorizationComment/'"/>
<xsl:with-param name="element" select="SOPAuthorizationComment"/>
<xsl:with-param name="vr" select="'LT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/SOPAuthorizationComment/'"/>
<xsl:with-param name="element" select="SOPAuthorizationComment"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/AuthorizationEquipmentCertificationNumber/'"/>
<xsl:with-param name="element" select="AuthorizationEquipmentCertificationNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/AuthorizationEquipmentCertificationNumber/'"/>
<xsl:with-param name="element" select="AuthorizationEquipmentCertificationNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: DigitalSignaturesMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="DigitalSignaturesMacro"/>
		<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'SOPCommonModule/EncryptedAttributesSequence/'"/>
<xsl:with-param name="element" select="EncryptedAttributesSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="EncryptedAttributesSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/EncryptedAttributesSequence/EncryptedContentTransferSyntaxUID/'"/>
<xsl:with-param name="element" select="EncryptedContentTransferSyntaxUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/EncryptedAttributesSequence/EncryptedContentTransferSyntaxUID/'"/>
<xsl:with-param name="element" select="EncryptedContentTransferSyntaxUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/EncryptedAttributesSequence/EncryptedContent/'"/>
<xsl:with-param name="element" select="EncryptedContent"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/EncryptedAttributesSequence/EncryptedContent/'"/>
<xsl:with-param name="element" select="EncryptedContent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/LongitudinalTemporalInformationModified/'"/>
<xsl:with-param name="element" select="LongitudinalTemporalInformationModified"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/LongitudinalTemporalInformationModified/'"/>
<xsl:with-param name="element" select="LongitudinalTemporalInformationModified"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(LongitudinalTemporalInformationModified/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="LongitudinalTemporalInformationModified/value[@number=1] = 'UNMODIFIED'">T</xsl:when>
<xsl:when test="LongitudinalTemporalInformationModified/value[@number=1] = 'MODIFIED'">T</xsl:when>
<xsl:when test="LongitudinalTemporalInformationModified/value[@number=1] = 'REMOVED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SOPCommonModule/LongitudinalTemporalInformationModified/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LongitudinalTemporalInformationModified"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="LongitudinalTemporalInformationModified/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceOriginStatus/'"/>
<xsl:with-param name="element" select="InstanceOriginStatus"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SOPCommonModule/InstanceOriginStatus/'"/>
<xsl:with-param name="element" select="InstanceOriginStatus"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(InstanceOriginStatus/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="InstanceOriginStatus/value[@number=1] = 'LOCAL'">T</xsl:when>
<xsl:when test="InstanceOriginStatus/value[@number=1] = 'IMPORTED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SOPCommonModule/InstanceOriginStatus/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="InstanceOriginStatus"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="InstanceOriginStatus/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="MRSpectroscopyModule">
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: MRImageAndMRSpectroscopyInstanceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRImageAndMRSpectroscopyInstanceMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vmmin" select="'4'"/>
<xsl:with-param name="vmmax" select="'4'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=1] = 'ORIGINAL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'DERIVED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=2] = 'PRIMARY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=3] = 'SPECTROSCOPY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="3"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ImageType/value[@number=3]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=4] = 'ADDITION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIVISION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MAXIMUM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MEAN'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MINIMUM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MULTIPLICATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'STD_DEVIATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'SUBTRACTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'NONE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="4"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ImageType/value[@number=4]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='ORIGINAL' and ImageType/value[@number=4]!='NONE'">
<xsl:text>Error: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must be NONE when value 1 is ORIGINAL</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='DERIVED' and ImageType/value[@number=4]='NONE'">
<xsl:text>Error: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must not be NONE when value 1 is DERIVED</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='MIXED' and ImageType/value[@number=4]!='MIXED'">
<xsl:text>Error: MRSpectroscopyModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must be MIXED when value 1 is MIXED</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: MRSpectroscopyDescriptionAtImageLevelMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="MRSpectroscopyDescriptionAtImageLevelMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TransmitterFrequency/'"/>
<xsl:with-param name="element" select="TransmitterFrequency"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TransmitterFrequency/'"/>
<xsl:with-param name="element" select="TransmitterFrequency"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TransmitterFrequency/'"/>
<xsl:with-param name="element" select="TransmitterFrequency"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TransmitterFrequency/'"/>
<xsl:with-param name="element" select="TransmitterFrequency"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(TransmitterFrequency) &gt; 0">
<xsl:if test="count(TransmitterFrequency/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/TransmitterFrequency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TransmitterFrequency"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(TransmitterFrequency) &gt; 0">
<xsl:if test="number(TransmitterFrequency/value[@number=1])=0">
<xsl:text>Warning: MRSpectroscopyModule/TransmitterFrequency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TransmitterFrequency"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(TransmitterFrequency) &gt; 0">
<xsl:if test="number(TransmitterFrequency/value[@number=2])=0">
<xsl:text>Warning: MRSpectroscopyModule/TransmitterFrequency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TransmitterFrequency"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/SpectralWidth/'"/>
<xsl:with-param name="element" select="SpectralWidth"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/SpectralWidth/'"/>
<xsl:with-param name="element" select="SpectralWidth"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/SpectralWidth/'"/>
<xsl:with-param name="element" select="SpectralWidth"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/SpectralWidth/'"/>
<xsl:with-param name="element" select="SpectralWidth"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(SpectralWidth) &gt; 0">
<xsl:if test="count(SpectralWidth/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/SpectralWidth/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpectralWidth"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SpectralWidth) &gt; 0">
<xsl:if test="number(SpectralWidth/value)=0">
<xsl:text>Warning: MRSpectroscopyModule/SpectralWidth/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpectralWidth"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/ChemicalShiftReference/'"/>
<xsl:with-param name="element" select="ChemicalShiftReference"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/ChemicalShiftReference/'"/>
<xsl:with-param name="element" select="ChemicalShiftReference"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/ChemicalShiftReference/'"/>
<xsl:with-param name="element" select="ChemicalShiftReference"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/ChemicalShiftReference/'"/>
<xsl:with-param name="element" select="ChemicalShiftReference"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(ChemicalShiftReference) &gt; 0">
<xsl:if test="count(ChemicalShiftReference/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/ChemicalShiftReference/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ChemicalShiftReference"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationTechnique/'"/>
<xsl:with-param name="element" select="VolumeLocalizationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationTechnique/'"/>
<xsl:with-param name="element" select="VolumeLocalizationTechnique"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationTechnique/'"/>
<xsl:with-param name="element" select="VolumeLocalizationTechnique"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationTechnique/'"/>
<xsl:with-param name="element" select="VolumeLocalizationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumeLocalizationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'ILOPS'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'ISIS'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'PRIME'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'PRESS'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'SLIM'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'SLOOP'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'STEAM'">T</xsl:when>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/VolumeLocalizationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeLocalizationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="VolumeLocalizationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:choose>
<xsl:when test="VolumeLocalizationTechnique/value[@number=1] != 'NONE' and (ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/'"/>
<xsl:with-param name="element" select="VolumeLocalizationSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/'"/>
<xsl:with-param name="element" select="VolumeLocalizationSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/'"/>
<xsl:with-param name="element" select="VolumeLocalizationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="VolumeLocalizationSequence/Item">
			<xsl:if test="count(VolumeLocalizationSequence) &gt; 0">
<xsl:if test="VolumeLocalizationTechnique/value[@number=1]='NONE'">
<xsl:text>Error: MRSpectroscopyModule/VolumeLocalizationSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeLocalizationSequence"/>
</xsl:call-template>
<xsl:text>: may not be present when VolumeLocalizationTechnique is NONE</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/SlabThickness/'"/>
<xsl:with-param name="element" select="SlabThickness"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/SlabThickness/'"/>
<xsl:with-param name="element" select="SlabThickness"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/SlabOrientation/'"/>
<xsl:with-param name="element" select="SlabOrientation"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/SlabOrientation/'"/>
<xsl:with-param name="element" select="SlabOrientation"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/MidSlabPosition/'"/>
<xsl:with-param name="element" select="MidSlabPosition"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyModule/VolumeLocalizationSequence/MidSlabPosition/'"/>
<xsl:with-param name="element" select="MidSlabPosition"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/Decoupling/'"/>
<xsl:with-param name="element" select="Decoupling"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/Decoupling/'"/>
<xsl:with-param name="element" select="Decoupling"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/Decoupling/'"/>
<xsl:with-param name="element" select="Decoupling"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/Decoupling/'"/>
<xsl:with-param name="element" select="Decoupling"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(Decoupling/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="Decoupling/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="Decoupling/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyModule/Decoupling/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Decoupling"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="Decoupling/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecoupledNucleus/'"/>
<xsl:with-param name="element" select="DecoupledNucleus"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="Decoupling/value[@number=1]='YES'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecoupledNucleus/'"/>
<xsl:with-param name="element" select="DecoupledNucleus"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecoupledNucleus/'"/>
<xsl:with-param name="element" select="DecoupledNucleus"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecoupledNucleus/'"/>
<xsl:with-param name="element" select="DecoupledNucleus"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(DecoupledNucleus) &gt; 0">
<xsl:if test="count(DecoupledNucleus/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/DecoupledNucleus/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecoupledNucleus"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(DecoupledNucleus/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="DecoupledNucleus/value[@number=1] = '1H'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '3HE'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '7LI'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '13C'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '19F'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '23NA'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '31P'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=1] = '129XE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/DecoupledNucleus/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecoupledNucleus"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="DecoupledNucleus/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(DecoupledNucleus/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="DecoupledNucleus/value[@number=2] = '1H'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '3HE'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '7LI'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '13C'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '19F'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '23NA'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '31P'">T</xsl:when>
<xsl:when test="DecoupledNucleus/value[@number=2] = '129XE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/DecoupledNucleus/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecoupledNucleus"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="DecoupledNucleus/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingFrequency/'"/>
<xsl:with-param name="element" select="DecouplingFrequency"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="Decoupling/value[@number=1]='YES'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingFrequency/'"/>
<xsl:with-param name="element" select="DecouplingFrequency"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingFrequency/'"/>
<xsl:with-param name="element" select="DecouplingFrequency"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingFrequency/'"/>
<xsl:with-param name="element" select="DecouplingFrequency"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(DecouplingFrequency) &gt; 0">
<xsl:if test="count(DecouplingFrequency/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/DecouplingFrequency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecouplingFrequency"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(DecouplingFrequency) &gt; 0">
<xsl:if test="number(DecouplingFrequency/value[@number=1])=0">
<xsl:text>Warning: MRSpectroscopyModule/DecouplingFrequency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecouplingFrequency"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(DecouplingFrequency) &gt; 0">
<xsl:if test="number(DecouplingFrequency/value[@number=2])=0">
<xsl:text>Warning: MRSpectroscopyModule/DecouplingFrequency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecouplingFrequency"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingMethod/'"/>
<xsl:with-param name="element" select="DecouplingMethod"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="Decoupling/value[@number=1]='YES'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingMethod/'"/>
<xsl:with-param name="element" select="DecouplingMethod"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingMethod/'"/>
<xsl:with-param name="element" select="DecouplingMethod"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingMethod/'"/>
<xsl:with-param name="element" select="DecouplingMethod"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(DecouplingMethod/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="DecouplingMethod/value[@number=1] = 'MLEV'">T</xsl:when>
<xsl:when test="DecouplingMethod/value[@number=1] = 'WALTZ'">T</xsl:when>
<xsl:when test="DecouplingMethod/value[@number=1] = 'NARROWBAND'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/DecouplingMethod/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecouplingMethod"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="DecouplingMethod/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingChemicalShiftReference/'"/>
<xsl:with-param name="element" select="DecouplingChemicalShiftReference"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="Decoupling/value[@number=1]='YES'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingChemicalShiftReference/'"/>
<xsl:with-param name="element" select="DecouplingChemicalShiftReference"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingChemicalShiftReference/'"/>
<xsl:with-param name="element" select="DecouplingChemicalShiftReference"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/DecouplingChemicalShiftReference/'"/>
<xsl:with-param name="element" select="DecouplingChemicalShiftReference"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(DecouplingChemicalShiftReference) &gt; 0">
<xsl:if test="count(DecouplingChemicalShiftReference/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/DecouplingChemicalShiftReference/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DecouplingChemicalShiftReference"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TimeDomainFiltering/'"/>
<xsl:with-param name="element" select="TimeDomainFiltering"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TimeDomainFiltering/'"/>
<xsl:with-param name="element" select="TimeDomainFiltering"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TimeDomainFiltering/'"/>
<xsl:with-param name="element" select="TimeDomainFiltering"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/TimeDomainFiltering/'"/>
<xsl:with-param name="element" select="TimeDomainFiltering"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(TimeDomainFiltering) &gt; 0">
<xsl:if test="count(TimeDomainFiltering/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/TimeDomainFiltering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TimeDomainFiltering"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(TimeDomainFiltering/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="TimeDomainFiltering/value = 'COSINE'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'COSINE_SQUARED'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'EXPONENTIAL'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'GAUSSIAN'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'HAMMING'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'HANNING'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'LORENTZIAN'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'LRNTZ_GSS_TRNSFM'">T</xsl:when>
<xsl:when test="TimeDomainFiltering/value = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/TimeDomainFiltering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="TimeDomainFiltering"/>
</xsl:call-template>
<xsl:text>: Unrecognized defined term :</xsl:text>
<xsl:value-of select="TimeDomainFiltering/value"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/NumberOfZeroFills/'"/>
<xsl:with-param name="element" select="NumberOfZeroFills"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/NumberOfZeroFills/'"/>
<xsl:with-param name="element" select="NumberOfZeroFills"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/NumberOfZeroFills/'"/>
<xsl:with-param name="element" select="NumberOfZeroFills"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/NumberOfZeroFills/'"/>
<xsl:with-param name="element" select="NumberOfZeroFills"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(NumberOfZeroFills) &gt; 0">
<xsl:if test="count(NumberOfZeroFills/value) != DataPointRows/value[@number=1]">
<xsl:text>Error: MRSpectroscopyModule/NumberOfZeroFills/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="NumberOfZeroFills"/>
</xsl:call-template>
<xsl:text>: VM must equal value of Data Point Rows</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/BaselineCorrection/'"/>
<xsl:with-param name="element" select="BaselineCorrection"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/BaselineCorrection/'"/>
<xsl:with-param name="element" select="BaselineCorrection"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/BaselineCorrection/'"/>
<xsl:with-param name="element" select="BaselineCorrection"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/BaselineCorrection/'"/>
<xsl:with-param name="element" select="BaselineCorrection"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(BaselineCorrection/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BaselineCorrection/value[@number=1] = 'LINEAR_TILT'">T</xsl:when>
<xsl:when test="BaselineCorrection/value[@number=1] = 'LOCAL_LINEAR_FIT'">T</xsl:when>
<xsl:when test="BaselineCorrection/value[@number=1] = 'POLYNOMIAL_FIT'">T</xsl:when>
<xsl:when test="BaselineCorrection/value[@number=1] = 'SINC_DECONVOLUTION'">T</xsl:when>
<xsl:when test="BaselineCorrection/value[@number=1] = 'TIME_DOMAIN_FIT'">T</xsl:when>
<xsl:when test="BaselineCorrection/value[@number=1] = 'SPLINE'">T</xsl:when>
<xsl:when test="BaselineCorrection/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyModule/BaselineCorrection/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BaselineCorrection"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="BaselineCorrection/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FrequencyCorrection/'"/>
<xsl:with-param name="element" select="FrequencyCorrection"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FrequencyCorrection/'"/>
<xsl:with-param name="element" select="FrequencyCorrection"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FrequencyCorrection/'"/>
<xsl:with-param name="element" select="FrequencyCorrection"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FrequencyCorrection/'"/>
<xsl:with-param name="element" select="FrequencyCorrection"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(FrequencyCorrection/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="FrequencyCorrection/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="FrequencyCorrection/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyModule/FrequencyCorrection/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="FrequencyCorrection"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="FrequencyCorrection/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FirstOrderPhaseCorrection/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrection"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FirstOrderPhaseCorrection/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrection"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FirstOrderPhaseCorrection/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrection"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/FirstOrderPhaseCorrection/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrection"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(FirstOrderPhaseCorrection/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="FirstOrderPhaseCorrection/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="FirstOrderPhaseCorrection/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyModule/FirstOrderPhaseCorrection/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="FirstOrderPhaseCorrection"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="FirstOrderPhaseCorrection/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyModule/WaterReferencedPhaseCorrection/'"/>
<xsl:with-param name="element" select="WaterReferencedPhaseCorrection"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/WaterReferencedPhaseCorrection/'"/>
<xsl:with-param name="element" select="WaterReferencedPhaseCorrection"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyModule/WaterReferencedPhaseCorrection/'"/>
<xsl:with-param name="element" select="WaterReferencedPhaseCorrection"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyModule/WaterReferencedPhaseCorrection/'"/>
<xsl:with-param name="element" select="WaterReferencedPhaseCorrection"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(WaterReferencedPhaseCorrection/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="WaterReferencedPhaseCorrection/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="WaterReferencedPhaseCorrection/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyModule/WaterReferencedPhaseCorrection/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="WaterReferencedPhaseCorrection"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="WaterReferencedPhaseCorrection/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="MRSpectroscopyPulseSequenceModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/PulseSequenceName/'"/>
<xsl:with-param name="element" select="PulseSequenceName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MRSpectroscopyAcquisitionType/'"/>
<xsl:with-param name="element" select="MRSpectroscopyAcquisitionType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MRSpectroscopyAcquisitionType/'"/>
<xsl:with-param name="element" select="MRSpectroscopyAcquisitionType"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MRSpectroscopyAcquisitionType/'"/>
<xsl:with-param name="element" select="MRSpectroscopyAcquisitionType"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MRSpectroscopyAcquisitionType/'"/>
<xsl:with-param name="element" select="MRSpectroscopyAcquisitionType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(MRSpectroscopyAcquisitionType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MRSpectroscopyAcquisitionType/value[@number=1] = 'SINGLE_VOXEL'">T</xsl:when>
<xsl:when test="MRSpectroscopyAcquisitionType/value[@number=1] = 'ROW'">T</xsl:when>
<xsl:when test="MRSpectroscopyAcquisitionType/value[@number=1] = 'PLANE'">T</xsl:when>
<xsl:when test="MRSpectroscopyAcquisitionType/value[@number=1] = 'VOLUME'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyPulseSequenceModule/MRSpectroscopyAcquisitionType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MRSpectroscopyAcquisitionType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="MRSpectroscopyAcquisitionType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPulseSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(EchoPulseSequence/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="EchoPulseSequence/value[@number=1] = 'SPIN'">T</xsl:when>
<xsl:when test="EchoPulseSequence/value[@number=1] = 'GRADIENT'">T</xsl:when>
<xsl:when test="EchoPulseSequence/value[@number=1] = 'BOTH'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/EchoPulseSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="EchoPulseSequence"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="EchoPulseSequence/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')                    and (EchoPulseSequence/value[@number=1]='SPIN' or EchoPulseSequence/value[@number=1]='BOTH')">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultipleSpinEcho/'"/>
<xsl:with-param name="element" select="MultipleSpinEcho"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(MultipleSpinEcho) &gt; 0">
<xsl:if test="EchoPulseSequence/value[@number=1]!='SPIN' and EchoPulseSequence/value[@number=1]!='BOTH'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/MultipleSpinEcho/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultipleSpinEcho"/>
</xsl:call-template>
<xsl:text>: Can only be present when EchoPulseSequence is SPIN or BOTH</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(MultipleSpinEcho/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MultipleSpinEcho/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="MultipleSpinEcho/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/MultipleSpinEcho/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultipleSpinEcho"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="MultipleSpinEcho/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/MultiPlanarExcitation/'"/>
<xsl:with-param name="element" select="MultiPlanarExcitation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(MultiPlanarExcitation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MultiPlanarExcitation/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="MultiPlanarExcitation/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/MultiPlanarExcitation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MultiPlanarExcitation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="MultiPlanarExcitation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SteadyStatePulseSequence/'"/>
<xsl:with-param name="element" select="SteadyStatePulseSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SteadyStatePulseSequence/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'FREE_PRECESSION'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'TRANSVERSE'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'TIME_REVERSED'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'LONGITUDINAL'">T</xsl:when>
<xsl:when test="SteadyStatePulseSequence/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyPulseSequenceModule/SteadyStatePulseSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SteadyStatePulseSequence"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SteadyStatePulseSequence/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/EchoPlanarPulseSequence/'"/>
<xsl:with-param name="element" select="EchoPlanarPulseSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(EchoPlanarPulseSequence/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="EchoPlanarPulseSequence/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="EchoPlanarPulseSequence/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/EchoPlanarPulseSequence/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="EchoPlanarPulseSequence"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="EchoPlanarPulseSequence/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SpectrallySelectedSuppression/'"/>
<xsl:with-param name="element" select="SpectrallySelectedSuppression"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SpectrallySelectedSuppression/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'FAT'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'WATER'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'FAT_AND_WATER'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'SILICON_GEL'">T</xsl:when>
<xsl:when test="SpectrallySelectedSuppression/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyPulseSequenceModule/SpectrallySelectedSuppression/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpectrallySelectedSuppression"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SpectrallySelectedSuppression/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/GeometryOfKSpaceTraversal/'"/>
<xsl:with-param name="element" select="GeometryOfKSpaceTraversal"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(GeometryOfKSpaceTraversal/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="GeometryOfKSpaceTraversal/value[@number=1] = 'RECTILINEAR'">T</xsl:when>
<xsl:when test="GeometryOfKSpaceTraversal/value[@number=1] = 'RADIAL'">T</xsl:when>
<xsl:when test="GeometryOfKSpaceTraversal/value[@number=1] = 'SPIRAL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyPulseSequenceModule/GeometryOfKSpaceTraversal/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="GeometryOfKSpaceTraversal"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="GeometryOfKSpaceTraversal/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')                    and  GeometryOfKSpaceTraversal/value[@number=1]='RECTILINEAR'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/RectilinearPhaseEncodeReordering/'"/>
<xsl:with-param name="element" select="RectilinearPhaseEncodeReordering"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(RectilinearPhaseEncodeReordering) &gt; 0">
<xsl:if test="GeometryOfKSpaceTraversal/value[@number=1]!='RECTILINEAR'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/RectilinearPhaseEncodeReordering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RectilinearPhaseEncodeReordering"/>
</xsl:call-template>
<xsl:text>: Can only be present when GeometryOfKSpaceTraversal is RECTILINEAR</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RectilinearPhaseEncodeReordering/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'LINEAR'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'CENTRIC'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'SEGMENTED'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'REVERSE_LINEAR'">T</xsl:when>
<xsl:when test="RectilinearPhaseEncodeReordering/value[@number=1] = 'REVERSE_CENTRIC'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyPulseSequenceModule/RectilinearPhaseEncodeReordering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RectilinearPhaseEncodeReordering"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="RectilinearPhaseEncodeReordering/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/SegmentedKSpaceTraversal/'"/>
<xsl:with-param name="element" select="SegmentedKSpaceTraversal"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SegmentedKSpaceTraversal/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SegmentedKSpaceTraversal/value[@number=1] = 'SINGLE'">T</xsl:when>
<xsl:when test="SegmentedKSpaceTraversal/value[@number=1] = 'PARTIAL'">T</xsl:when>
<xsl:when test="SegmentedKSpaceTraversal/value[@number=1] = 'FULL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/SegmentedKSpaceTraversal/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SegmentedKSpaceTraversal"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SegmentedKSpaceTraversal/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED')                     and  MRSpectroscopyAcquisitionType/value[@number=1]='VOLUME'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/CoverageOfKSpace/'"/>
<xsl:with-param name="element" select="CoverageOfKSpace"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(CoverageOfKSpace) &gt; 0">
<xsl:if test="MRAcquisitionType/value[@number=1]!='VOLUME'">
<xsl:text>Error: MRSpectroscopyPulseSequenceModule/CoverageOfKSpace/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CoverageOfKSpace"/>
</xsl:call-template>
<xsl:text>: Can only be present when MRSpectroscopyAcquisitionType is VOLUME</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(CoverageOfKSpace/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'FULL'">T</xsl:when>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'CYLINDRICAL'">T</xsl:when>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'ELLIPSOIDAL'">T</xsl:when>
<xsl:when test="CoverageOfKSpace/value[@number=1] = 'WEIGHTED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyPulseSequenceModule/CoverageOfKSpace/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CoverageOfKSpace"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CoverageOfKSpace/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyPulseSequenceModule/NumberOfKSpaceTrajectories/'"/>
<xsl:with-param name="element" select="NumberOfKSpaceTrajectories"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="MRSpectroscopyDataModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/Rows/'"/>
<xsl:with-param name="element" select="Rows"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/Rows/'"/>
<xsl:with-param name="element" select="Rows"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(Rows) &gt; 0">
<xsl:if test="number(Rows/value)=0">
<xsl:text>Error: MRSpectroscopyDataModule/Rows/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Rows"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/Columns/'"/>
<xsl:with-param name="element" select="Columns"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/Columns/'"/>
<xsl:with-param name="element" select="Columns"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(Columns) &gt; 0">
<xsl:if test="number(Columns/value)=0">
<xsl:text>Error: MRSpectroscopyDataModule/Columns/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Columns"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/DataPointRows/'"/>
<xsl:with-param name="element" select="DataPointRows"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/DataPointRows/'"/>
<xsl:with-param name="element" select="DataPointRows"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
			<xsl:if test="count(DataPointRows) &gt; 0">
<xsl:if test="number(DataPointRows/value)=0">
<xsl:text>Error: MRSpectroscopyDataModule/DataPointRows/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DataPointRows"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/DataPointColumns/'"/>
<xsl:with-param name="element" select="DataPointColumns"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/DataPointColumns/'"/>
<xsl:with-param name="element" select="DataPointColumns"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
			<xsl:if test="count(DataPointColumns) &gt; 0">
<xsl:if test="number(DataPointColumns/value)=0">
<xsl:text>Error: MRSpectroscopyDataModule/DataPointColumns/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DataPointColumns"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/DataRepresentation/'"/>
<xsl:with-param name="element" select="DataRepresentation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/DataRepresentation/'"/>
<xsl:with-param name="element" select="DataRepresentation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(DataRepresentation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="DataRepresentation/value[@number=1] = 'COMPLEX'">T</xsl:when>
<xsl:when test="DataRepresentation/value[@number=1] = 'REAL'">T</xsl:when>
<xsl:when test="DataRepresentation/value[@number=1] = 'IMAGINARY'">T</xsl:when>
<xsl:when test="DataRepresentation/value[@number=1] = 'MAGNITUDE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyDataModule/DataRepresentation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DataRepresentation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="DataRepresentation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SignalDomainColumns/'"/>
<xsl:with-param name="element" select="SignalDomainColumns"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SignalDomainColumns/'"/>
<xsl:with-param name="element" select="SignalDomainColumns"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SignalDomainColumns/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SignalDomainColumns/value[@number=1] = 'FREQUENCY'">T</xsl:when>
<xsl:when test="SignalDomainColumns/value[@number=1] = 'TIME'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyDataModule/SignalDomainColumns/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SignalDomainColumns"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SignalDomainColumns/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SignalDomainRows/'"/>
<xsl:with-param name="element" select="SignalDomainRows"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="DataPointRows/value[@number=1] &gt; 1 or ImageType/value[@number=1]='MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SignalDomainRows/'"/>
<xsl:with-param name="element" select="SignalDomainRows"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SignalDomainRows/'"/>
<xsl:with-param name="element" select="SignalDomainRows"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SignalDomainRows/'"/>
<xsl:with-param name="element" select="SignalDomainRows"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SignalDomainRows/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SignalDomainRows/value[@number=1] = 'FREQUENCY'">T</xsl:when>
<xsl:when test="SignalDomainRows/value[@number=1] = 'TIME'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyDataModule/SignalDomainRows/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SignalDomainRows"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SignalDomainRows/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/FirstOrderPhaseCorrectionAngle/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrectionAngle"/>
<xsl:with-param name="vr" select="'OF'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="FirstOrderPhaseCorrection/value[@number=1] = 'YES'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/FirstOrderPhaseCorrectionAngle/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrectionAngle"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/FirstOrderPhaseCorrectionAngle/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrectionAngle"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/FirstOrderPhaseCorrectionAngle/'"/>
<xsl:with-param name="element" select="FirstOrderPhaseCorrectionAngle"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OF'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SpectroscopyData/'"/>
<xsl:with-param name="element" select="SpectroscopyData"/>
<xsl:with-param name="vr" select="'OF'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDataModule/SpectroscopyData/'"/>
<xsl:with-param name="element" select="SpectroscopyData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OF'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="CTSeriesModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CTSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CTSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(Modality/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="Modality/value[@number=1] = 'CT'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CTSeriesModule/Modality/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Modality"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="Modality/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'CTSeriesModule/ReferencedPerformedProcedureStepSequence/'"/>
<xsl:with-param name="element" select="ReferencedPerformedProcedureStepSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPerformedProcedureStepSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="EnhancedCTImageModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vmmin" select="'4'"/>
<xsl:with-param name="vmmax" select="'4'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=1] = 'ORIGINAL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'DERIVED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=2] = 'PRIMARY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=3] = 'ANGIO'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDIAC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDIAC_GATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDRESP_GATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'DYNAMIC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'FLUOROSCOPY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'LOCALIZER'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'MOTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PERFUSION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PRE_CONTRAST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'POST_CONTRAST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'RESP_GATED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'REST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'STATIC'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'STRESS'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'VOLUME'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'NON_PARALLEL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'PARALLEL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'WHOLE_BODY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'ATTENUATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDIAC_CTA'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'CARDIAC_CASCORE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=3] = 'REFERENCE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="3"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ImageType/value[@number=3]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=4] = 'FILTERED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MEDIAN'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'ENERGY_PROP_WT'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'ADDITION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'DIVISION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MASKED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MAXIMUM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MEAN'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MINIMUM'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MTT'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MULTIPLICATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RCBF'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RCBV'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'RESAMPLED'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'STD_DEVIATION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'SUBTRACTION'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'T_TEST'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'TTP'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'Z_SCORE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'NONE'">T</xsl:when>
<xsl:when test="ImageType/value[@number=4] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="4"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ImageType/value[@number=4]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='ORIGINAL' and ImageType/value[@number=4]!='NONE'">
<xsl:text>Error: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must be NONE when value 1 is ORIGINAL</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='DERIVED' and ImageType/value[@number=4]='NONE'">
<xsl:text>Error: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must not be NONE when value 1 is DERIVED</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='MIXED' and ImageType/value[@number=4]!='MIXED'">
<xsl:text>Error: EnhancedCTImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>: value 4 must be MIXED when value 1 is MIXED</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CommonCTMRImageDescriptionAtImageLevelMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CommonCTMRImageDescriptionAtImageLevelMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionNumber/'"/>
<xsl:with-param name="element" select="AcquisitionNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionNumber/'"/>
<xsl:with-param name="element" select="AcquisitionNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.2.2'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.2.2'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionDuration) &gt; 0">
<xsl:if test="number(AcquisitionDuration/value)=0">
<xsl:text>Warning: EnhancedCTImageModule/AcquisitionDuration/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionDuration"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ReferencedRawDataSequence/'"/>
<xsl:with-param name="element" select="ReferencedRawDataSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedRawDataSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ReferencedWaveformSequence/'"/>
<xsl:with-param name="element" select="ReferencedWaveformSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedWaveformSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:choose>
<xsl:when test="count(//ReferencedImageSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ReferencedImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageEvidenceSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ReferencedImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageEvidenceSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ReferencedImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageEvidenceSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedImageEvidenceSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:choose>
<xsl:when test="count(//SourceImageSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/SourceImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="SourceImageEvidenceSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/SourceImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="SourceImageEvidenceSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/SourceImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="SourceImageEvidenceSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="SourceImageEvidenceSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ReferencedPresentationStateSequence/'"/>
<xsl:with-param name="element" select="ReferencedPresentationStateSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPresentationStateSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(SamplesPerPixel/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SamplesPerPixel/value[@number=1] = '1'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SamplesPerPixel/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PhotometricInterpretation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'MONOCHROME2'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/PhotometricInterpretation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PhotometricInterpretation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PhotometricInterpretation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LargestMonochromePixelValue/'"/>
<xsl:with-param name="element" select="LargestMonochromePixelValue"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LargestMonochromePixelValue/'"/>
<xsl:with-param name="element" select="LargestMonochromePixelValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="count(LargestMonochromePixelValue) != 0">
<xsl:text>Warning: EnhancedCTImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue is retired and should not be used</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="LargestMonochromePixelValue/value + 1 != RedPaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: EnhancedCTImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue should be one less than RedPaletteColorLookupTableDescriptor value 2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="LargestMonochromePixelValue/value + 1 != GreenPaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: EnhancedCTImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue should be one less than GreenPaletteColorLookupTableDescriptor value 2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(LargestMonochromePixelValue) &gt; 0">
<xsl:if test="LargestMonochromePixelValue/value + 1 != BluePaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: EnhancedCTImageModule/LargestMonochromePixelValue/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LargestMonochromePixelValue"/>
</xsl:call-template>
<xsl:text>: LargestMonochromePixelValue should be one less than BluePaletteColorLookupTableDescriptor value 2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsAllocated/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BitsAllocated/value[@number=1] = '16'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BitsAllocated/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsStored/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BitsStored/value[@number=1] = '12'">T</xsl:when>
<xsl:when test="BitsStored/value[@number=1] = '16'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/BitsStored/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsStored"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BitsStored/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(HighBit/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="HighBit/value[@number=1] = '11'">T</xsl:when>
<xsl:when test="HighBit/value[@number=1] = '15'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="HighBit/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(HighBit) &gt; 0">
<xsl:if test="BitsStored/value != (HighBit/value + 1)">
<xsl:text>Error: EnhancedCTImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>: Must be one less than BitsStored</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.2.2'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ContentQualification/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ContentQualification/value[@number=1] = 'PRODUCT'">T</xsl:when>
<xsl:when test="ContentQualification/value[@number=1] = 'RESEARCH'">T</xsl:when>
<xsl:when test="ContentQualification/value[@number=1] = 'SERVICE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/ContentQualification/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContentQualification"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ContentQualification/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ImageComments/'"/>
<xsl:with-param name="element" select="ImageComments"/>
<xsl:with-param name="vr" select="'LT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/ImageComments/'"/>
<xsl:with-param name="element" select="ImageComments"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.2.2'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(BurnedInAnnotation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BurnedInAnnotation/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/BurnedInAnnotation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BurnedInAnnotation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BurnedInAnnotation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/RecognizableVisualFeatures/'"/>
<xsl:with-param name="element" select="RecognizableVisualFeatures"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/RecognizableVisualFeatures/'"/>
<xsl:with-param name="element" select="RecognizableVisualFeatures"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(RecognizableVisualFeatures/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RecognizableVisualFeatures/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="RecognizableVisualFeatures/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/RecognizableVisualFeatures/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RecognizableVisualFeatures"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="RecognizableVisualFeatures/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.2.2'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(LossyImageCompression/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="LossyImageCompression/value[@number=1] = '00'">T</xsl:when>
<xsl:when test="LossyImageCompression/value[@number=1] = '01'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/LossyImageCompression/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LossyImageCompression"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="LossyImageCompression/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="LossyImageCompression/value='01'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="LossyImageCompression/value='01'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'EnhancedCTImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'EnhancedCTImageModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'EnhancedCTImageModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PresentationLUTShape/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PresentationLUTShape/value[@number=1] = 'IDENTITY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: EnhancedCTImageModule/PresentationLUTShape/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PresentationLUTShape"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PresentationLUTShape/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: OptionalViewAndSliceProgressionDirectionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="OptionalViewAndSliceProgressionDirectionMacro"/>
	</xsl:template>
<xsl:template name="RawDataModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RawDataModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ContentDate/'"/>
<xsl:with-param name="element" select="ContentDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RawDataModule/ContentDate/'"/>
<xsl:with-param name="element" select="ContentDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ContentTime/'"/>
<xsl:with-param name="element" select="ContentTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RawDataModule/ContentTime/'"/>
<xsl:with-param name="element" select="ContentTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RawDataModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ContentLabel/'"/>
<xsl:with-param name="element" select="ContentLabel"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RawDataModule/ContentLabel/'"/>
<xsl:with-param name="element" select="ContentLabel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ContentDescription/'"/>
<xsl:with-param name="element" select="ContentDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RawDataModule/ContentDescription/'"/>
<xsl:with-param name="element" select="ContentDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RawDataModule/ConceptNameCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptNameCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ConceptNameCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/CreatorVersionUID/'"/>
<xsl:with-param name="element" select="CreatorVersionUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RawDataModule/CreatorVersionUID/'"/>
<xsl:with-param name="element" select="CreatorVersionUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/'"/>
<xsl:with-param name="element" select="ReferencedInstanceSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedInstanceSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedFrameNumber/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ReferencedFrameNumber) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedFrameNumber/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumber"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedFrameNumber/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumber"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/ReferencedFrameNumber/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
			<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'RawDataModule/ReferencedInstanceSequence/PurposeOfReferenceCodeSequence/'"/>
<xsl:with-param name="element" select="PurposeOfReferenceCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PurposeOfReferenceCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="CommonInstanceReferenceModule">
		<xsl:choose>
<xsl:when test="count(//ReferencedSOPInstanceUID) &gt; 0 and count(StudiesContainingOtherReferencedInstancesSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/ReferencedSeriesSequence/'"/>
<xsl:with-param name="element" select="ReferencedSeriesSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/ReferencedSeriesSequence/'"/>
<xsl:with-param name="element" select="ReferencedSeriesSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/ReferencedSeriesSequence/'"/>
<xsl:with-param name="element" select="ReferencedSeriesSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedSeriesSequence/Item">	
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/ReferencedSeriesSequence/SeriesInstanceUID/'"/>
<xsl:with-param name="element" select="SeriesInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/ReferencedSeriesSequence/SeriesInstanceUID/'"/>
<xsl:with-param name="element" select="SeriesInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/ReferencedSeriesSequence/ReferencedInstanceSequence/'"/>
<xsl:with-param name="element" select="ReferencedInstanceSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedInstanceSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:choose>
<xsl:when test="count(//ReferencedSOPInstanceUID) &gt; 0 and count(ReferencedSeriesSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/StudiesContainingOtherReferencedInstancesSequence/'"/>
<xsl:with-param name="element" select="StudiesContainingOtherReferencedInstancesSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/StudiesContainingOtherReferencedInstancesSequence/'"/>
<xsl:with-param name="element" select="StudiesContainingOtherReferencedInstancesSequence"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/StudiesContainingOtherReferencedInstancesSequence/'"/>
<xsl:with-param name="element" select="StudiesContainingOtherReferencedInstancesSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="StudiesContainingOtherReferencedInstancesSequence/Item">	
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/StudiesContainingOtherReferencedInstancesSequence/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonInstanceReferenceModule/StudiesContainingOtherReferencedInstancesSequence/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SeriesAndInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SeriesAndInstanceReferenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="FrameExtractionModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/'"/>
<xsl:with-param name="element" select="FrameExtractionSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="FrameExtractionSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/MultiFrameSourceSOPInstanceUID/'"/>
<xsl:with-param name="element" select="MultiFrameSourceSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/MultiFrameSourceSOPInstanceUID/'"/>
<xsl:with-param name="element" select="MultiFrameSourceSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/SimpleFrameList/'"/>
<xsl:with-param name="element" select="SimpleFrameList"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CalculatedFrameList) = 0 and count(TimeRange) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/SimpleFrameList/'"/>
<xsl:with-param name="element" select="SimpleFrameList"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/SimpleFrameList/'"/>
<xsl:with-param name="element" select="SimpleFrameList"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/SimpleFrameList/'"/>
<xsl:with-param name="element" select="SimpleFrameList"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/CalculatedFrameList/'"/>
<xsl:with-param name="element" select="CalculatedFrameList"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(SimpleFrameList) = 0 and count(TimeRange) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/CalculatedFrameList/'"/>
<xsl:with-param name="element" select="CalculatedFrameList"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/CalculatedFrameList/'"/>
<xsl:with-param name="element" select="CalculatedFrameList"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/CalculatedFrameList/'"/>
<xsl:with-param name="element" select="CalculatedFrameList"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UL'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/TimeRange/'"/>
<xsl:with-param name="element" select="TimeRange"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(SimpleFrameList) = 0 and count(CalculatedFrameList) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/TimeRange/'"/>
<xsl:with-param name="element" select="TimeRange"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/TimeRange/'"/>
<xsl:with-param name="element" select="TimeRange"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'FrameExtractionModule/FrameExtractionSequence/TimeRange/'"/>
<xsl:with-param name="element" select="TimeRange"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="SpecimenModule">
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SpecimenMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SpecimenMacro"/>
	</xsl:template>
<xsl:template name="DeviceModule">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/'"/>
<xsl:with-param name="element" select="DeviceSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="DeviceSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/Manufacturer/'"/>
<xsl:with-param name="element" select="Manufacturer"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/ManufacturerModelName/'"/>
<xsl:with-param name="element" select="ManufacturerModelName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceSerialNumber/'"/>
<xsl:with-param name="element" select="DeviceSerialNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceID/'"/>
<xsl:with-param name="element" select="DeviceID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceID/'"/>
<xsl:with-param name="element" select="DeviceID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceLength/'"/>
<xsl:with-param name="element" select="DeviceLength"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceLength/'"/>
<xsl:with-param name="element" select="DeviceLength"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDiameter/'"/>
<xsl:with-param name="element" select="DeviceDiameter"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDiameter/'"/>
<xsl:with-param name="element" select="DeviceDiameter"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDiameterUnits/'"/>
<xsl:with-param name="element" select="DeviceDiameterUnits"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(DeviceDiameter) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDiameterUnits/'"/>
<xsl:with-param name="element" select="DeviceDiameterUnits"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDiameterUnits/'"/>
<xsl:with-param name="element" select="DeviceDiameterUnits"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDiameterUnits/'"/>
<xsl:with-param name="element" select="DeviceDiameterUnits"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
					<xsl:if test="count(DeviceDiameterUnits/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="DeviceDiameterUnits/value[@number=1] = 'FR'">T</xsl:when>
<xsl:when test="DeviceDiameterUnits/value[@number=1] = 'GA'">T</xsl:when>
<xsl:when test="DeviceDiameterUnits/value[@number=1] = 'IN'">T</xsl:when>
<xsl:when test="DeviceDiameterUnits/value[@number=1] = 'MM'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: DeviceModule/DeviceSequence/DeviceDiameterUnits/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="DeviceDiameterUnits"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="DeviceDiameterUnits/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceVolume/'"/>
<xsl:with-param name="element" select="DeviceVolume"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceVolume/'"/>
<xsl:with-param name="element" select="DeviceVolume"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/InterMarkerDistance/'"/>
<xsl:with-param name="element" select="InterMarkerDistance"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/InterMarkerDistance/'"/>
<xsl:with-param name="element" select="InterMarkerDistance"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDescription/'"/>
<xsl:with-param name="element" select="DeviceDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DeviceModule/DeviceSequence/DeviceDescription/'"/>
<xsl:with-param name="element" select="DeviceDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="SegmentationSeriesModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationSeriesModule/Modality/'"/>
<xsl:with-param name="element" select="Modality"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(Modality/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="Modality/value[@number=1] = 'SEG'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationSeriesModule/Modality/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Modality"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="Modality/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationSeriesModule/SeriesNumber/'"/>
<xsl:with-param name="element" select="SeriesNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationSeriesModule/SeriesNumber/'"/>
<xsl:with-param name="element" select="SeriesNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'SegmentationSeriesModule/ReferencedPerformedProcedureStepSequence/'"/>
<xsl:with-param name="element" select="ReferencedPerformedProcedureStepSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPerformedProcedureStepSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="SegmentationImageModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vmmin" select="'2'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=1] = 'DERIVED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=2] = 'PRIMARY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(SamplesPerPixel/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SamplesPerPixel/value[@number=1] = '1'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SamplesPerPixel/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PhotometricInterpretation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'MONOCHROME2'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/PhotometricInterpretation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PhotometricInterpretation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PhotometricInterpretation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/PixelRepresentation/'"/>
<xsl:with-param name="element" select="PixelRepresentation"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/PixelRepresentation/'"/>
<xsl:with-param name="element" select="PixelRepresentation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(PixelRepresentation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PixelRepresentation/value[@number=1] = '0'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/PixelRepresentation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelRepresentation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PixelRepresentation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsAllocated/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BitsAllocated/value[@number=1] = '1'">T</xsl:when>
<xsl:when test="BitsAllocated/value[@number=1] = '8'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BitsAllocated/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BitsAllocated) &gt; 0">
<xsl:if test="SegmentationType/value  = 'BINARY' and BitsAllocated/value != 1">
<xsl:text>Error: SegmentationImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>: Must be 1 when SegmentationType is BINARY</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BitsAllocated) &gt; 0">
<xsl:if test="SegmentationType/value != 'BINARY' and BitsAllocated/value != 8">
<xsl:text>Error: SegmentationImageModule/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>: Must be 8 when SegmentationType is not BINARY</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsStored/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BitsStored/value[@number=1] = '1'">T</xsl:when>
<xsl:when test="BitsStored/value[@number=1] = '8'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/BitsStored/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsStored"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BitsStored/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BitsStored) &gt; 0">
<xsl:if test="SegmentationType/value  = 'BINARY' and BitsStored/value != 1">
<xsl:text>Error: SegmentationImageModule/BitsStored/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsStored"/>
</xsl:call-template>
<xsl:text>: Must be 1 when SegmentationType is BINARY</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(BitsStored) &gt; 0">
<xsl:if test="SegmentationType/value != 'BINARY' and BitsStored/value != 8">
<xsl:text>Error: SegmentationImageModule/BitsStored/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsStored"/>
</xsl:call-template>
<xsl:text>: Must be 8 when SegmentationType is not BINARY</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(HighBit/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="HighBit/value[@number=1] = '0'">T</xsl:when>
<xsl:when test="HighBit/value[@number=1] = '7'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="HighBit/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(HighBit) &gt; 0">
<xsl:if test="SegmentationType/value  = 'BINARY' and HighBit/value != 0">
<xsl:text>Error: SegmentationImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>: Must be 0 when SegmentationType is BINARY</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(HighBit) &gt; 0">
<xsl:if test="SegmentationType/value != 'BINARY' and HighBit/value != 7">
<xsl:text>Error: SegmentationImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>: Must be 7 when SegmentationType is not BINARY</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(HighBit) &gt; 0">
<xsl:if test="BitsStored/value != (HighBit/value + 1)">
<xsl:text>Error: SegmentationImageModule/HighBit/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="HighBit"/>
</xsl:call-template>
<xsl:text>: Must be one less than BitsStored</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(LossyImageCompression/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="LossyImageCompression/value[@number=1] = '00'">T</xsl:when>
<xsl:when test="LossyImageCompression/value[@number=1] = '01'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/LossyImageCompression/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LossyImageCompression"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="LossyImageCompression/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="LossyImageCompression/value='01'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="LossyImageCompression/value='01'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SegmentationImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentationType/'"/>
<xsl:with-param name="element" select="SegmentationType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentationType/'"/>
<xsl:with-param name="element" select="SegmentationType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SegmentationType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SegmentationType/value[@number=1] = 'BINARY'">T</xsl:when>
<xsl:when test="SegmentationType/value[@number=1] = 'FRACTIONAL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/SegmentationType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SegmentationType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SegmentationType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentationFractionalType/'"/>
<xsl:with-param name="element" select="SegmentationFractionalType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="SegmentationType/value = 'FRACTIONAL'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentationFractionalType/'"/>
<xsl:with-param name="element" select="SegmentationFractionalType"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentationFractionalType/'"/>
<xsl:with-param name="element" select="SegmentationFractionalType"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentationFractionalType/'"/>
<xsl:with-param name="element" select="SegmentationFractionalType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(SegmentationFractionalType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SegmentationFractionalType/value[@number=1] = 'PROBABILITY'">T</xsl:when>
<xsl:when test="SegmentationFractionalType/value[@number=1] = 'OCCUPANCY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: SegmentationImageModule/SegmentationFractionalType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SegmentationFractionalType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SegmentationFractionalType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/MaximumFractionalValue/'"/>
<xsl:with-param name="element" select="MaximumFractionalValue"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="SegmentationType/value = 'FRACTIONAL'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/MaximumFractionalValue/'"/>
<xsl:with-param name="element" select="MaximumFractionalValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/MaximumFractionalValue/'"/>
<xsl:with-param name="element" select="MaximumFractionalValue"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SegmentationImageModule/MaximumFractionalValue/'"/>
<xsl:with-param name="element" select="MaximumFractionalValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/'"/>
<xsl:with-param name="element" select="SegmentSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="SegmentSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SegmentDescriptionMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SegmentDescriptionMacro"/>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/SegmentAlgorithmName/'"/>
<xsl:with-param name="element" select="SegmentAlgorithmName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="SegmentAlgorithmType/value != 'MANUAL'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/SegmentAlgorithmName/'"/>
<xsl:with-param name="element" select="SegmentAlgorithmName"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/SegmentAlgorithmName/'"/>
<xsl:with-param name="element" select="SegmentAlgorithmName"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/SegmentAlgorithmName/'"/>
<xsl:with-param name="element" select="SegmentAlgorithmName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/SegmentationAlgorithmIdentificationSequence/'"/>
<xsl:with-param name="element" select="SegmentationAlgorithmIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SegmentationAlgorithmIdentificationSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: AlgorithmIdentificationMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="AlgorithmIdentificationMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/RecommendedDisplayGrayscaleValue/'"/>
<xsl:with-param name="element" select="RecommendedDisplayGrayscaleValue"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/RecommendedDisplayGrayscaleValue/'"/>
<xsl:with-param name="element" select="RecommendedDisplayGrayscaleValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/RecommendedDisplayCIELabValue/'"/>
<xsl:with-param name="element" select="RecommendedDisplayCIELabValue"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'SegmentationImageModule/SegmentSequence/RecommendedDisplayCIELabValue/'"/>
<xsl:with-param name="element" select="RecommendedDisplayCIELabValue"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="GeneralImageModule">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/InstanceNumber/'"/>
<xsl:with-param name="element" select="InstanceNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(//ImagePositionPatient) = 0 or count(//ImageOrientationPatient) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'GeneralImageModule/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'GeneralImageModule/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralImageModule/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/ContentDate/'"/>
<xsl:with-param name="element" select="ContentDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralImageModule/ContentDate/'"/>
<xsl:with-param name="element" select="ContentDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/ContentTime/'"/>
<xsl:with-param name="element" select="ContentTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralImageModule/ContentTime/'"/>
<xsl:with-param name="element" select="ContentTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/ImageType/'"/>
<xsl:with-param name="element" select="ImageType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=1] = 'ORIGINAL'">T</xsl:when>
<xsl:when test="ImageType/value[@number=1] = 'DERIVED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(ImageType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ImageType/value[@number=2] = 'PRIMARY'">T</xsl:when>
<xsl:when test="ImageType/value[@number=2] = 'SECONDARY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/ImageType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ImageType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="2"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ImageType/value[@number=2]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionNumber/'"/>
<xsl:with-param name="element" select="AcquisitionNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionNumber/'"/>
<xsl:with-param name="element" select="AcquisitionNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionDate/'"/>
<xsl:with-param name="element" select="AcquisitionDate"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionDate/'"/>
<xsl:with-param name="element" select="AcquisitionDate"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionTime/'"/>
<xsl:with-param name="element" select="AcquisitionTime"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionTime/'"/>
<xsl:with-param name="element" select="AcquisitionTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/ReferencedImageSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedImageSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ImageSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImageSOPInstanceReferenceMacro"/>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/ReferencedImageSequence/PurposeOfReferenceCodeSequence/'"/>
<xsl:with-param name="element" select="PurposeOfReferenceCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PurposeOfReferenceCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/DerivationDescription/'"/>
<xsl:with-param name="element" select="DerivationDescription"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/DerivationDescription/'"/>
<xsl:with-param name="element" select="DerivationDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/DerivationCodeSequence/'"/>
<xsl:with-param name="element" select="DerivationCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="DerivationCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/'"/>
<xsl:with-param name="element" select="SourceImageSequence"/>
<xsl:with-param name="vmmin" select="'0'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="SourceImageSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ImageSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImageSOPInstanceReferenceMacro"/>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/PurposeOfReferenceCodeSequence/'"/>
<xsl:with-param name="element" select="PurposeOfReferenceCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PurposeOfReferenceCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/SpatialLocationsPreserved/'"/>
<xsl:with-param name="element" select="SpatialLocationsPreserved"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/SpatialLocationsPreserved/'"/>
<xsl:with-param name="element" select="SpatialLocationsPreserved"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:if test="count(SpatialLocationsPreserved/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SpatialLocationsPreserved/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="SpatialLocationsPreserved/value[@number=1] = 'NO'">T</xsl:when>
<xsl:when test="SpatialLocationsPreserved/value[@number=1] = 'REORIENTED_ONLY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/SourceImageSequence/SpatialLocationsPreserved/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpatialLocationsPreserved"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="SpatialLocationsPreserved/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="SpatialLocationsPreserved/value = 'REORIENTED_ONLY'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'GeneralImageModule/SourceImageSequence/PatientOrientation/'"/>
<xsl:with-param name="element" select="PatientOrientation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/ReferencedInstanceSequence/'"/>
<xsl:with-param name="element" select="ReferencedInstanceSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedInstanceSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/ReferencedInstanceSequence/PurposeOfReferenceCodeSequence/'"/>
<xsl:with-param name="element" select="PurposeOfReferenceCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PurposeOfReferenceCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/ImagesInAcquisition/'"/>
<xsl:with-param name="element" select="ImagesInAcquisition"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/ImagesInAcquisition/'"/>
<xsl:with-param name="element" select="ImagesInAcquisition"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/ImageComments/'"/>
<xsl:with-param name="element" select="ImageComments"/>
<xsl:with-param name="vr" select="'LT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/ImageComments/'"/>
<xsl:with-param name="element" select="ImageComments"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/QualityControlImage/'"/>
<xsl:with-param name="element" select="QualityControlImage"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/QualityControlImage/'"/>
<xsl:with-param name="element" select="QualityControlImage"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(QualityControlImage/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="QualityControlImage/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="QualityControlImage/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/QualityControlImage/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="QualityControlImage"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="QualityControlImage/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/BurnedInAnnotation/'"/>
<xsl:with-param name="element" select="BurnedInAnnotation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(BurnedInAnnotation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="BurnedInAnnotation/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="BurnedInAnnotation/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/BurnedInAnnotation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BurnedInAnnotation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="BurnedInAnnotation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/RecognizableVisualFeatures/'"/>
<xsl:with-param name="element" select="RecognizableVisualFeatures"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/RecognizableVisualFeatures/'"/>
<xsl:with-param name="element" select="RecognizableVisualFeatures"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(RecognizableVisualFeatures/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="RecognizableVisualFeatures/value[@number=1] = 'YES'">T</xsl:when>
<xsl:when test="RecognizableVisualFeatures/value[@number=1] = 'NO'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/RecognizableVisualFeatures/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RecognizableVisualFeatures"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="RecognizableVisualFeatures/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/LossyImageCompression/'"/>
<xsl:with-param name="element" select="LossyImageCompression"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(LossyImageCompression/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="LossyImageCompression/value[@number=1] = '00'">T</xsl:when>
<xsl:when test="LossyImageCompression/value[@number=1] = '01'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/LossyImageCompression/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="LossyImageCompression"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="LossyImageCompression/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/LossyImageCompressionRatio/'"/>
<xsl:with-param name="element" select="LossyImageCompressionRatio"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/LossyImageCompressionMethod/'"/>
<xsl:with-param name="element" select="LossyImageCompressionMethod"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/IconImageSequence/'"/>
<xsl:with-param name="element" select="IconImageSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="IconImageSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ImagePixelMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ImagePixelMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/PresentationLUTShape/'"/>
<xsl:with-param name="element" select="PresentationLUTShape"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(PresentationLUTShape/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PresentationLUTShape/value[@number=1] = 'IDENTITY'">T</xsl:when>
<xsl:when test="PresentationLUTShape/value[@number=1] = 'INVERSE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: GeneralImageModule/PresentationLUTShape/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PresentationLUTShape"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PresentationLUTShape/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'GeneralImageModule/IrradiationEventUID/'"/>
<xsl:with-param name="element" select="IrradiationEventUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'GeneralImageModule/IrradiationEventUID/'"/>
<xsl:with-param name="element" select="IrradiationEventUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'GeneralImageModule/RealWorldValueMappingSequence/'"/>
<xsl:with-param name="element" select="RealWorldValueMappingSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="RealWorldValueMappingSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: RealWorldValueMappingItemMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="RealWorldValueMappingItemMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="ImagePixelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/SamplesPerPixel/'"/>
<xsl:with-param name="element" select="SamplesPerPixel"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'MONOCHROME1' and SamplesPerPixel/value != 1">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 1 when PhotometricInterpretation is MONOCHROME1</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'MONOCHROME2' and SamplesPerPixel/value != 1">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 1 when PhotometricInterpretation is MONOCHROME2</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'PALETTE COLOR' and SamplesPerPixel/value != 1">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 1 when PhotometricInterpretation is PALETTE COLOR</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'RGB' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is RGB</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'HSV' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is HSV</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'ARGB' and SamplesPerPixel/value != 4">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 4 when PhotometricInterpretation is ARGB</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'CMYK' and SamplesPerPixel/value != 4">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 4 when PhotometricInterpretation is CMYK</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'YBR_FULL' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is YBR_FULL</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'YBR_FULL_422' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is YBR_FULL_422</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'YBR_PARTIAL_422' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is YBR_PARTIAL_422</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'YBR_ICT' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is YBR_ICT</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel) &gt; 0">
<xsl:if test="PhotometricInterpretation/value = 'YBR_RCT' and SamplesPerPixel/value != 3">
<xsl:text>Error: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>: Must be 3 when PhotometricInterpretation is YBR_RCT</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(SamplesPerPixel/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="SamplesPerPixel/value[@number=1] = '1'">T</xsl:when>
<xsl:when test="SamplesPerPixel/value[@number=1] = '3'">T</xsl:when>
<xsl:when test="SamplesPerPixel/value[@number=1] = '4'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: ImagePixelMacro/SamplesPerPixel/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SamplesPerPixel"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="SamplesPerPixel/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/PhotometricInterpretation/'"/>
<xsl:with-param name="element" select="PhotometricInterpretation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PhotometricInterpretation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'MONOCHROME1'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'MONOCHROME2'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'RGB'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'HSV'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'ARGB'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'CMYK'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'YBR_FULL'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'YBR_FULL_422'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'YBR_PARTIAL_422'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'YBR_ICT'">T</xsl:when>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'YBR_RCT'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: ImagePixelMacro/PhotometricInterpretation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PhotometricInterpretation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="PhotometricInterpretation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/Rows/'"/>
<xsl:with-param name="element" select="Rows"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/Rows/'"/>
<xsl:with-param name="element" select="Rows"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(Rows) &gt; 0">
<xsl:if test="number(Rows/value)=0">
<xsl:text>Error: ImagePixelMacro/Rows/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Rows"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/Columns/'"/>
<xsl:with-param name="element" select="Columns"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/Columns/'"/>
<xsl:with-param name="element" select="Columns"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(Columns) &gt; 0">
<xsl:if test="number(Columns/value)=0">
<xsl:text>Error: ImagePixelMacro/Columns/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="Columns"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/BitsAllocated/'"/>
<xsl:with-param name="element" select="BitsAllocated"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsAllocated) &gt; 0">
<xsl:if test="number(BitsAllocated/value)=0">
<xsl:text>Error: ImagePixelMacro/BitsAllocated/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsAllocated"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/BitsStored/'"/>
<xsl:with-param name="element" select="BitsStored"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(BitsStored) &gt; 0">
<xsl:if test="number(BitsStored/value)=0">
<xsl:text>Error: ImagePixelMacro/BitsStored/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="BitsStored"/>
</xsl:call-template>
<xsl:text>: value of 0 is illegal</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/HighBit/'"/>
<xsl:with-param name="element" select="HighBit"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/PixelRepresentation/'"/>
<xsl:with-param name="element" select="PixelRepresentation"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/PixelRepresentation/'"/>
<xsl:with-param name="element" select="PixelRepresentation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(PixelRepresentation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PixelRepresentation/value[@number=1] = '0'">T</xsl:when>
<xsl:when test="PixelRepresentation/value[@number=1] = '1'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: ImagePixelMacro/PixelRepresentation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelRepresentation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PixelRepresentation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/PixelData/'"/>
<xsl:with-param name="element" select="PixelData"/>
<xsl:with-param name="vr" select="'OX'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/PixelData/'"/>
<xsl:with-param name="element" select="PixelData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OX'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/PlanarConfiguration/'"/>
<xsl:with-param name="element" select="PlanarConfiguration"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="SamplesPerPixel/value[@number=1] &gt; 1">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/PlanarConfiguration/'"/>
<xsl:with-param name="element" select="PlanarConfiguration"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/PlanarConfiguration/'"/>
<xsl:with-param name="element" select="PlanarConfiguration"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/PlanarConfiguration/'"/>
<xsl:with-param name="element" select="PlanarConfiguration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(PlanarConfiguration/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PlanarConfiguration/value[@number=1] = '0'">T</xsl:when>
<xsl:when test="PlanarConfiguration/value[@number=1] = '1'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: ImagePixelMacro/PlanarConfiguration/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PlanarConfiguration"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PlanarConfiguration/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/PixelAspectRatio/'"/>
<xsl:with-param name="element" select="PixelAspectRatio"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/PixelAspectRatio/'"/>
<xsl:with-param name="element" select="PixelAspectRatio"/>
<xsl:with-param name="vmmin" select="'2'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
			<xsl:if test="count(PixelAspectRatio) &gt; 0">
<xsl:if test="count(//PixelSpacing) &gt; 0 or count(//ImagerPixelSpacing)  &gt; 0 or count(//NominalScannedPixelSpacing) &gt; 0">
<xsl:text>Error: ImagePixelMacro/PixelAspectRatio/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelAspectRatio"/>
</xsl:call-template>
<xsl:text>: PixelAspectRatio forbidden when PixelSpacing attributes used</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/SmallestImagePixelValue/'"/>
<xsl:with-param name="element" select="SmallestImagePixelValue"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/SmallestImagePixelValue/'"/>
<xsl:with-param name="element" select="SmallestImagePixelValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/LargestImagePixelValue/'"/>
<xsl:with-param name="element" select="LargestImagePixelValue"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'ImagePixelMacro/LargestImagePixelValue/'"/>
<xsl:with-param name="element" select="LargestImagePixelValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR' or PixelPresentation/value[@number=1] = 'COLOR' or PixelPresentation/value[@number=1] = 'MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
			<xsl:if test="count(RedPaletteColorLookupTableDescriptor) &gt; 0">
<xsl:if test="RedPaletteColorLookupTableDescriptor/value[@number=1] != GreenPaletteColorLookupTableDescriptor/value[@number=1]">
<xsl:text>Error: ImagePixelMacro/RedPaletteColorLookupTableDescriptor/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
<xsl:text>: PaletteColorLookupTableDescriptor values do not match - value 1 red != green</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RedPaletteColorLookupTableDescriptor) &gt; 0">
<xsl:if test="RedPaletteColorLookupTableDescriptor/value[@number=1] != BluePaletteColorLookupTableDescriptor/value[@number=1]">
<xsl:text>Error: ImagePixelMacro/RedPaletteColorLookupTableDescriptor/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
<xsl:text>: PaletteColorLookupTableDescriptor values do not match - value 1 red != blue</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RedPaletteColorLookupTableDescriptor) &gt; 0">
<xsl:if test="RedPaletteColorLookupTableDescriptor/value[@number=2] != GreenPaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: ImagePixelMacro/RedPaletteColorLookupTableDescriptor/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
<xsl:text>: PaletteColorLookupTableDescriptor values do not match - value 2 red != green</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RedPaletteColorLookupTableDescriptor) &gt; 0">
<xsl:if test="RedPaletteColorLookupTableDescriptor/value[@number=2] != BluePaletteColorLookupTableDescriptor/value[@number=2]">
<xsl:text>Error: ImagePixelMacro/RedPaletteColorLookupTableDescriptor/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
<xsl:text>: PaletteColorLookupTableDescriptor values do not match - value 2 red != blue</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RedPaletteColorLookupTableDescriptor) &gt; 0">
<xsl:if test="RedPaletteColorLookupTableDescriptor/value[@number=3] != GreenPaletteColorLookupTableDescriptor/value[@number=3]">
<xsl:text>Error: ImagePixelMacro/RedPaletteColorLookupTableDescriptor/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
<xsl:text>: PaletteColorLookupTableDescriptor values do not match - value 3 red != green</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(RedPaletteColorLookupTableDescriptor) &gt; 0">
<xsl:if test="RedPaletteColorLookupTableDescriptor/value[@number=3] != BluePaletteColorLookupTableDescriptor/value[@number=3]">
<xsl:text>Error: ImagePixelMacro/RedPaletteColorLookupTableDescriptor/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="RedPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
<xsl:text>: PaletteColorLookupTableDescriptor values do not match - value 3 red != blue</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR' or PixelPresentation/value[@number=1] = 'COLOR' or PixelPresentation/value[@number=1] = 'MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableDescriptor"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR' or PixelPresentation/value[@number=1] = 'COLOR' or PixelPresentation/value[@number=1] = 'MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableDescriptor"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableDescriptor"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableDescriptor/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableDescriptor"/>
<xsl:with-param name="vmmin" select="'3'"/>
<xsl:with-param name="vmmax" select="'3'"/>
<xsl:with-param name="vr" select="'XS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableData"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR' or PixelPresentation/value[@number=1] = 'COLOR' or PixelPresentation/value[@number=1] = 'MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableData"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableData"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/RedPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="RedPaletteColorLookupTableData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableData"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR' or PixelPresentation/value[@number=1] = 'COLOR' or PixelPresentation/value[@number=1] = 'MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableData"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableData"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/GreenPaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="GreenPaletteColorLookupTableData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableData"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="PhotometricInterpretation/value[@number=1] = 'PALETTE COLOR' or PixelPresentation/value[@number=1] = 'COLOR' or PixelPresentation/value[@number=1] = 'MIXED'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableData"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableData"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImagePixelMacro/BluePaletteColorLookupTableData/'"/>
<xsl:with-param name="element" select="BluePaletteColorLookupTableData"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OW'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="DigitalSignaturesMacro">
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/'"/>
<xsl:with-param name="element" select="MACParametersSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="MACParametersSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACIDNumber/'"/>
<xsl:with-param name="element" select="MACIDNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACIDNumber/'"/>
<xsl:with-param name="element" select="MACIDNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACCalculationTransferSyntaxUID/'"/>
<xsl:with-param name="element" select="MACCalculationTransferSyntaxUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACCalculationTransferSyntaxUID/'"/>
<xsl:with-param name="element" select="MACCalculationTransferSyntaxUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACAlgorithm/'"/>
<xsl:with-param name="element" select="MACAlgorithm"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACAlgorithm/'"/>
<xsl:with-param name="element" select="MACAlgorithm"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
				<xsl:if test="count(MACAlgorithm/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MACAlgorithm/value[@number=1] = 'RIPEMD160'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'MD5'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'SHA'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: DigitalSignaturesMacro/MACParametersSequence/MACAlgorithm/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MACAlgorithm"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="MACAlgorithm/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/DataElementsSigned/'"/>
<xsl:with-param name="element" select="DataElementsSigned"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/DataElementsSigned/'"/>
<xsl:with-param name="element" select="DataElementsSigned"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/'"/>
<xsl:with-param name="element" select="MACParametersSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="MACParametersSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACIDNumber/'"/>
<xsl:with-param name="element" select="MACIDNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/MACIDNumber/'"/>
<xsl:with-param name="element" select="MACIDNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/DigitalSignatureUID/'"/>
<xsl:with-param name="element" select="DigitalSignatureUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/DigitalSignatureUID/'"/>
<xsl:with-param name="element" select="DigitalSignatureUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/DigitalSignatureDateTime/'"/>
<xsl:with-param name="element" select="DigitalSignatureDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/DigitalSignatureDateTime/'"/>
<xsl:with-param name="element" select="DigitalSignatureDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertificateType/'"/>
<xsl:with-param name="element" select="CertificateType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertificateType/'"/>
<xsl:with-param name="element" select="CertificateType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertificateOfSigner/'"/>
<xsl:with-param name="element" select="CertificateOfSigner"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertificateOfSigner/'"/>
<xsl:with-param name="element" select="CertificateOfSigner"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/Signature/'"/>
<xsl:with-param name="element" select="Signature"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/Signature/'"/>
<xsl:with-param name="element" select="Signature"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestampType/'"/>
<xsl:with-param name="element" select="CertifiedTimestampType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(CertifiedTimestamp) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestampType/'"/>
<xsl:with-param name="element" select="CertifiedTimestampType"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestampType/'"/>
<xsl:with-param name="element" select="CertifiedTimestampType"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestampType/'"/>
<xsl:with-param name="element" select="CertifiedTimestampType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
				<xsl:if test="count(CertifiedTimestampType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="CertifiedTimestampType/value[@number=1] = 'CMS_TSP'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestampType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="CertifiedTimestampType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="CertifiedTimestampType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestamp/'"/>
<xsl:with-param name="element" select="CertifiedTimestamp"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'DigitalSignaturesMacro/MACParametersSequence/CertifiedTimestamp/'"/>
<xsl:with-param name="element" select="CertifiedTimestamp"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="MRImageAndMRSpectroscopyInstanceMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionNumber/'"/>
<xsl:with-param name="element" select="AcquisitionNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionNumber/'"/>
<xsl:with-param name="element" select="AcquisitionNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDateTime/'"/>
<xsl:with-param name="element" select="AcquisitionDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDuration/'"/>
<xsl:with-param name="element" select="AcquisitionDuration"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'FD'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionDuration) &gt; 0">
<xsl:if test="number(AcquisitionDuration/value)=0">
<xsl:text>Warning: MRImageAndMRSpectroscopyInstanceMacro/AcquisitionDuration/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionDuration"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ReferencedRawDataSequence/'"/>
<xsl:with-param name="element" select="ReferencedRawDataSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedRawDataSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ReferencedWaveformSequence/'"/>
<xsl:with-param name="element" select="ReferencedWaveformSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedWaveformSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:choose>
<xsl:when test="count(//ReferencedImageSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ReferencedImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageEvidenceSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ReferencedImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageEvidenceSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ReferencedImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="ReferencedImageEvidenceSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedImageEvidenceSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:choose>
<xsl:when test="count(//SourceImageSequence) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/SourceImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="SourceImageEvidenceSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/SourceImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="SourceImageEvidenceSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/SourceImageEvidenceSequence/'"/>
<xsl:with-param name="element" select="SourceImageEvidenceSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="SourceImageEvidenceSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ReferencedPresentationStateSequence/'"/>
<xsl:with-param name="element" select="ReferencedPresentationStateSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedPresentationStateSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSOPInstanceReferenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ContentQualification/'"/>
<xsl:with-param name="element" select="ContentQualification"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ContentQualification/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ContentQualification/value[@number=1] = 'PRODUCT'">T</xsl:when>
<xsl:when test="ContentQualification/value[@number=1] = 'RESEARCH'">T</xsl:when>
<xsl:when test="ContentQualification/value[@number=1] = 'SERVICE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRImageAndMRSpectroscopyInstanceMacro/ContentQualification/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContentQualification"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ContentQualification/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ResonantNucleus/'"/>
<xsl:with-param name="element" select="ResonantNucleus"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ResonantNucleus/'"/>
<xsl:with-param name="element" select="ResonantNucleus"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ResonantNucleus/'"/>
<xsl:with-param name="element" select="ResonantNucleus"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ResonantNucleus/'"/>
<xsl:with-param name="element" select="ResonantNucleus"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ResonantNucleus/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ResonantNucleus/value[@number=1] = '1H'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '3HE'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '7LI'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '13C'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '19F'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '23NA'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '31P'">T</xsl:when>
<xsl:when test="ResonantNucleus/value[@number=1] = '129XE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageAndMRSpectroscopyInstanceMacro/ResonantNucleus/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ResonantNucleus"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ResonantNucleus/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/KSpaceFiltering/'"/>
<xsl:with-param name="element" select="KSpaceFiltering"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/KSpaceFiltering/'"/>
<xsl:with-param name="element" select="KSpaceFiltering"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/KSpaceFiltering/'"/>
<xsl:with-param name="element" select="KSpaceFiltering"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/KSpaceFiltering/'"/>
<xsl:with-param name="element" select="KSpaceFiltering"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(KSpaceFiltering/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'COSINE'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'COSINE_SQUARED'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'FERMI'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'GAUSSIAN'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'HAMMING'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'HANNING'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'LORENTZIAN'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'LRNTZ_GSS_TRNSFM'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'RIESZ'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'TUKEY'">T</xsl:when>
<xsl:when test="KSpaceFiltering/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageAndMRSpectroscopyInstanceMacro/KSpaceFiltering/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="KSpaceFiltering"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="KSpaceFiltering/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/MagneticFieldStrength/'"/>
<xsl:with-param name="element" select="MagneticFieldStrength"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(ImageType/value[@number=1]='ORIGINAL' or ImageType/value[@number=1]='MIXED') and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/MagneticFieldStrength/'"/>
<xsl:with-param name="element" select="MagneticFieldStrength"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/MagneticFieldStrength/'"/>
<xsl:with-param name="element" select="MagneticFieldStrength"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/MagneticFieldStrength/'"/>
<xsl:with-param name="element" select="MagneticFieldStrength"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardAgency/'"/>
<xsl:with-param name="element" select="ApplicableSafetyStandardAgency"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardAgency/'"/>
<xsl:with-param name="element" select="ApplicableSafetyStandardAgency"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardAgency/'"/>
<xsl:with-param name="element" select="ApplicableSafetyStandardAgency"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardAgency/'"/>
<xsl:with-param name="element" select="ApplicableSafetyStandardAgency"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ApplicableSafetyStandardAgency/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ApplicableSafetyStandardAgency/value[@number=1] = 'IEC'">T</xsl:when>
<xsl:when test="ApplicableSafetyStandardAgency/value[@number=1] = 'FDA'">T</xsl:when>
<xsl:when test="ApplicableSafetyStandardAgency/value[@number=1] = 'MHW'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardAgency/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ApplicableSafetyStandardAgency"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ApplicableSafetyStandardAgency/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardDescription/'"/>
<xsl:with-param name="element" select="ApplicableSafetyStandardDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ApplicableSafetyStandardDescription/'"/>
<xsl:with-param name="element" select="ApplicableSafetyStandardDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1C'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ImageComments/'"/>
<xsl:with-param name="element" select="ImageComments"/>
<xsl:with-param name="vr" select="'LT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'MRImageAndMRSpectroscopyInstanceMacro/ImageComments/'"/>
<xsl:with-param name="element" select="ImageComments"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="CommonCTMRImageDescriptionAtImageLevelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtImageLevelMacro/PixelPresentation/'"/>
<xsl:with-param name="element" select="PixelPresentation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtImageLevelMacro/PixelPresentation/'"/>
<xsl:with-param name="element" select="PixelPresentation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PixelPresentation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PixelPresentation/value[@number=1] = 'COLOR'">T</xsl:when>
<xsl:when test="PixelPresentation/value[@number=1] = 'MONOCHROME'">T</xsl:when>
<xsl:when test="PixelPresentation/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CommonCTMRImageDescriptionAtImageLevelMacro/PixelPresentation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelPresentation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PixelPresentation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtImageLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtImageLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumetricProperties/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumetricProperties/value[@number=1] = 'VOLUME'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'SAMPLED'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'DISTORTED'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CommonCTMRImageDescriptionAtImageLevelMacro/VolumetricProperties/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumetricProperties"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="VolumetricProperties/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumeBasedCalculationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MAX_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MIN_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'VOLUME_RENDER'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'SURFACE_RENDER'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MPR'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'CURVED_MPR'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: CommonCTMRImageDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeBasedCalculationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="VolumeBasedCalculationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(VolumeBasedCalculationTechnique) &gt; 0">
<xsl:if test="ImageType/value[@number=1]='ORIGINAL' and VolumeBasedCalculationTechnique/value[@number=1]!='NONE'">
<xsl:text>Error: CommonCTMRImageDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeBasedCalculationTechnique"/>
</xsl:call-template>
<xsl:text>: must be NONE when ImageType value 1 is ORIGINAL</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="MRImageDescriptionAtImageLevelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ComplexImageComponent/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'MAGNITUDE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'PHASE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'REAL'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'IMAGINARY'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageDescriptionAtImageLevelMacro/ComplexImageComponent/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ComplexImageComponent"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ComplexImageComponent/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageDescriptionAtImageLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'DIFFUSION'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'FLOW_ENCODED'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'FLUID_ATTENUATED'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'PERFUSION'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'PROTON_DENSITY'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'STIR'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'TAGGING'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T1'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T2'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T2_STAR'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'TOF'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'UNKNOWN'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageDescriptionAtImageLevelMacro/AcquisitionContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="AcquisitionContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="CommonCTMRImageDescriptionAtFrameLevelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtFrameLevelMacro/PixelPresentation/'"/>
<xsl:with-param name="element" select="PixelPresentation"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtFrameLevelMacro/PixelPresentation/'"/>
<xsl:with-param name="element" select="PixelPresentation"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(PixelPresentation/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PixelPresentation/value[@number=1] = 'COLOR'">T</xsl:when>
<xsl:when test="PixelPresentation/value[@number=1] = 'MONOCHROME'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CommonCTMRImageDescriptionAtFrameLevelMacro/PixelPresentation/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelPresentation"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="PixelPresentation/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtFrameLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtFrameLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumetricProperties/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumetricProperties/value[@number=1] = 'VOLUME'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'SAMPLED'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'DISTORTED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CommonCTMRImageDescriptionAtFrameLevelMacro/VolumetricProperties/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumetricProperties"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="VolumetricProperties/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CommonCTMRImageDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumeBasedCalculationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MAX_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MIN_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'VOLUME_RENDER'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'SURFACE_RENDER'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MPR'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'CURVED_MPR'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: CommonCTMRImageDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeBasedCalculationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="VolumeBasedCalculationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			<xsl:if test="count(VolumeBasedCalculationTechnique) &gt; 0">
<xsl:if test="FrameType/value[@number=1]='ORIGINAL' and VolumeBasedCalculationTechnique/value[@number=1]!='NONE'">
<xsl:text>Error: CommonCTMRImageDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeBasedCalculationTechnique"/>
</xsl:call-template>
<xsl:text>: must be NONE when FrameType value 1 is ORIGINAL</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="MRImageDescriptionAtFrameLevelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ComplexImageComponent/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'MAGNITUDE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'PHASE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'REAL'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'IMAGINARY'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageDescriptionAtFrameLevelMacro/ComplexImageComponent/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ComplexImageComponent"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ComplexImageComponent/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'MRImageDescriptionAtFrameLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'DIFFUSION'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'FLOW_ENCODED'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'FLUID_ATTENUATED'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'PERFUSION'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'PROTON_DENSITY'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'STIR'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'TAGGING'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T1'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T2'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T2_STAR'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'TOF'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'UNKNOWN'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRImageDescriptionAtFrameLevelMacro/AcquisitionContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="AcquisitionContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="MRSpectroscopyDescriptionAtImageLevelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumetricProperties/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumetricProperties/value[@number=1] = 'VOLUME'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'SAMPLED'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'DISTORTED'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyDescriptionAtImageLevelMacro/VolumetricProperties/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumetricProperties"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="VolumetricProperties/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumeBasedCalculationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MAX_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MIN_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyDescriptionAtImageLevelMacro/VolumeBasedCalculationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeBasedCalculationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="VolumeBasedCalculationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ComplexImageComponent/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'MAGNITUDE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'PHASE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'REAL'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'IMAGINARY'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'COMPLEX'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyDescriptionAtImageLevelMacro/ComplexImageComponent/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ComplexImageComponent"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ComplexImageComponent/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtImageLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'PROTON_DENSITY'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T1'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T2'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'UNKNOWN'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'MIXED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyDescriptionAtImageLevelMacro/AcquisitionContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="AcquisitionContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="MRSpectroscopyDescriptionAtFrameLevelMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/VolumetricProperties/'"/>
<xsl:with-param name="element" select="VolumetricProperties"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumetricProperties/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumetricProperties/value[@number=1] = 'VOLUME'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'SAMPLED'">T</xsl:when>
<xsl:when test="VolumetricProperties/value[@number=1] = 'DISTORTED'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: MRSpectroscopyDescriptionAtFrameLevelMacro/VolumetricProperties/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumetricProperties"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="VolumetricProperties/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/'"/>
<xsl:with-param name="element" select="VolumeBasedCalculationTechnique"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(VolumeBasedCalculationTechnique/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MAX_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'MIN_IP'">T</xsl:when>
<xsl:when test="VolumeBasedCalculationTechnique/value[@number=1] = 'NONE'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyDescriptionAtFrameLevelMacro/VolumeBasedCalculationTechnique/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="VolumeBasedCalculationTechnique"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="VolumeBasedCalculationTechnique/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/ComplexImageComponent/'"/>
<xsl:with-param name="element" select="ComplexImageComponent"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ComplexImageComponent/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'MAGNITUDE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'PHASE'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'REAL'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'IMAGINARY'">T</xsl:when>
<xsl:when test="ComplexImageComponent/value[@number=1] = 'COMPLEX'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyDescriptionAtFrameLevelMacro/ComplexImageComponent/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ComplexImageComponent"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ComplexImageComponent/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'MRSpectroscopyDescriptionAtFrameLevelMacro/AcquisitionContrast/'"/>
<xsl:with-param name="element" select="AcquisitionContrast"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(AcquisitionContrast/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'PROTON_DENSITY'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T1'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'T2'">T</xsl:when>
<xsl:when test="AcquisitionContrast/value[@number=1] = 'UNKNOWN'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: MRSpectroscopyDescriptionAtFrameLevelMacro/AcquisitionContrast/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="AcquisitionContrast"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="AcquisitionContrast/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="ImageSOPInstanceReferenceMacro">
		<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImageSOPInstanceReferenceMacro/ReferencedFrameNumber/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumber"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImageSOPInstanceReferenceMacro/ReferencedFrameNumber/'"/>
<xsl:with-param name="element" select="ReferencedFrameNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'IS'"/>
</xsl:call-template>
			<xsl:if test="count(ReferencedFrameNumber) &gt; 0">
<xsl:if test="count(ReferencedSegmentNumber) &gt; 0">
<xsl:text>Error: ImageSOPInstanceReferenceMacro/ReferencedFrameNumber/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ReferencedFrameNumber"/>
</xsl:call-template>
<xsl:text>: ReferencedFrameNumber may not be present when ReferencedSegmentNumber is present</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ImageSOPInstanceReferenceMacro/ReferencedSegmentNumber/'"/>
<xsl:with-param name="element" select="ReferencedSegmentNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ImageSOPInstanceReferenceMacro/ReferencedSegmentNumber/'"/>
<xsl:with-param name="element" select="ReferencedSegmentNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
			<xsl:if test="count(ReferencedSegmentNumber) &gt; 0">
<xsl:if test="count(ReferencedSegmentNumber) &gt; 0">
<xsl:text>Error: ImageSOPInstanceReferenceMacro/ReferencedSegmentNumber/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ReferencedSegmentNumber"/>
</xsl:call-template>
<xsl:text>: ReferencedSegmentNumber may not be present when ReferencedFrameNumber is present</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="SOPInstanceReferenceMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPInstanceReferenceMacro/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPInstanceReferenceMacro/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'SOPInstanceReferenceMacro/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'SOPInstanceReferenceMacro/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="HierarchicalSOPInstanceReferenceMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSOPInstanceReferenceMacro/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSOPInstanceReferenceMacro/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'HierarchicalSOPInstanceReferenceMacro/ReferencedSeriesSequence/'"/>
<xsl:with-param name="element" select="ReferencedSeriesSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedSeriesSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HierarchicalSeriesReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HierarchicalSeriesReferenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="HierarchicalSeriesReferenceMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/SeriesInstanceUID/'"/>
<xsl:with-param name="element" select="SeriesInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/SeriesInstanceUID/'"/>
<xsl:with-param name="element" select="SeriesInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/RetrieveAETitle/'"/>
<xsl:with-param name="element" select="RetrieveAETitle"/>
<xsl:with-param name="vr" select="'AE'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/RetrieveAETitle/'"/>
<xsl:with-param name="element" select="RetrieveAETitle"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/RetrieveLocationUID/'"/>
<xsl:with-param name="element" select="RetrieveLocationUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/RetrieveLocationUID/'"/>
<xsl:with-param name="element" select="RetrieveLocationUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/StorageMediaFileSetID/'"/>
<xsl:with-param name="element" select="StorageMediaFileSetID"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/StorageMediaFileSetID/'"/>
<xsl:with-param name="element" select="StorageMediaFileSetID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/StorageMediaFileSetUID/'"/>
<xsl:with-param name="element" select="StorageMediaFileSetUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/StorageMediaFileSetUID/'"/>
<xsl:with-param name="element" select="StorageMediaFileSetUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/'"/>
<xsl:with-param name="element" select="ReferencedSOPSequence"/>
<xsl:with-param name="vmmin" select="''"/>
<xsl:with-param name="vmmax" select="''"/>
</xsl:call-template>
<xsl:for-each select="ReferencedSOPSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: SOPInstanceReferenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="SOPInstanceReferenceMacro"/>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/PurposeOfReferenceCodeSequence/'"/>
<xsl:with-param name="element" select="PurposeOfReferenceCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PurposeOfReferenceCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/'"/>
<xsl:with-param name="element" select="ReferencedDigitalSignaturesSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedDigitalSignaturesSequence/Item">
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/DigitalSignatureUID/'"/>
<xsl:with-param name="element" select="DigitalSignatureUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/DigitalSignatureUID/'"/>
<xsl:with-param name="element" select="DigitalSignatureUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
				<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/Signature/'"/>
<xsl:with-param name="element" select="Signature"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/Signature/'"/>
<xsl:with-param name="element" select="Signature"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
				<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceMACSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedSOPInstanceMACSequence/Item">
					<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MACCalculationTransferSyntaxUID/'"/>
<xsl:with-param name="element" select="MACCalculationTransferSyntaxUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MACCalculationTransferSyntaxUID/'"/>
<xsl:with-param name="element" select="MACCalculationTransferSyntaxUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
					<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MACAlgorithm/'"/>
<xsl:with-param name="element" select="MACAlgorithm"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MACAlgorithm/'"/>
<xsl:with-param name="element" select="MACAlgorithm"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
						<xsl:if test="count(MACAlgorithm/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="MACAlgorithm/value[@number=1] = 'RIPEMD160'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'MD5'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'SHA1'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'SHA256'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'SHA384'">T</xsl:when>
<xsl:when test="MACAlgorithm/value[@number=1] = 'SHA512'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MACAlgorithm/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="MACAlgorithm"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="MACAlgorithm/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
					
					<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/DataElementsSigned/'"/>
<xsl:with-param name="element" select="DataElementsSigned"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/DataElementsSigned/'"/>
<xsl:with-param name="element" select="DataElementsSigned"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
<xsl:with-param name="vr" select="'AT'"/>
</xsl:call-template>
					<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MAC/'"/>
<xsl:with-param name="element" select="MAC"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'HierarchicalSeriesReferenceMacro/ReferencedSOPSequence/ReferencedDigitalSignaturesSequence/ReferencedSOPInstanceMACSequence/MAC/'"/>
<xsl:with-param name="element" select="MAC"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'OB'"/>
</xsl:call-template>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="CodeSequenceMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodeValue/'"/>
<xsl:with-param name="element" select="CodeValue"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodeValue/'"/>
<xsl:with-param name="element" select="CodeValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodingSchemeDesignator/'"/>
<xsl:with-param name="element" select="CodingSchemeDesignator"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodingSchemeDesignator/'"/>
<xsl:with-param name="element" select="CodingSchemeDesignator"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodingSchemeVersion/'"/>
<xsl:with-param name="element" select="CodingSchemeVersion"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="CodingSchemeDesignator/value[@number=1]='BI'      or CodingSchemeDesignator/value[@number=1]='SCPECG'      or CodingSchemeDesignator/value[@number=1]='BARI'      or CodingSchemeDesignator/value[@number=1]='UCUM'      or CodingSchemeDesignator/value[@number=1]='NCDR'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodingSchemeVersion/'"/>
<xsl:with-param name="element" select="CodingSchemeVersion"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodingSchemeVersion/'"/>
<xsl:with-param name="element" select="CodingSchemeVersion"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodingSchemeVersion/'"/>
<xsl:with-param name="element" select="CodingSchemeVersion"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodeMeaning/'"/>
<xsl:with-param name="element" select="CodeMeaning"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'CodeSequenceMacro/CodeMeaning/'"/>
<xsl:with-param name="element" select="CodeMeaning"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextIdentifier/'"/>
<xsl:with-param name="element" select="ContextIdentifier"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextIdentifier/'"/>
<xsl:with-param name="element" select="ContextIdentifier"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/MappingResource/'"/>
<xsl:with-param name="element" select="MappingResource"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ContextIdentifier) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/MappingResource/'"/>
<xsl:with-param name="element" select="MappingResource"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/MappingResource/'"/>
<xsl:with-param name="element" select="MappingResource"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CodeSequenceMacro/MappingResource/'"/>
<xsl:with-param name="element" select="MappingResource"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupVersion/'"/>
<xsl:with-param name="element" select="ContextGroupVersion"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(ContextIdentifier) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupVersion/'"/>
<xsl:with-param name="element" select="ContextGroupVersion"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupVersion/'"/>
<xsl:with-param name="element" select="ContextGroupVersion"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupVersion/'"/>
<xsl:with-param name="element" select="ContextGroupVersion"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupExtensionFlag/'"/>
<xsl:with-param name="element" select="ContextGroupExtensionFlag"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupExtensionFlag/'"/>
<xsl:with-param name="element" select="ContextGroupExtensionFlag"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="count(ContextGroupExtensionFlag/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ContextGroupExtensionFlag/value[@number=1] = 'Y'">T</xsl:when>
<xsl:when test="ContextGroupExtensionFlag/value[@number=1] = 'N'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Error: CodeSequenceMacro/ContextGroupExtensionFlag/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ContextGroupExtensionFlag"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized enumerated value :</xsl:text>
<xsl:value-of select="ContextGroupExtensionFlag/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupLocalVersion/'"/>
<xsl:with-param name="element" select="ContextGroupLocalVersion"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ContextGroupExtensionFlag/value[@number=1]='Y'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupLocalVersion/'"/>
<xsl:with-param name="element" select="ContextGroupLocalVersion"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupLocalVersion/'"/>
<xsl:with-param name="element" select="ContextGroupLocalVersion"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupLocalVersion/'"/>
<xsl:with-param name="element" select="ContextGroupLocalVersion"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupExtensionCreatorUID/'"/>
<xsl:with-param name="element" select="ContextGroupExtensionCreatorUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ContextGroupExtensionFlag/value[@number=1]='Y'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupExtensionCreatorUID/'"/>
<xsl:with-param name="element" select="ContextGroupExtensionCreatorUID"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupExtensionCreatorUID/'"/>
<xsl:with-param name="element" select="ContextGroupExtensionCreatorUID"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'CodeSequenceMacro/ContextGroupExtensionCreatorUID/'"/>
<xsl:with-param name="element" select="ContextGroupExtensionCreatorUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
	</xsl:template>
<xsl:template name="PersonIdentificationMacro">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'PersonIdentificationMacro/PersonIdentificationCodeSequence/'"/>
<xsl:with-param name="element" select="PersonIdentificationCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="PersonIdentificationCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PersonIdentificationMacro/PersonAddress/'"/>
<xsl:with-param name="element" select="PersonAddress"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PersonIdentificationMacro/PersonAddress/'"/>
<xsl:with-param name="element" select="PersonAddress"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PersonIdentificationMacro/PersonTelephoneNumbers/'"/>
<xsl:with-param name="element" select="PersonTelephoneNumbers"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PersonIdentificationMacro/PersonTelephoneNumbers/'"/>
<xsl:with-param name="element" select="PersonTelephoneNumbers"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(InstitutionCodeSequence) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionName/'"/>
<xsl:with-param name="element" select="InstitutionName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionAddress/'"/>
<xsl:with-param name="element" select="InstitutionAddress"/>
<xsl:with-param name="vr" select="'ST'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionAddress/'"/>
<xsl:with-param name="element" select="InstitutionAddress"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:choose>
<xsl:when test="count(InstitutionName) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionCodeSequence/'"/>
<xsl:with-param name="element" select="InstitutionCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionCodeSequence/'"/>
<xsl:with-param name="element" select="InstitutionCodeSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'PersonIdentificationMacro/InstitutionCodeSequence/'"/>
<xsl:with-param name="element" select="InstitutionCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="InstitutionCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="ContentItemMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/ValueType/'"/>
<xsl:with-param name="element" select="ValueType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'ContentItemMacro/ValueType/'"/>
<xsl:with-param name="element" select="ValueType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(ValueType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="ValueType/value[@number=1] = 'DATETIME'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'DATE'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'TIME'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'PNAME'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'UIDREF'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'TEXT'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'CODE'">T</xsl:when>
<xsl:when test="ValueType/value[@number=1] = 'NUMERIC'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: ContentItemMacro/ValueType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="ValueType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="ValueType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'ContentItemMacro/ConceptNameCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptNameCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ConceptNameCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/DateTime/'"/>
<xsl:with-param name="element" select="DateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='DATETIME'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/DateTime/'"/>
<xsl:with-param name="element" select="DateTime"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/DateTime/'"/>
<xsl:with-param name="element" select="DateTime"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/DateTime/'"/>
<xsl:with-param name="element" select="DateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/Date/'"/>
<xsl:with-param name="element" select="Date"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='DATE'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/Date/'"/>
<xsl:with-param name="element" select="Date"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/Date/'"/>
<xsl:with-param name="element" select="Date"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/Date/'"/>
<xsl:with-param name="element" select="Date"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DA'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/Time/'"/>
<xsl:with-param name="element" select="Time"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='TIME'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/Time/'"/>
<xsl:with-param name="element" select="Time"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/Time/'"/>
<xsl:with-param name="element" select="Time"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/Time/'"/>
<xsl:with-param name="element" select="Time"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'TM'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='PNAME'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/PersonName/'"/>
<xsl:with-param name="element" select="PersonName"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'PN'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/UID/'"/>
<xsl:with-param name="element" select="UID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='UIDREF'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/UID/'"/>
<xsl:with-param name="element" select="UID"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/UID/'"/>
<xsl:with-param name="element" select="UID"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/UID/'"/>
<xsl:with-param name="element" select="UID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='TEXT'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/TextValue/'"/>
<xsl:with-param name="element" select="TextValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
		<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='CODE'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/ConceptNameCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptNameCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/ConceptNameCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptNameCodeSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/ConceptNameCodeSequence/'"/>
<xsl:with-param name="element" select="ConceptNameCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ConceptNameCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'ContentItemMacro/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='NUMERIC'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/NumericValue/'"/>
<xsl:with-param name="element" select="NumericValue"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
		<xsl:choose>
<xsl:when test="ValueType/value[@number=1]='NUMERIC'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/MeasurementUnitsCodeSequence/'"/>
<xsl:with-param name="element" select="MeasurementUnitsCodeSequence"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'ContentItemMacro/MeasurementUnitsCodeSequence/'"/>
<xsl:with-param name="element" select="MeasurementUnitsCodeSequence"/>
<xsl:with-param name="mbpo" select="'F'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CSequenceAttributeRegardless">
<xsl:with-param name="description" select="'ContentItemMacro/MeasurementUnitsCodeSequence/'"/>
<xsl:with-param name="element" select="MeasurementUnitsCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="MeasurementUnitsCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="RequestAttributesMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/RequestedProcedureID/'"/>
<xsl:with-param name="element" select="RequestedProcedureID"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'RequestAttributesMacro/RequestedProcedureID/'"/>
<xsl:with-param name="element" select="RequestedProcedureID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/AccessionNumber/'"/>
<xsl:with-param name="element" select="AccessionNumber"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/AccessionNumber/'"/>
<xsl:with-param name="element" select="AccessionNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/IssuerOfAccessionNumberSequence/'"/>
<xsl:with-param name="element" select="IssuerOfAccessionNumberSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="IssuerOfAccessionNumberSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HL7v2HierarchicDesignatorMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HL7v2HierarchicDesignatorMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/StudyInstanceUID/'"/>
<xsl:with-param name="element" select="StudyInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReferencedStudySequence/'"/>
<xsl:with-param name="element" select="ReferencedStudySequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ReferencedStudySequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReferencedStudySequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReferencedStudySequence/ReferencedSOPClassUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPClassUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReferencedStudySequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReferencedStudySequence/ReferencedSOPInstanceUID/'"/>
<xsl:with-param name="element" select="ReferencedSOPInstanceUID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UI'"/>
</xsl:call-template>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/RequestedProcedureDescription/'"/>
<xsl:with-param name="element" select="RequestedProcedureDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/RequestedProcedureDescription/'"/>
<xsl:with-param name="element" select="RequestedProcedureDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/RequestedProcedureCodeSequence/'"/>
<xsl:with-param name="element" select="RequestedProcedureCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="RequestedProcedureCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReasonForTheRequestedProcedure/'"/>
<xsl:with-param name="element" select="ReasonForTheRequestedProcedure"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReasonForTheRequestedProcedure/'"/>
<xsl:with-param name="element" select="ReasonForTheRequestedProcedure"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ReasonForRequestedProcedureCodeSequence/'"/>
<xsl:with-param name="element" select="ReasonForRequestedProcedureCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="ReasonForRequestedProcedureCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProcedureStepID/'"/>
<xsl:with-param name="element" select="ScheduledProcedureStepID"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProcedureStepID/'"/>
<xsl:with-param name="element" select="ScheduledProcedureStepID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'SH'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProcedureStepDescription/'"/>
<xsl:with-param name="element" select="ScheduledProcedureStepDescription"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProcedureStepDescription/'"/>
<xsl:with-param name="element" select="ScheduledProcedureStepDescription"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProtocolCodeSequence/'"/>
<xsl:with-param name="element" select="ScheduledProtocolCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ScheduledProtocolCodeSequence/Item">
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProtocolCodeSequence/ProtocolContextSequence/'"/>
<xsl:with-param name="element" select="ProtocolContextSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ProtocolContextSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ContentItemMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContentItemMacro"/>
				<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'RequestAttributesMacro/ScheduledProtocolCodeSequence/ProtocolContextSequence/ContentItemModifierSequence/'"/>
<xsl:with-param name="element" select="ContentItemModifierSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="ContentItemModifierSequence/Item">
					<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: ContentItemMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="ContentItemMacro"/>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="HL7v2HierarchicDesignatorMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/LocalNamespaceEntityID/'"/>
<xsl:with-param name="element" select="LocalNamespaceEntityID"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(UniversalEntityID) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/LocalNamespaceEntityID/'"/>
<xsl:with-param name="element" select="LocalNamespaceEntityID"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/LocalNamespaceEntityID/'"/>
<xsl:with-param name="element" select="LocalNamespaceEntityID"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/LocalNamespaceEntityID/'"/>
<xsl:with-param name="element" select="LocalNamespaceEntityID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityID/'"/>
<xsl:with-param name="element" select="UniversalEntityID"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(LocalNamespaceEntityID) = 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityID/'"/>
<xsl:with-param name="element" select="UniversalEntityID"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityID/'"/>
<xsl:with-param name="element" select="UniversalEntityID"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityID/'"/>
<xsl:with-param name="element" select="UniversalEntityID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityIDType/'"/>
<xsl:with-param name="element" select="UniversalEntityIDType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="count(UniversalEntityID) &gt; 0">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityIDType/'"/>
<xsl:with-param name="element" select="UniversalEntityIDType"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityIDType/'"/>
<xsl:with-param name="element" select="UniversalEntityIDType"/>
<xsl:with-param name="mbpo" select="''"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'HL7v2HierarchicDesignatorMacro/UniversalEntityIDType/'"/>
<xsl:with-param name="element" select="UniversalEntityIDType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
			<xsl:if test="count(UniversalEntityIDType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'DNS'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'EUI64'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'ISO'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'URI'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'UUID'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'X400'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'X500'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: HL7v2HierarchicDesignatorMacro/UniversalEntityIDType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="UniversalEntityIDType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="UniversalEntityIDType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
		
	</xsl:template>
<xsl:template name="IssuerOfPatientIDMacro">
		<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientID/'"/>
<xsl:with-param name="element" select="IssuerOfPatientID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientID/'"/>
<xsl:with-param name="element" select="IssuerOfPatientID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/'"/>
<xsl:with-param name="element" select="IssuerOfPatientIDQualifiersSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="IssuerOfPatientIDQualifiersSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/UniversalEntityID/'"/>
<xsl:with-param name="element" select="UniversalEntityID"/>
<xsl:with-param name="vr" select="'UT'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/UniversalEntityID/'"/>
<xsl:with-param name="element" select="UniversalEntityID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/UniversalEntityIDType/'"/>
<xsl:with-param name="element" select="UniversalEntityIDType"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/UniversalEntityIDType/'"/>
<xsl:with-param name="element" select="UniversalEntityIDType"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:if test="count(UniversalEntityIDType/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'DNS'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'EUI64'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'ISO'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'URI'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'UUID'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'X400'">T</xsl:when>
<xsl:when test="UniversalEntityIDType/value[@number=1] = 'X500'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/UniversalEntityIDType/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="UniversalEntityIDType"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="UniversalEntityIDType/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/IdentifierTypeCode/'"/>
<xsl:with-param name="element" select="IdentifierTypeCode"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/IdentifierTypeCode/'"/>
<xsl:with-param name="element" select="IdentifierTypeCode"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:if test="count(IdentifierTypeCode/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'AM'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'AN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'ANON'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'ANC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'AND'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'ANT'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'APRN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'BA'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'BC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'BR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'BRN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'CC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'CY'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DDS'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DEA'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DFN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DL'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DPM'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DO'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'DS'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'EI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'EN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'FI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'GI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'GL'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'GN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'HC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'JHN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'IND'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'LI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'LN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'LR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MA'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MB'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MCD'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MCN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MCR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MD'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MRT'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'MS'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NE'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NH'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NII'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NIIP'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NNxxx'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NNUSA'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NP'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'NPI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'OD'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PA'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PCN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PE'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PEN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PNT'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PPN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PRC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PRN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'PT'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'QA'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'RI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'RPH'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'RN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'RR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'RRI'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'SL'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'SN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'SR'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'SS'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'TAX'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'TN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'U'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'UPIN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'VN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'VS'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'WC'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'WCN'">T</xsl:when>
<xsl:when test="IdentifierTypeCode/value[@number=1] = 'XX'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/IdentifierTypeCode/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="IdentifierTypeCode"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="IdentifierTypeCode/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/AssigningFacilitySequence/'"/>
<xsl:with-param name="element" select="AssigningFacilitySequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="AssigningFacilitySequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: HL7v2HierarchicDesignatorMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="HL7v2HierarchicDesignatorMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/AssigningJurisdictionCodeSequence/'"/>
<xsl:with-param name="element" select="AssigningJurisdictionCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="AssigningJurisdictionCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
			<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'IssuerOfPatientIDMacro/IssuerOfPatientIDQualifiersSequence/AssigningAgencyOrDepartmentCodeSequence/'"/>
<xsl:with-param name="element" select="AssigningAgencyOrDepartmentCodeSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="AssigningAgencyOrDepartmentCodeSequence/Item">
				<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: CodeSequenceMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="CodeSequenceMacro"/>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
<xsl:template name="PatientGroupMacro">
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientGroupMacro/SourcePatientGroupIdentificationSequence/'"/>
<xsl:with-param name="element" select="SourcePatientGroupIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="SourcePatientGroupIdentificationSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientGroupMacro/SourcePatientGroupIdentificationSequence/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientGroupMacro/SourcePatientGroupIdentificationSequence/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: IssuerOfPatientIDMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IssuerOfPatientIDMacro"/>
		</xsl:for-each>
		<xsl:call-template name="CheckType3SequenceAttribute">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/'"/>
<xsl:with-param name="element" select="GroupOfPatientsIdentificationSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
<xsl:for-each select="GroupOfPatientsIdentificationSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vr" select="'LO'"/>
</xsl:call-template>
<xsl:call-template name="CheckType2Attribute">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/PatientID/'"/>
<xsl:with-param name="element" select="PatientID"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:if test="$optionDescribeChecking='T'">
<xsl:text>Checking Macro: IssuerOfPatientIDMacro</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
<xsl:call-template name="IssuerOfPatientIDMacro"/>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/SubjectRelativePositionInImage/'"/>
<xsl:with-param name="element" select="SubjectRelativePositionInImage"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/SubjectRelativePositionInImage/'"/>
<xsl:with-param name="element" select="SubjectRelativePositionInImage"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'n'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/PatientPosition/'"/>
<xsl:with-param name="element" select="PatientPosition"/>
<xsl:with-param name="vr" select="'CS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PatientGroupMacro/GroupOfPatientsIdentificationSequence/PatientPosition/'"/>
<xsl:with-param name="element" select="PatientPosition"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:if test="count(PatientPosition/value) &gt; 0">
<xsl:variable name="valuewasfound">
<xsl:choose>
<xsl:when test="PatientPosition/value[@number=1] = 'HFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'HFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'HFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'HFDL'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFDL'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'FFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'LFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'LFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'RFP'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'RFS'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'AFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'AFDL'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'PFDR'">T</xsl:when>
<xsl:when test="PatientPosition/value[@number=1] = 'PFDL'">T</xsl:when>
<xsl:otherwise>F</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:if test="$valuewasfound = 'F'">
<xsl:text>Warning: PatientGroupMacro/GroupOfPatientsIdentificationSequence/PatientPosition/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PatientPosition"/>
</xsl:call-template>
<xsl:text>/value[</xsl:text>
<xsl:value-of select="1"/>
<xsl:text>]: </xsl:text>
<xsl:text>Unrecognized defined term :</xsl:text>
<xsl:value-of select="PatientPosition/value[@number=1]"/>
<xsl:text>:</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
		</xsl:for-each>
	</xsl:template>
<xsl:template name="PixelMeasuresMacro">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/'"/>
<xsl:with-param name="element" select="PixelMeasuresSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="PixelMeasuresSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/PixelSpacing/'"/>
<xsl:with-param name="element" select="PixelSpacing"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/VolumetricProperties/value[@number=1]='VOLUME' or (name(../../..) = 'PerFrameFunctionalGroupsSequence' and ../../MRImageFrameTypeSequence/Item[@number=1]/VolumetricProperties/value[@number=1]='VOLUME') or (name(../../..) = 'SharedFunctionalGroupsSequence' and /DicomObject/PerFrameFunctionalGroupsSequence/Item/MRImageFrameTypeSequence/Item[*]/VolumetricProperties/value[@number=1]='VOLUME') or (/DicomObject/SOPClassUID = '1.2.840.10008.5.1.4.1.1.66.4' and count(/DicomObject/FrameOfReferenceUID) &gt; 0)">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/PixelSpacing/'"/>
<xsl:with-param name="element" select="PixelSpacing"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/PixelSpacing/'"/>
<xsl:with-param name="element" select="PixelSpacing"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/PixelSpacing/'"/>
<xsl:with-param name="element" select="PixelSpacing"/>
<xsl:with-param name="vmmin" select="'2'"/>
<xsl:with-param name="vmmax" select="'2'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
				<xsl:if test="count(PixelSpacing) &gt; 0">
<xsl:if test="number(PixelSpacing/value[@number=1])=0 and //Rows/value &gt; 1">
<xsl:text>Error: PixelMeasuresMacro/PixelMeasuresSequence/PixelSpacing/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelSpacing"/>
</xsl:call-template>
<xsl:text>: first value of 0 is illegal when more than one Row</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
				<xsl:if test="count(PixelSpacing) &gt; 0">
<xsl:if test="number(PixelSpacing/value[@number=2])=0 and //Columns/value &gt; 1">
<xsl:text>Error: PixelMeasuresMacro/PixelMeasuresSequence/PixelSpacing/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="PixelSpacing"/>
</xsl:call-template>
<xsl:text>: second value of 0 is  illegal when more than one Column</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/SliceThickness/'"/>
<xsl:with-param name="element" select="SliceThickness"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/VolumetricProperties/value[@number=1]='VOLUME' or /DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/VolumetricProperties/value[@number=1]='SAMPLED') or (name(../../..) = 'PerFrameFunctionalGroupsSequence' and (../../MRImageFrameTypeSequence/Item[@number=1]/VolumetricProperties/value[@number=1]='VOLUME' or ../../MRImageFrameTypeSequence/Item[@number=1]/VolumetricProperties/value[@number=1]='SAMPLED')) or (name(../../..) = 'SharedFunctionalGroupsSequence' and (/DicomObject/PerFrameFunctionalGroupsSequence/Item/MRImageFrameTypeSequence/Item[*]/VolumetricProperties/value[@number=1]='VOLUME' or /DicomObject/PerFrameFunctionalGroupsSequence/Item/MRImageFrameTypeSequence/Item[*]/VolumetricProperties/value[@number=1]='SAMPLED')) or (/DicomObject/SOPClassUID = '1.2.840.10008.5.1.4.1.1.66.4' and count(/DicomObject/FrameOfReferenceUID) &gt; 0)">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/SliceThickness/'"/>
<xsl:with-param name="element" select="SliceThickness"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/SliceThickness/'"/>
<xsl:with-param name="element" select="SliceThickness"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/SliceThickness/'"/>
<xsl:with-param name="element" select="SliceThickness"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
				<xsl:if test="count(SliceThickness) &gt; 0">
<xsl:if test="number(SliceThickness/value)=0">
<xsl:text>Warning: PixelMeasuresMacro/PixelMeasuresSequence/SliceThickness/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SliceThickness"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/SpacingBetweenSlices/'"/>
<xsl:with-param name="element" select="SpacingBetweenSlices"/>
<xsl:with-param name="vr" select="'DS'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'PixelMeasuresMacro/PixelMeasuresSequence/SpacingBetweenSlices/'"/>
<xsl:with-param name="element" select="SpacingBetweenSlices"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
				<xsl:if test="count(SpacingBetweenSlices) &gt; 0">
<xsl:if test="number(SpacingBetweenSlices/value)=0">
<xsl:text>Warning: PixelMeasuresMacro/PixelMeasuresSequence/SpacingBetweenSlices/: </xsl:text>
<xsl:call-template name="buildFullPathInInstanceToNamedChildOfCurrentNode">
<xsl:with-param name="node" select="SpacingBetweenSlices"/>
</xsl:call-template>
<xsl:text>: value of 0 is not illegal, but is unlikely to be correct</xsl:text>
<xsl:value-of select="$newline"/>
</xsl:if>
</xsl:if>
			
		</xsl:for-each>
	</xsl:template>
<xsl:template name="FrameContentMacro">
		<xsl:call-template name="CheckType1SequenceAttribute">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/'"/>
<xsl:with-param name="element" select="FrameContentSequence"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
<xsl:for-each select="FrameContentSequence/Item">
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameAcquisitionNumber/'"/>
<xsl:with-param name="element" select="FrameAcquisitionNumber"/>
<xsl:with-param name="vr" select="'US'"/>
</xsl:call-template>
<xsl:call-template name="CheckType3Attribute">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameAcquisitionNumber/'"/>
<xsl:with-param name="element" select="FrameAcquisitionNumber"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameReferenceDateTime/'"/>
<xsl:with-param name="element" select="FrameReferenceDateTime"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
<xsl:choose>
<xsl:when test="(/DicomObject/SharedFunctionalGroupsSequence/Item[@number=1]/MRImageFrameTypeSequence/Item[@number=1]/FrameType/value[@number=1]='ORIGINAL' or (name(../../..) = 'PerFrameFunctionalGroupsSequence' and ../../MRImageFrameTypeSequence/Item[@number=1]/FrameType/value[@number=1]='ORIGINAL') or (name(../../..) = 'SharedFunctionalGroupsSequence' and /DicomObject/PerFrameFunctionalGroupsSequence/Item[*]/MRImageFrameTypeSequence/Item[@number=1]/FrameType/value[@number=1]='ORIGINAL')) and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.2.2' and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.4.4' and /DicomObject/SOPClassUID != '1.2.840.10008.5.1.4.1.1.128.1'">
<xsl:call-template name="CheckConditionalAttributeWhenConditionSatisfied">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameReferenceDateTime/'"/>
<xsl:with-param name="element" select="FrameReferenceDateTime"/>
</xsl:call-template>
</xsl:when>
<xsl:otherwise>
<xsl:call-template name="CheckConditionalAttributeWhenConditionNotSatisfied">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameReferenceDateTime/'"/>
<xsl:with-param name="element" select="FrameReferenceDateTime"/>
<xsl:with-param name="mbpo" select="'T'"/>
</xsl:call-template>
</xsl:otherwise>
</xsl:choose>
<xsl:call-template name="CheckType1CAttributeRegardless">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameReferenceDateTime/'"/>
<xsl:with-param name="element" select="FrameReferenceDateTime"/>
<xsl:with-param name="vmmin" select="'1'"/>
<xsl:with-param name="vmmax" select="'1'"/>
<xsl:with-param name="vr" select="'DT'"/>
</xsl:call-template>
			<xsl:call-template name="CheckAttributeVR">
<xsl:with-param name="description" select="'FrameContentMacro/FrameContentSequence/FrameAcquisitionDateTime/'"/>
<xsl:with-param name="element" select="FrameAcquisitionDateTime"/>
<xsl:with-param name="vr" select="