/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

public class HuffmanTable {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/HuffmanTable.java,v 1.4 2014/03/23 11:41:54 dclunie Exp $";
    private int TableClass;
    private int HuffmanTableIdentifier;
    private int[] nHuffmanCodesOfLengthI;
    private int[][] ValueOfHuffmanCodeIJ;
    private int[] BITS = new int[17];
    private int[] HUFFVAL;
    private int[] HUFFSIZE;
    private int[] HUFFCODE;
    private int[] MINCODE = new int[17];
    private int[] MAXCODE = new int[17];
    private int[] VALPTR = new int[17];
    private int EOBCode;
    private int EOBCodeLength;

    public HuffmanTable(int n, int n2, int[] nArray, int[][] nArray2) {
        this.TableClass = n;
        this.HuffmanTableIdentifier = n2;
        this.nHuffmanCodesOfLengthI = nArray;
        this.ValueOfHuffmanCodeIJ = nArray2;
        this.expand();
    }

    private int countNumberOfCodes() {
        int n = 0;
        for (int i = 0; i < this.nHuffmanCodesOfLengthI.length; ++i) {
            n += this.nHuffmanCodesOfLengthI[i];
        }
        return n;
    }

    public int[] getMINCODE() {
        return this.MINCODE;
    }

    public int[] getMAXCODE() {
        return this.MAXCODE;
    }

    public int[] getVALPTR() {
        return this.VALPTR;
    }

    public int[] getHUFFVAL() {
        return this.HUFFVAL;
    }

    public int getEOBCode() {
        return this.EOBCode;
    }

    public int getEOBCodeLength() {
        return this.EOBCodeLength;
    }

    private void expand() {
        int n;
        int n2;
        int n3;
        for (n3 = 1; n3 <= 16; ++n3) {
            this.BITS[n3] = this.nHuffmanCodesOfLengthI[n3 - 1];
        }
        n3 = this.countNumberOfCodes();
        this.HUFFVAL = new int[n3 + 1];
        int n4 = 0;
        for (n2 = 0; n2 < this.nHuffmanCodesOfLengthI.length; ++n2) {
            n = this.nHuffmanCodesOfLengthI[n2];
            if (n <= 0) continue;
            for (int i = 0; i < n; ++i) {
                this.HUFFVAL[n4] = this.ValueOfHuffmanCodeIJ[n2][i];
                ++n4;
            }
        }
        this.HUFFSIZE = new int[n3 + 1];
        n4 = 0;
        n2 = 1;
        n = 1;
        while (true) {
            if (n > this.BITS[n2]) {
                n = 1;
                if (++n2 <= 16) continue;
                break;
            }
            this.HUFFSIZE[n4] = n2;
            ++n4;
            ++n;
        }
        this.HUFFSIZE[n4] = 0;
        this.HUFFCODE = new int[n3 + 1];
        n4 = 0;
        n2 = 0;
        n = this.HUFFSIZE[0];
        while (true) {
            this.HUFFCODE[n4] = n2++;
            if (n == this.HUFFSIZE[++n4]) continue;
            if (this.HUFFSIZE[n4] == 0) break;
            do {
                n2 <<= 1;
            } while (++n != this.HUFFSIZE[n4]);
        }
        n4 = 0;
        n2 = 0;
        while (++n4 <= 16) {
            if (this.BITS[n4] == 0) {
                this.MAXCODE[n4] = -1;
                continue;
            }
            this.VALPTR[n4] = n2;
            this.MINCODE[n4] = this.HUFFCODE[n2];
            n2 = n2 + this.BITS[n4] - 1;
            this.MAXCODE[n4] = this.HUFFCODE[n2];
            ++n2;
        }
        for (n4 = 1; n4 <= 16; ++n4) {
            for (n2 = this.VALPTR[n4]; n2 < this.VALPTR[n4] + this.BITS[n4]; ++n2) {
                if (this.HUFFVAL[n2] != 0) continue;
                this.EOBCode = this.HUFFCODE[n2];
                this.EOBCodeLength = n4;
            }
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Huffman Table:\n");
        stringBuffer.append("\t TableClass = " + this.TableClass + "\n");
        stringBuffer.append("\t HuffmanTableIdentifier = " + this.HuffmanTableIdentifier + "\n");
        for (n = 0; n < 16; ++n) {
            stringBuffer.append("\t\t nHuffmanCodesOfLength " + n + " = " + this.nHuffmanCodesOfLengthI[n] + "\n");
            for (int i = 0; i < this.nHuffmanCodesOfLengthI[n]; ++i) {
                stringBuffer.append("\t\t\t ValueOfHuffmanCode " + i + " = " + this.ValueOfHuffmanCodeIJ[n][i] + "\n");
            }
        }
        stringBuffer.append("\t Expanded:\n");
        for (n = 1; n <= 16; ++n) {
            stringBuffer.append("\t\t[" + n + "] MINCODE=" + Integer.toBinaryString(this.MINCODE[n]) + " MAXCODE=" + Integer.toBinaryString(this.MAXCODE[n]) + " VALPTR=" + this.VALPTR[n] + "\n");
        }
        for (n = 0; n < this.HUFFVAL.length; ++n) {
            stringBuffer.append("\t\t[" + n + "] HUFFVAL=0x" + Integer.toHexString(this.HUFFVAL[n]) + "\n");
        }
        stringBuffer.append("\t\tEOBCode=" + Integer.toBinaryString(this.EOBCode) + " 0x" + Integer.toHexString(this.EOBCode) + " (length " + this.EOBCodeLength + " dec)\n");
        return stringBuffer.toString();
    }
}

