/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.codec.jpeg;

import com.pixelmed.codec.jpeg.QuantizationTable;
import com.pixelmed.codec.jpeg.Utilities;
import java.util.Map;

public class MarkerSegmentDQT {
    private static final String identString = "@(#) $Header: /userland/cvs/codec/com/pixelmed/codec/jpeg/MarkerSegmentDQT.java,v 1.2 2014/03/21 21:46:20 dclunie Exp $";
    private int nTables = 0;
    private int[] QuantizationTableElementPrecision = new int[4];
    private int[] QuantizationTableIdentifier = new int[4];
    private int[][] QuantizationTableElement = new int[4][];

    public MarkerSegmentDQT(byte[] byArray, int n) throws Exception {
        int n2 = 0;
        while (n > 0) {
            if (this.nTables >= 4) {
                throw new Exception("Only 4 tables are permitted");
            }
            this.QuantizationTableElementPrecision[this.nTables] = Utilities.extract8(byArray, n2) >> 4;
            this.QuantizationTableIdentifier[this.nTables] = Utilities.extract8(byArray, n2) & 0xF;
            this.QuantizationTableElement[this.nTables] = new int[64];
            ++n2;
            --n;
            for (int i = 0; i < 64; ++i) {
                if (this.QuantizationTableElementPrecision[this.nTables] > 0) {
                    this.QuantizationTableElement[this.nTables][i] = Utilities.extract16be(byArray, n2);
                    n2 += 2;
                    n -= 2;
                    continue;
                }
                this.QuantizationTableElement[this.nTables][i] = Utilities.extract8(byArray, n2);
                ++n2;
                --n;
            }
            ++this.nTables;
        }
    }

    public void addToMapByIdentifier(Map<String, QuantizationTable> map) {
        for (int i = 0; i < this.nTables; ++i) {
            int n = this.QuantizationTableIdentifier[i];
            String string = Integer.toString(n);
            map.put(string, new QuantizationTable(n, this.QuantizationTableElementPrecision[i], this.QuantizationTableElement[i]));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\tDQT:\n");
        for (int i = 0; i < this.nTables; ++i) {
            stringBuffer.append("\t\t QuantizationTableElementPrecision = " + this.QuantizationTableElementPrecision[i] + "\n");
            stringBuffer.append("\t\t QuantizationTableIdentifier = " + this.QuantizationTableIdentifier[i] + "\n");
            for (int j = 0; j < 64; ++j) {
                stringBuffer.append("\t\t\t QuantizationTableElement " + j + " = " + this.QuantizationTableElement[i][j] + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

